/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.server.http.IcCubeServlet;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestParams;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MimeTypes;
import org.jetbrains.annotations.Nullable;

public class IcCubeServletHolder
extends ServletHolder {
    public static final Logger LOGGER = OlapLoggers.HTTP_REQUEST;
    private final IcCubeServlet servlet;
    private final MultipartConfigElement multiPartConfig;

    public IcCubeServletHolder(IcCubeServlet servlet, MultipartConfigElement multiPartConfig) {
        super((Servlet)servlet);
        this.servlet = servlet;
        this.multiPartConfig = multiPartConfig;
    }

    protected void prepare(ServletRequest request, ServletResponse response) throws ServletException {
        super.prepare(request, response);
        String baseType = HttpField.getValueParameters((String)request.getContentType(), null);
        if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType)) {
            request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.multiPartConfig);
        }
    }

    @Nullable
    private static OlapChattyRequest isChattyRequest(OlapRequestType requestType, ServletRequest request) {
        String[] values;
        if (OlapRequestType.GVI == requestType && (values = request.getParameterValues("action")) != null && values.length == 1) {
            String action = values[0];
            OlapChattyRequest chattyRequest = IcCubeGviServerRequestParams.isChattyRequest(action);
            return chattyRequest;
        }
        return null;
    }

    @Nullable
    private static OlapRequestVerbosity verbosity(ServletRequest request) {
        String[] values = request.getParameterValues(OlapRequestVerbosity.VERBOSITY());
        if (values != null && values.length == 1) {
            return OlapRequestVerbosity.fromParam((String)values[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        long started = System.nanoTime();
        OlapRequestType requestType = this.servlet.getRequestType();
        OlapRequestId requestId = OlapRequestId.next((OlapRequestType)requestType);
        OlapChattyRequest chattyRequest = IcCubeServletHolder.isChattyRequest(requestType, request);
        OlapRequestVerbosity verbosity = IcCubeServletHolder.verbosity(request);
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        OlapRequestTracker.onServletStarted((OlapRequestInfo)requestInfo);
        try {
            OlapRequestId.setThreadRequestId((OlapRequestId)requestId);
            super.handle(request, response);
        }
        finally {
            OlapRequestTracker.onServletDone((OlapRequestInfo)requestInfo);
            long elapsed = System.nanoTime() - started;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("HTTP-request processed in : " + CdTimeUtils.formatNanos((long)elapsed)));
            }
        }
    }
}

