/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.http.IcCubeCrossOriginConfiguration;
import crazydev.iccube.server.http.IcCubeForwardedRequestConfiguration;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="httpComponentConfiguration")
public class IcCubeHttpComponentConfiguration {
    @XmlElement(name="serverThreadMax", required=false)
    private int serverThreadMax = -1;
    @XmlElement(name="serverThreadMin", required=false)
    private int serverThreadMin = -1;
    @XmlElement(name="serverThreadIdleTimeout", required=false)
    private int serverThreadIdleTimeout = -1;
    @XmlElement(name="serverQueueCapacity", required=false)
    private int serverQueueCapacity = -1;
    @XmlElement(name="serverQueueGrowBy", required=false)
    private int serverQueueGrowBy = -1;
    @XmlElement(name="serverQueueMaxCapacity", required=false)
    private int serverQueueMaxCapacity = -1;
    @XmlElement(name="portNumber", required=false)
    private String portNumber = "-1";
    @XmlTransient
    private int validatedPortNumber;
    @XmlElement(name="sslPortNumber", required=false)
    private String sslPortNumber = "-1";
    @XmlTransient
    private int validatedSslPortNumber;
    @XmlElement(name="sslKeyStorePath", required=false)
    private String sslKeyStorePath;
    @XmlElement(name="sslKeyStorePassword", required=false)
    private String sslKeyStorePassword;
    @XmlElement(name="sslKeyStoreType", required=false)
    private String sslKeyStoreType;
    @XmlElement(name="sslKeyManagerPassword", required=false)
    private String sslKeyManagerPassword;
    @XmlElement(name="sslTrustStorePath", required=false)
    private String sslTrustStorePath;
    @XmlElement(name="sslTrustStorePassword", required=false)
    private String sslTrustStorePassword;
    @XmlElement(name="sslTrustStoreType", required=false)
    private String sslTrustStoreType;
    @XmlElement(name="includeCipherSuites", required=false)
    private String includeCipherSuites;
    @XmlElement(name="excludeCipherSuites", required=false)
    private String excludeCipherSuites;
    @XmlElement(name="hostName", required=false)
    @Nullable
    private String hostName = null;
    @XmlElement(name="enableCompression", required=false)
    private boolean enableCompression;
    @XmlElement(name="requestHeaderSize", required=true)
    private int requestHeaderSize = -1;
    @XmlElement(name="responseHeaderSize", required=true)
    private int responseHeaderSize = -1;
    @XmlElement(name="outputBufferSize", required=true)
    private int outputBufferSize = -1;
    @XmlElement(name="maxFormContentSize", required=true)
    private int maxFormContentSize = -1;
    @XmlElement(name="sessionTimeout", required=false)
    private int sessionTimeout = -1;
    @XmlElement(name="idleTimeout", required=false)
    private int idleTimeout = -1;
    @XmlElement(name="forwardedRequestConfiguration", required=false)
    @Nullable
    private IcCubeForwardedRequestConfiguration forwardedRequestConfiguration;
    @XmlElement(name="crossOriginConfiguration", required=false)
    @Nullable
    private IcCubeCrossOriginConfiguration crossOriginConfiguration;

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.portNumber)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"portNumber"});
        }
        String portNumberX = CdConfigurationUtils.substVars((String)this.portNumber);
        this.validatedPortNumber = Integer.parseInt(portNumberX);
        if (CdStringUtils.isNullOrBlank((String)this.sslPortNumber)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"sslPortNumber"});
        }
        String sslPortNumberX = CdConfigurationUtils.substVars((String)this.sslPortNumber);
        this.validatedSslPortNumber = Integer.parseInt(sslPortNumberX);
        if (this.hostName != null) {
            this.hostName = CdConfigurationUtils.substVars((String)this.hostName);
        }
        if (this.forwardedRequestConfiguration != null) {
            this.forwardedRequestConfiguration.validate();
        }
        if (this.crossOriginConfiguration != null) {
            this.crossOriginConfiguration.validate();
        }
        this.onIdeaValidation();
    }

    private void onIdeaValidation() throws OlapConfigurationException {
        this.validatedPortNumber = CdSystemUtils.getIntProperty((String)"httpComponentConfiguration.portNumber", (int)this.validatedPortNumber);
    }

    public int getPortNumber() {
        return this.validatedPortNumber;
    }

    public int getSslPortNumber() {
        return this.validatedSslPortNumber;
    }

    @Nullable
    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    @Nullable
    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    @Nullable
    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public String getSslKeyManagerPassword() {
        return this.sslKeyManagerPassword;
    }

    @Nullable
    public String getSslTrustStorePath() {
        return this.sslTrustStorePath;
    }

    @Nullable
    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    @Nullable
    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    @Nullable
    public String[] getIncludeCipherSuites() {
        if (CdStringUtils.isNullOrBlank((String)this.includeCipherSuites)) {
            return null;
        }
        String[] suites = this.includeCipherSuites.split(",");
        return suites;
    }

    @Nullable
    public String[] getExcludeCipherSuites() {
        if (CdStringUtils.isNullOrBlank((String)this.excludeCipherSuites)) {
            return null;
        }
        String[] suites = this.excludeCipherSuites.split(",");
        return suites;
    }

    @Nullable
    public String getHostName() {
        return CdStringUtils.isNullOrBlank((String)this.hostName) ? null : this.hostName;
    }

    public boolean isCompressionEnabled() {
        return this.enableCompression;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getMaxFormContentSize() {
        return this.maxFormContentSize;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getServerThreadMax(int fallback) {
        if (this.serverThreadMax == -1) {
            return fallback;
        }
        return this.serverThreadMax;
    }

    public int getServerThreadMin(int fallback) {
        if (this.serverThreadMin == -1) {
            return fallback;
        }
        return this.serverThreadMin;
    }

    public int getServerThreadIdleTimeout(int fallback) {
        if (this.serverThreadIdleTimeout == -1) {
            return fallback;
        }
        return this.serverThreadIdleTimeout;
    }

    public int getServerQueueCapacity(int fallback) {
        if (this.serverQueueCapacity == -1) {
            return fallback;
        }
        return this.serverQueueCapacity;
    }

    public int getServerQueueGrowBy(int fallback) {
        if (this.serverQueueGrowBy == -1) {
            return fallback;
        }
        return this.serverQueueGrowBy;
    }

    public int getServerQueueMaxCapacity(int fallback) {
        if (this.serverQueueMaxCapacity == -1) {
            return fallback;
        }
        return this.serverQueueMaxCapacity;
    }

    @Nullable
    public IcCubeForwardedRequestConfiguration getForwardedRequestConfiguration() {
        return this.forwardedRequestConfiguration;
    }

    @Nullable
    public ForwardedRequestCustomizer getForwardedRequestCustomizer() {
        if (this.forwardedRequestConfiguration != null) {
            return this.forwardedRequestConfiguration.asForwardedRequestCustomizer();
        }
        return null;
    }

    @Nullable
    public IcCubeCrossOriginConfiguration getCrossOriginConfiguration() {
        return this.crossOriginConfiguration;
    }
}

