/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.common.exception.CdException;
import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapServletFilterConfiguration;
import crazydev.iccube.configuration.OlapWebAppConfiguration;
import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapHelpServlet;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponent;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingServlet;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.OlapFilterClassLoader;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.authentication.IcCubePrintingAuthenticationServletFilter;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerFilterConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.GviComponent;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.gvi.GviServlet;
import crazydev.iccube.server.http.IcCube404Servlet;
import crazydev.iccube.server.http.IcCubeCrossOriginConfiguration;
import crazydev.iccube.server.http.IcCubeForwardedRequestConfiguration;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.http.IcCubeHttpCrossOriginHandler;
import crazydev.iccube.server.http.IcCubeHttpErrorHandler;
import crazydev.iccube.server.http.IcCubeHttpGzipHandler;
import crazydev.iccube.server.http.IcCubeRequestLog;
import crazydev.iccube.server.http.IcCubeServlet;
import crazydev.iccube.server.http.IcCubeServletHolder;
import crazydev.iccube.server.http.IcCubeWebPubResourceHandler;
import crazydev.iccube.server.print.IcCubePrintComponent;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.print.IcCubePrintServlet;
import crazydev.iccube.server.xmla.IcCubeXmlaComponent;
import crazydev.iccube.server.xmla.IcCubeXmlaComponentConfiguration;
import crazydev.iccube.server.xmla.IcCubeXmlaOverHttpHandler;
import crazydev.iccube.ux.processor.UxComponent;
import crazydev.iccube.ux.processor.conf.UxApiComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxStaticComponentConfiguration;
import crazydev.iccube.ux.processor.servlet.UxApiDevServlet;
import crazydev.iccube.ux.processor.servlet.UxApiServlet;
import crazydev.iccube.ux.processor.servlet.UxRestApiServlet;
import crazydev.iccube.ux.processor.servlet.UxStaticServlet;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.crac.Context;
import org.crac.Resource;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class IcCubeHttpComponent
implements Resource {
    private final CdFatalErrorHandler fatalErrorHandler;
    private final OlapLixContent lixContent;
    private final IcCubeHttpComponentConfiguration configuration;
    @Nullable
    private final OlapWebAppConfiguration webAppConfiguration;
    private final boolean sessionLess;
    private final Server server;
    @Nullable
    private final String host;
    private final int port;
    private final int sslPort;
    @Nullable
    private ServletContextHandler servletContext;
    private int maxFormContentSize = -1;

    public IcCubeHttpComponent(OlapRuntime runtime, CdFatalErrorHandler fatalErrorHandler, Object lix, IcCubeHttpComponentConfiguration configuration, @Nullable OlapWebAppConfiguration webAppConfiguration) {
        Connector sslConnector;
        Connector httpConnector;
        IcCubeCrossOriginConfiguration crossOrigin;
        this.fatalErrorHandler = fatalErrorHandler;
        this.lixContent = (OlapLixContent)lix;
        this.configuration = configuration;
        this.webAppConfiguration = webAppConfiguration;
        this.sessionLess = webAppConfiguration != null && webAppConfiguration.isSessionLess();
        this.host = IcCubeHttpComponent.setupHost(this.lixContent, configuration);
        this.port = IcCubeHttpComponent.setupHttpPort(this.lixContent, configuration);
        this.sslPort = this.lixContent.isSslAvailable() ? IcCubeHttpComponent.setupSslPort(this.lixContent, configuration) : -1;
        int maxThreads = configuration.getServerThreadMax(200);
        int minThreads = configuration.getServerThreadMin(8);
        int threadIdleTimeout = configuration.getServerThreadIdleTimeout(60000);
        int qCapacity = configuration.getServerQueueCapacity(minThreads);
        int qGrowBy = configuration.getServerQueueGrowBy(minThreads);
        int qMaxCapacity = configuration.getServerQueueMaxCapacity(Integer.MAX_VALUE);
        BlockingArrayQueue queue = BlockingArrayQueue.newInstance((int)qCapacity, (int)qMaxCapacity);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, threadIdleTimeout, (BlockingQueue)queue);
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)"Jetty server configuration :");
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)("       session-less : " + this.sessionLess));
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)("         thread-max : " + maxThreads));
        OlapLoggers.HTTP.info((Object)("         thread-min : " + minThreads));
        OlapLoggers.HTTP.info((Object)(" thread-idleTimeout : " + threadIdleTimeout));
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)("     queue-capacity : " + qCapacity));
        OlapLoggers.HTTP.info((Object)("       queue-growBy : " + qGrowBy));
        OlapLoggers.HTTP.info((Object)("  queue-maxCapacity : " + qMaxCapacity));
        IcCubeForwardedRequestConfiguration forwardedRequestConfiguration = configuration.getForwardedRequestConfiguration();
        ForwardedRequestCustomizer forwardedRequestCustomizer = configuration.getForwardedRequestCustomizer();
        if (forwardedRequestConfiguration != null && forwardedRequestCustomizer != null) {
            OlapLoggers.HTTP.info((Object)"");
            OlapLoggers.HTTP.info((Object)"Forwarded Request Customizer : ");
            OlapLoggers.HTTP.info((Object)"");
            OlapLoggers.HTTP.info((Object)("               forwardedOnly : " + forwardedRequestConfiguration.getForwardedOnly()));
            OlapLoggers.HTTP.info((Object)("            proxyAsAuthority : " + forwardedRequestCustomizer.getProxyAsAuthority()));
            OlapLoggers.HTTP.info((Object)("             forwardedHeader : " + forwardedRequestCustomizer.getForwardedHeader()));
            OlapLoggers.HTTP.info((Object)("         forwardedHostHeader : " + forwardedRequestCustomizer.getForwardedHostHeader()));
            OlapLoggers.HTTP.info((Object)("       forwardedServerHeader : " + forwardedRequestCustomizer.getForwardedServerHeader()));
            OlapLoggers.HTTP.info((Object)("        forwardedProtoHeader : " + forwardedRequestCustomizer.getForwardedProtoHeader()));
            OlapLoggers.HTTP.info((Object)("          forwardedForHeader : " + forwardedRequestCustomizer.getForwardedForHeader()));
            OlapLoggers.HTTP.info((Object)("        forwardedHttpsHeader : " + forwardedRequestCustomizer.getForwardedHttpsHeader()));
            OlapLoggers.HTTP.info((Object)(" forwardedSslSessionIdHeader : " + forwardedRequestCustomizer.getForwardedSslSessionIdHeader()));
            OlapLoggers.HTTP.info((Object)("  forwardedCipherSuiteHeader : " + forwardedRequestCustomizer.getForwardedCipherSuiteHeader()));
        }
        if ((crossOrigin = configuration.getCrossOriginConfiguration()) != null) {
            OlapLoggers.HTTP.info((Object)"");
            OlapLoggers.HTTP.info((Object)"Cross Origin Handler : ");
            OlapLoggers.HTTP.info((Object)"");
            OlapLoggers.HTTP.info((Object)("                                allowCredentials : " + crossOrigin.getAllowCredentials()));
            OlapLoggers.HTTP.info((Object)("                                  allowedHeaders : " + crossOrigin.getAllowedHeaders()));
            OlapLoggers.HTTP.info((Object)("                                  allowedMethods : " + crossOrigin.getAllowedMethods()));
            OlapLoggers.HTTP.info((Object)("                           allowedOriginPatterns : " + crossOrigin.getAllowedOriginPatterns()));
            OlapLoggers.HTTP.info((Object)("                     allowedTimingOriginPatterns : " + crossOrigin.getAllowedTimingOriginPatterns()));
            OlapLoggers.HTTP.info((Object)("                        deliverPreflightRequests : " + crossOrigin.getDeliverPreflightRequests()));
            OlapLoggers.HTTP.info((Object)("                 deliverNonAllowedOriginRequests : " + crossOrigin.getDeliverNonAllowedOriginRequests()));
            OlapLoggers.HTTP.info((Object)(" deliverNonAllowedOriginWebSocketUpgradeRequests : " + crossOrigin.getDeliverNonAllowedOriginWebSocketUpgradeRequests()));
            OlapLoggers.HTTP.info((Object)("                                  exposedHeaders : " + crossOrigin.getExposedHeaders()));
            OlapLoggers.HTTP.info((Object)("                                 preflightMaxAge : " + crossOrigin.getPreflightMaxAge()));
        }
        this.server = new Server((ThreadPool)threadPool);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        int size = configuration.getRequestHeaderSize();
        if (size > -1) {
            httpConfiguration.setRequestHeaderSize(size);
        }
        if ((size = configuration.getResponseHeaderSize()) > -1) {
            httpConfiguration.setResponseHeaderSize(size);
        }
        if ((size = configuration.getOutputBufferSize()) > -1) {
            httpConfiguration.setOutputBufferSize(size);
        }
        if (forwardedRequestCustomizer != null) {
            httpConfiguration.setCustomizers(Collections.singletonList(forwardedRequestCustomizer));
        }
        if ((httpConnector = this.setupHttpConnector(this.server, httpConfiguration)) != null) {
            this.server.addConnector(httpConnector);
        }
        Connector connector = sslConnector = this.lixContent.isSslAvailable() ? this.setupHttpsConnector(this.server, httpConfiguration) : null;
        if (sslConnector != null) {
            this.server.addConnector(sslConnector);
        }
        this.server.setErrorHandler((Request.Handler)new IcCubeHttpErrorHandler(runtime.getInstallWebDirectory()));
        this.server.addEventListener((EventListener)((Object)new MyLifeCycleListener(fatalErrorHandler)));
        this.server.setRequestLog((RequestLog)new IcCubeRequestLog());
        for (Connector connector2 : this.server.getConnectors()) {
            OlapLoggers.HTTP.info((Object)"");
            OlapLoggers.HTTP.info((Object)("HTTP connector [" + connector2.getClass().getSimpleName() + "]"));
            OlapLoggers.HTTP.info((Object)"");
            if (!(connector2 instanceof ServerConnector)) continue;
            ServerConnector serverConnector = (ServerConnector)connector2;
            OlapLoggers.HTTP.info((Object)("            host : " + serverConnector.getHost()));
            OlapLoggers.HTTP.info((Object)("            port : " + serverConnector.getPort()));
            OlapLoggers.HTTP.info((Object)("     idleTimeout : " + serverConnector.getIdleTimeout()));
            Collection connectionFactories = serverConnector.getConnectionFactories();
            for (ConnectionFactory connectionFactory : connectionFactories) {
                if (!(connectionFactory instanceof HttpConnectionFactory)) continue;
                OlapLoggers.HTTP.info((Object)("        protocol : " + connectionFactory.getProtocol()));
                HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)connectionFactory;
                HttpConfiguration httpConfiguration2 = httpConnectionFactory.getHttpConfiguration();
                OlapLoggers.HTTP.info((Object)("  request-header : " + httpConfiguration2.getRequestHeaderSize()));
                OlapLoggers.HTTP.info((Object)(" response-header : " + httpConfiguration2.getResponseHeaderSize()));
                OlapLoggers.HTTP.info((Object)("   output-buffer : " + httpConfiguration2.getOutputBufferSize()));
            }
        }
        OlapLoggers.HTTP.info((Object)"");
        CRaCUtils.register((Resource)this, (String)"Jetty");
    }

    @Nullable
    private static String setupHost(Object lix, IcCubeHttpComponentConfiguration configuration) {
        OlapLixContent lixContent = (OlapLixContent)lix;
        String lixHost = lixContent.getHttpHost();
        if (lixHost == null) {
            return configuration.getHostName();
        }
        return lixHost;
    }

    private static int setupHttpPort(Object lix, IcCubeHttpComponentConfiguration configuration) {
        int configurationPort = configuration.getPortNumber();
        if (configurationPort == -1) {
            return -1;
        }
        OlapLixContent lixContent = (OlapLixContent)lix;
        Integer lixPort = lixContent.getHttpPort();
        if (lixPort == null) {
            return configurationPort;
        }
        return lixPort;
    }

    private static int setupSslPort(Object lix, IcCubeHttpComponentConfiguration configuration) {
        int configurationPort = configuration.getSslPortNumber();
        if (configurationPort == -1) {
            return -1;
        }
        OlapLixContent lixContent = (OlapLixContent)lix;
        Integer lixPort = lixContent.getSslPort();
        if (lixPort == null) {
            return configurationPort;
        }
        return lixPort;
    }

    @Nullable
    private Connector setupHttpConnector(Server server, HttpConfiguration httpConfiguration) {
        int idleTimeoutS;
        if (this.port == -1) {
            return null;
        }
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfiguration);
        HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
        ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{http11, http2c});
        httpConnector.setPort(this.port);
        if (this.host != null) {
            httpConnector.setHost(this.host);
        }
        if ((idleTimeoutS = this.configuration.getIdleTimeout()) != -1) {
            httpConnector.setIdleTimeout(TimeUnit.SECONDS.toMillis(idleTimeoutS));
        }
        return httpConnector;
    }

    @Nullable
    private Connector setupHttpsConnector(Server server, HttpConfiguration httpConfiguration) {
        int idleTimeoutS;
        String[] excludeSuites;
        String[] includeSuites;
        String sslKeyManagerPassword;
        if (this.sslPort == -1) {
            return null;
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        String sslKeyStorePath = this.configuration.getSslKeyStorePath();
        String sslKeyStorePassword = this.configuration.getSslKeyStorePassword();
        String sslKeyStoreType = this.configuration.getSslKeyStoreType();
        sslContextFactory.setKeyStorePath(sslKeyStorePath);
        sslContextFactory.setKeyStorePassword(sslKeyStorePassword);
        if (!CdStringUtils.isNullOrBlank((String)sslKeyStoreType)) {
            sslContextFactory.setKeyStoreType(sslKeyStoreType);
        }
        if (!CdStringUtils.isNullOrBlank((String)(sslKeyManagerPassword = this.configuration.getSslKeyManagerPassword()))) {
            sslContextFactory.setKeyManagerPassword(sslKeyManagerPassword);
        }
        String sslTrustStorePath = this.configuration.getSslTrustStorePath();
        String sslTrustStorePassword = this.configuration.getSslTrustStorePassword();
        String sslTrustStoreType = this.configuration.getSslTrustStoreType();
        if (!CdStringUtils.isNullOrBlank((String)sslTrustStorePath)) {
            sslContextFactory.setTrustStorePath(sslTrustStorePath);
            sslContextFactory.setTrustStorePassword(sslTrustStorePassword);
            if (!CdStringUtils.isNullOrBlank((String)sslTrustStoreType)) {
                sslContextFactory.setTrustStoreType(sslTrustStoreType);
            }
        }
        if ((includeSuites = this.configuration.getIncludeCipherSuites()) != null) {
            sslContextFactory.setIncludeCipherSuites(includeSuites);
        }
        if ((excludeSuites = this.configuration.getExcludeCipherSuites()) != null) {
            sslContextFactory.setExcludeCipherSuites(excludeSuites);
        }
        HttpConfiguration httpsConfiguration = new HttpConfiguration(httpConfiguration);
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfiguration);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol("h2");
        String nextProtocol = alpn.getProtocol();
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, nextProtocol);
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfiguration)});
        sslConnector.setPort(this.sslPort);
        if (this.host != null) {
            sslConnector.setHost(this.host);
        }
        if ((idleTimeoutS = this.configuration.getIdleTimeout()) != -1) {
            sslConnector.setIdleTimeout(TimeUnit.SECONDS.toMillis(idleTimeoutS));
        }
        return sslConnector;
    }

    public boolean isSessionLess() {
        return this.sessionLess;
    }

    public IcCubeHttpComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public <T> T getServletContextAttribute(String name) {
        if (this.servletContext != null) {
            Object value = this.servletContext.getAttribute(name);
            return (T)value;
        }
        return null;
    }

    public int getMaxFormContentSize() {
        return this.maxFormContentSize;
    }

    public int getHttpSessionCount() {
        if (this.servletContext == null) {
            return -1;
        }
        SessionHandler sessionHandler = this.servletContext.getSessionHandler();
        SessionCache sessionCache = sessionHandler.getSessionCache();
        if (sessionCache instanceof DefaultSessionCache) {
            DefaultSessionCache sessionCache_ = (DefaultSessionCache)sessionCache;
            long count = sessionCache_.getSessionsCurrent();
            return (int)count;
        }
        return -1;
    }

    @Nullable
    public String getActualListeningHostName() {
        return this.host;
    }

    public void setupHandlers(OlapRuntime runtime, OlapDirectoriesConfiguration directories, IcCubeServerApplicationContext icCubeServerApplicationContext, @Nullable UxComponent uxComponent, @Nullable IcCubeXmlaComponent xmlaComponent, @Nullable OlapReportingComponent reportingComponent, @Nullable GviComponent gviComponent, @Nullable IcCubePrintComponent printComponent) throws CdException {
        Object handler;
        Handler staticResourcesHandlers = this.setupStaticResourcesHandlers(runtime, icCubeServerApplicationContext, directories, reportingComponent);
        ServletContextHandler servletContextHandler = this.setupServletsHandlers(runtime, icCubeServerApplicationContext, uxComponent, xmlaComponent, reportingComponent, gviComponent, printComponent);
        Handler.Sequence handlers = new Handler.Sequence(new Handler[]{staticResourcesHandlers, servletContextHandler});
        boolean withGZip = this.configuration.isCompressionEnabled();
        if (withGZip) {
            IcCubeHttpGzipHandler gzipHandler = new IcCubeHttpGzipHandler();
            gzipHandler.setHandler((Handler)handlers);
            handler = gzipHandler;
        } else {
            handler = handlers;
        }
        IcCubeCrossOriginConfiguration crossOrigin = this.configuration.getCrossOriginConfiguration();
        if (crossOrigin != null) {
            IcCubeHttpCrossOriginHandler cors = new IcCubeHttpCrossOriginHandler(crossOrigin);
            cors.setHandler((Handler)handler);
            handler = cors;
        }
        this.server.setHandler((Handler)handler);
    }

    private Handler setupStaticResourcesHandlers(OlapRuntime runtime, IcCubeServerApplicationContext appContext, OlapDirectoriesConfiguration directories, @Nullable OlapReportingComponent reportingComponent) {
        OlapLoggers.HTTP.info((Object)"Setup Static Resources...");
        Handler.Sequence staticResourcesHandlers = new Handler.Sequence(new Handler[0]);
        String pubPath = directories.getWebPubDirectory().asFile().getAbsolutePath();
        IcCubeWebPubResourceHandler handler = new IcCubeWebPubResourceHandler(reportingComponent != null ? reportingComponent.getConfiguration() : null, pubPath);
        OlapLoggers.HTTP.info((Object)"Static Resource : WebPub %s from %s".formatted(handler.getContextPath(), pubPath));
        staticResourcesHandlers.addHandler((Handler)handler);
        return staticResourcesHandlers;
    }

    private ServletContextHandler setupServletsHandlers(OlapRuntime runtime, IcCubeServerApplicationContext icCubeServerApplicationContext, @Nullable UxComponent uxComponent, @Nullable IcCubeXmlaComponent xmlaComponent, @Nullable OlapReportingComponent reportingComponent, @Nullable GviComponent gviComponent, @Nullable IcCubePrintComponent printComponent) throws CdException {
        int timeout;
        boolean secure;
        String sameSite;
        boolean httpOnly;
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)"WebApp (optional) : ");
        OlapLoggers.HTTP.info((Object)"");
        OlapDirectoriesConfiguration appDirectories = icCubeServerApplicationContext.getDirectoriesConfiguration();
        File tempDirectory = appDirectories.getTmpDirectory().asFile();
        MultipartConfigElement multipartConfig = new MultipartConfigElement(tempDirectory.getAbsolutePath(), -1L, -1L, 4096);
        ServletContextHandler servletContextHandler = new ServletContextHandler(1);
        servletContextHandler.setContextPath("/");
        OlapWebAppConfiguration webAppConfiguration = icCubeServerApplicationContext.getConfiguration().getWebAppConfiguration();
        if (webAppConfiguration != null) {
            List params = webAppConfiguration.getContextParams();
            for (OlapWebAppConfiguration.ContextParam param : params) {
                String name = param.getName();
                String value = param.getValue();
                OlapLoggers.HTTP.info((Object)("  context-param >> " + name + " : " + value));
                servletContextHandler.setInitParameter(name, value);
            }
        }
        SessionHandler sessionHandler = servletContextHandler.getSessionHandler();
        sessionHandler.setSessionIdPathParameterName("none");
        if (webAppConfiguration != null) {
            httpOnly = webAppConfiguration.isSessionCookieHttpOnly();
            sameSite = webAppConfiguration.getSessionCookieSameSite();
            secure = webAppConfiguration.isSessionCookieSecure();
        } else {
            httpOnly = true;
            sameSite = null;
            secure = false;
        }
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)"WebApp Session Cookie : ");
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)("  HttpOnly : " + httpOnly));
        OlapLoggers.HTTP.info((Object)("  SameSite : " + (sameSite != null ? sameSite : "<null>")));
        OlapLoggers.HTTP.info((Object)("  Secure   : " + secure));
        sessionHandler.setHttpOnly(httpOnly);
        if (sameSite != null) {
            sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)sameSite.toUpperCase()));
        }
        if (secure) {
            sessionHandler.getSessionCookieConfig().setSecure(secure);
        }
        if (webAppConfiguration != null && webAppConfiguration.isSessionLess()) {
            sessionHandler.setSessionTrackingModes(Collections.emptySet());
        }
        OlapLoggers.HTTP.info((Object)"");
        OlapLoggers.HTTP.info((Object)"Servlets : ");
        OlapLoggers.HTTP.info((Object)"");
        int maxFormContentSize = this.configuration.getMaxFormContentSize();
        if (maxFormContentSize != -1) {
            servletContextHandler.setMaxFormContentSize(maxFormContentSize);
        }
        this.maxFormContentSize = servletContextHandler.getMaxFormContentSize();
        OlapLoggers.HTTP.info((Object)("  maxFormContentSize : " + servletContextHandler.getMaxFormContentSize()));
        OlapLoggers.HTTP.info((Object)"");
        servletContextHandler.addEventListener((EventListener)((Object)new MyLifeCycleListener(this.fatalErrorHandler)));
        servletContextHandler.setAttribute("icCube.authorizationService", (Object)icCubeServerApplicationContext.getRolePermissionsService());
        servletContextHandler.setAttribute("icCube.authenticationService", (Object)icCubeServerApplicationContext.getAuthenticationService());
        String resourceBase = runtime.getInstallWebDirectory().getAbsolutePath();
        OlapLoggers.HTTP.info((Object)("    static resources : " + resourceBase));
        servletContextHandler.setBaseResourceAsString(resourceBase);
        ServletHandler servletHandler = servletContextHandler.getServletHandler();
        servletHandler.addEventListener((EventListener)((Object)new MyLifeCycleListener(this.fatalErrorHandler)));
        ServletMapping[] allFilters = IcCubeHttpComponent.createFilters(icCubeServerApplicationContext);
        servletHandler.setFilters(allFilters.toArray(new FilterHolder[allFilters.size()]));
        servletHandler.addServletWithMapping(IcCube404Servlet.class, "/");
        this.registerUxStaticServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, uxComponent);
        this.registerUxApiServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, uxComponent);
        if (runtime.isIDEA()) {
            this.registerUxApiDevServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, uxComponent);
        }
        this.registerRestApiServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, uxComponent);
        this.registerXmlaServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, xmlaComponent);
        this.registerReportingServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, reportingComponent);
        this.registerHelpServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, reportingComponent);
        this.registerGviServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, gviComponent);
        this.registerPrintServlet(multipartConfig, servletContextHandler, (List<FilterHolder>)allFilters, printComponent);
        OlapLoggers.HTTP.info((Object)"");
        for (ServletMapping servletMapping : servletHandler.getServletMappings()) {
            OlapLoggers.HTTP.info((Object)("     servlet mapping : " + servletMapping.getServletName()));
            for (String path : servletMapping.getPathSpecs()) {
                OlapLoggers.HTTP.info((Object)("                     : " + path));
            }
        }
        OlapLoggers.HTTP.info((Object)"");
        for (ServletMapping servletMapping : servletHandler.getFilters()) {
            OlapLoggers.HTTP.info((Object)("              filter : " + servletMapping.getName()));
            OlapLoggers.HTTP.info((Object)("                     : " + servletMapping.getClassName()));
            Map initParams = servletMapping.getInitParameters();
            if (initParams == null) continue;
            for (Map.Entry entry : initParams.entrySet()) {
                OlapLoggers.HTTP.info((Object)("                     : " + String.valueOf(entry.getKey()) + " : " + String.valueOf(entry.getValue())));
            }
        }
        OlapLoggers.HTTP.info((Object)"");
        for (ServletMapping servletMapping : servletHandler.getFilterMappings()) {
            String filterName = servletMapping.getFilterName();
            OlapLoggers.HTTP.info((Object)("      filter mapping : " + filterName));
            FilterHolder filter = servletHandler.getFilter(filterName);
            if (filter != null) {
                OlapLoggers.HTTP.info((Object)("              filter : " + filter.getClassName()));
            }
            for (String servletName : servletMapping.getServletNames()) {
                OlapLoggers.HTTP.info((Object)("             servlet : " + servletName));
            }
        }
        servletContextHandler.setAttribute("icCubeServer.applicationContext", (Object)icCubeServerApplicationContext);
        sessionHandler.addEventListener((EventListener)new HttpSessionListener(this){
            {
                Objects.requireNonNull(this$0);
            }

            public void sessionCreated(HttpSessionEvent httpSessionEvent) {
                HttpSession session = httpSessionEvent.getSession();
                if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                    OlapLoggers.SESSIONS.info((Object)("[session] HTTP session created [ " + session.getId() + " ]"));
                }
            }

            public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
                HttpSession session = httpSessionEvent.getSession();
                if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                    OlapLoggers.SESSIONS.info((Object)("[session] HTTP session destroyed [ " + session.getId() + " ]"));
                }
                IcCubeServerSessionContext.onSessionDestroyed(httpSessionEvent.getSession());
            }
        });
        if (OlapLoggers.SESSIONS.isInfoEnabled()) {
            OlapLoggers.SESSIONS.info((Object)"");
        }
        if ((timeout = this.configuration.getSessionTimeout()) > -1) {
            sessionHandler.setMaxInactiveInterval(timeout);
        }
        if (OlapLoggers.SESSIONS.isInfoEnabled()) {
            OlapLoggers.SESSIONS.info((Object)("   session timeout : " + sessionHandler.getMaxInactiveInterval() + "s"));
            OlapLoggers.SESSIONS.info((Object)"");
        }
        this.servletContext = servletContextHandler;
        return servletContextHandler;
    }

    private void registerUxStaticServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable UxComponent uxComponent) throws CdException {
        if (uxComponent == null) {
            return;
        }
        try {
            UxComponentConfiguration configuration = uxComponent.getConfiguration();
            UxStaticComponentConfiguration conf = configuration.getUxStaticConf();
            if (conf == null) {
                return;
            }
            List<String> filterConfiguration = conf.getFilterConfiguration();
            List<FilterHolder> uxFilters = IcCubeHttpComponent.getFilters("UX (api)", allFilters, filterConfiguration);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            UxStaticServlet staticServlet = uxComponent.getStaticServlet();
            if (staticServlet != null) {
                this.registerUxStaticServlet(multipartConfig, servletHandler, uxFilters, staticServlet, staticServlet.getEntryPoint());
            }
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "UX (static) servlet setup error!");
        }
    }

    private void registerUxStaticServlet(MultipartConfigElement multipartConfig, ServletHandler servletHandler, List<FilterHolder> uxFilters, IcCubeServlet servlet, String pathSpec) {
        IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
        servletHandler.addServletWithMapping((ServletHolder)servletHolder, pathSpec);
        for (FilterHolder uxFilter : uxFilters) {
            this.addFilterMapping(servletHandler, servletHolder, uxFilter);
        }
    }

    private void registerUxApiServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable UxComponent uxComponent) throws CdException {
        if (uxComponent == null) {
            return;
        }
        try {
            UxComponentConfiguration configuration = uxComponent.getConfiguration();
            UxApiComponentConfiguration conf = configuration.getUxApiConf();
            if (conf == null) {
                return;
            }
            List<String> filterConfiguration = conf.getFilterConfiguration();
            List<FilterHolder> uxFilters = IcCubeHttpComponent.getFilters("UX (ux-api)", allFilters, filterConfiguration);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            UxApiServlet apiServlet = uxComponent.getApiServlet();
            this.registerUxApiServlet(multipartConfig, servletHandler, uxFilters, apiServlet, apiServlet.getEntryPoint());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "UX (ux-api) servlet setup error!");
        }
    }

    private void registerUxApiServlet(MultipartConfigElement multipartConfig, ServletHandler servletHandler, List<FilterHolder> uxFilters, UxApiServlet servlet, String pathSpec) {
        IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
        servletHandler.addServletWithMapping((ServletHolder)servletHolder, pathSpec);
        for (FilterHolder uxFilter : uxFilters) {
            this.addFilterMapping(servletHandler, servletHolder, uxFilter);
        }
    }

    private void registerUxApiDevServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable UxComponent uxComponent) throws CdException {
        if (uxComponent == null) {
            return;
        }
        ServletHandler servletHandler = servletContextHandler.getServletHandler();
        UxApiDevServlet apiServlet = new UxApiDevServlet();
        IcCubeServletHolder servletHolder = new IcCubeServletHolder(apiServlet, multipartConfig);
        servletHandler.addServletWithMapping((ServletHolder)servletHolder, apiServlet.getEntryPoint());
    }

    private void registerRestApiServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable UxComponent uxComponent) throws CdException {
        if (uxComponent == null) {
            return;
        }
        try {
            UxComponentConfiguration configuration = uxComponent.getConfiguration();
            UxApiComponentConfiguration conf = configuration.getRestApiConf();
            if (conf == null) {
                return;
            }
            List<String> filterConfiguration = conf.getFilterConfiguration();
            List<FilterHolder> uxFilters = IcCubeHttpComponent.getFilters("UX (api)", allFilters, filterConfiguration);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            UxRestApiServlet restApiServlet = uxComponent.getRestApiServlet();
            this.registerRestApiServlet(multipartConfig, servletHandler, uxFilters, restApiServlet, restApiServlet.getEntryPoint());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "UX (api) servlet setup error!");
        }
    }

    private void registerRestApiServlet(MultipartConfigElement multipartConfig, ServletHandler servletHandler, List<FilterHolder> uxFilters, UxRestApiServlet servlet, String pathSpec) {
        IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
        servletHandler.addServletWithMapping((ServletHolder)servletHolder, pathSpec);
        for (FilterHolder uxFilter : uxFilters) {
            this.addFilterMapping(servletHandler, servletHolder, uxFilter);
        }
    }

    private void registerXmlaServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable IcCubeXmlaComponent xmlaComponent) throws CdException {
        if (xmlaComponent == null) {
            return;
        }
        try {
            IcCubeXmlaComponentConfiguration configuration = xmlaComponent.getConfiguration();
            IcCubeXmlaOverHttpHandler servlet = xmlaComponent.getXmlaOverHttpHandler();
            IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            List<FilterHolder> filters = IcCubeHttpComponent.getFilters("XMLA", allFilters, configuration.getHttpFilterConfiguration());
            for (FilterHolder filter : filters) {
                this.addFilterMapping(servletHandler, servletHolder, filter);
            }
            servletHandler.addServletWithMapping((ServletHolder)servletHolder, configuration.getHttpUrl());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "XMLA servlet setup error!");
        }
    }

    private void registerReportingServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable OlapReportingComponent reportingComponent) throws CdException {
        if (reportingComponent == null) {
            return;
        }
        try {
            if (!this.lixContent.isReportServerAvailable()) {
                return;
            }
            OlapReportingComponentConfiguration configuration = reportingComponent.getConfiguration();
            OlapReportingServlet servlet = reportingComponent.getReportingServlet();
            IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            List<FilterHolder> filters = IcCubeHttpComponent.getFilters("Docs", allFilters, configuration.getFilterConfiguration());
            for (FilterHolder filter : filters) {
                this.addFilterMapping(servletHandler, servletHolder, filter);
            }
            List<String> urls = configuration.getUrls();
            this.addServletWithMapping(servletHandler, servletHolder, urls.toArray(new String[0]));
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "Docs servlet setup error!");
        }
    }

    private void registerHelpServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable OlapReportingComponent reportingComponent) throws CdException {
        if (reportingComponent == null) {
            return;
        }
        try {
            if (!this.lixContent.isReportServerAvailable()) {
                return;
            }
            OlapReportingComponentConfiguration configuration = reportingComponent.getConfiguration();
            OlapHelpServlet servlet = reportingComponent.getHelpServlet();
            IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            List<FilterHolder> filters = IcCubeHttpComponent.getFilters("Help", allFilters, configuration.getFilterConfiguration());
            for (FilterHolder filter : filters) {
                this.addFilterMapping(servletHandler, servletHolder, filter);
            }
            servletHandler.addServletWithMapping((ServletHolder)servletHolder, servlet.getEntryPoint());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "Help servlet setup error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServletWithMapping(ServletHandler handler, ServletHolder servlet, String[] pathSpecs) {
        Objects.requireNonNull(servlet);
        Object[] holders = handler.getServlets();
        try {
            ServletHandler servletHandler = handler;
            synchronized (servletHandler) {
                handler.setServlets((ServletHolder[])ArrayUtil.addToArray((Object[])holders, (Object)servlet, ServletHolder.class));
            }
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpecs(pathSpecs);
            handler.setServletMappings((ServletMapping[])ArrayUtil.addToArray((Object[])handler.getServletMappings(), (Object)mapping, ServletMapping.class));
        }
        catch (RuntimeException e) {
            handler.setServlets((ServletHolder[])holders);
            throw e;
        }
    }

    private void registerGviServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable GviComponent gviComponent) throws CdException {
        if (gviComponent == null || !this.lixContent.isGviAvailable()) {
            return;
        }
        try {
            GviComponentConfiguration configuration = gviComponent.getConfiguration();
            GviServlet servlet = gviComponent.getServlet();
            IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            List<FilterHolder> gviFilters = IcCubeHttpComponent.getFilters("GVI", allFilters, configuration.getFilterConfiguration());
            for (FilterHolder gviFilter : gviFilters) {
                this.addFilterMapping(servletHandler, servletHolder, gviFilter);
            }
            servletHandler.addServletWithMapping((ServletHolder)servletHolder, configuration.getUrl());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "GVI servlet setup error!");
        }
    }

    private void registerPrintServlet(MultipartConfigElement multipartConfig, ServletContextHandler servletContextHandler, List<FilterHolder> allFilters, @Nullable IcCubePrintComponent printComponent) throws CdException {
        if (printComponent == null) {
            return;
        }
        try {
            IcCubePrintComponentConfiguration configuration = printComponent.getConfiguration();
            IcCubePrintServlet servlet = printComponent.getServlet();
            IcCubeServletHolder servletHolder = new IcCubeServletHolder(servlet, multipartConfig);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            this.addFilterMapping(servletHandler, servletHolder, IcCubeHttpComponent.getFilter("Print", allFilters, "Print Authentication"));
            servletHandler.addServletWithMapping((ServletHolder)servletHolder, configuration.getUrl());
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "GVI servlet setup error!");
        }
    }

    public static List<FilterHolder> createFilters(IcCubeServerApplicationContext icCubeServerApplicationContext) throws CdException {
        try {
            IcCubeServerConfiguration appConfiguration = icCubeServerApplicationContext.getConfiguration();
            IcCubeServerFilterConfiguration filters = appConfiguration.getFilterConfiguration();
            ArrayList<FilterHolder> holders = new ArrayList<FilterHolder>();
            IcCubePrintComponentConfiguration printConfiguration = appConfiguration.getPrintConfiguration();
            List<Object> params = printConfiguration != null ? printConfiguration.getFilterParams() : Collections.emptyList();
            FilterHolder filterHolder = new FilterHolder((Filter)new IcCubePrintingAuthenticationServletFilter(appConfiguration.getWebAppConfiguration()));
            for (IcCubePrintComponentConfiguration.FilterParam filterParam : params) {
                filterHolder.setInitParameter(filterParam.getName(), filterParam.getValue());
            }
            filterHolder.setName("Print Authentication");
            holders.add(filterHolder);
            OlapLixContent lix = icCubeServerApplicationContext.getOlapEngineComponent().getLixContent();
            OlapFilterClassLoader cl = lix.hasFilters() ? new OlapFilterClassLoader(lix) : null;
            for (OlapServletFilterConfiguration configuration : filters.getFilters()) {
                String string = configuration.getFilterClass();
                try {
                    Class filterClass = null;
                    if (cl != null) {
                        filterClass = cl.loadClass(string);
                        if (!cl.isLoaded(string)) {
                            filterClass = null;
                        }
                    } else {
                        filterClass = Class.forName(string);
                    }
                    if (filterClass == null || !Filter.class.isAssignableFrom(filterClass)) {
                        throw new ServletException("Servlet filter [" + configuration.getFilterName() + "] error: not a filter class [" + string + "]!");
                    }
                    Filter filter = (Filter)filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    FilterHolder filterHolder2 = new FilterHolder(filter);
                    filterHolder2.setName(configuration.getFilterName());
                    for (OlapServletFilterConfiguration.InitParam initParam : configuration.getInitParams()) {
                        filterHolder2.setInitParameter(initParam.getName(), initParam.getValue());
                    }
                    holders.add(filterHolder2);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new ServletException("Servlet filter [" + configuration.getFilterName() + "] error", (Throwable)ex);
                }
            }
            return holders;
        }
        catch (ServletException ex) {
            throw new CdException((Throwable)ex, "Report servlet setup error!");
        }
    }

    public static List<FilterHolder> getFilters(String componentName, List<FilterHolder> filters, List<String> filterNames) throws ServletException {
        if (filterNames == null || filterNames.isEmpty()) {
            throw new ServletException("internal error : missing servlet filter!");
        }
        ArrayList<FilterHolder> holders = new ArrayList<FilterHolder>();
        for (String filterName : filterNames) {
            FilterHolder filter = IcCubeHttpComponent.getFilter(componentName, filters, filterName);
            holders.add(filter);
        }
        return holders;
    }

    private static FilterHolder getFilter(String componentName, List<FilterHolder> filters, String filterName) throws ServletException {
        for (FilterHolder filter : filters) {
            if (!filter.getName().equals(filterName)) continue;
            return filter;
        }
        throw new ServletException("Component [" + componentName + "] servlet filter [" + filterName + "] not found!");
    }

    private void addFilterMapping(ServletHandler servletHandler, ServletHolder servlet, FilterHolder filter) {
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setFilterName(filter.getName());
        filterMapping.setServletName(servlet.getName());
        servletHandler.addFilterMapping(filterMapping);
    }

    public int getListeningPort() {
        return this.port;
    }

    public String getPrintListeningUrl(IcCubePrintComponentConfiguration configuration) {
        String printUrl = configuration.getPrintUrl();
        if (CdStringUtils.isNotNullAndNotBlank((String)printUrl)) {
            if (!printUrl.endsWith("/")) {
                return printUrl + "/";
            }
            return printUrl;
        }
        Object listeningUrl = "";
        if (this.port != -1) {
            listeningUrl = (String)listeningUrl + "http";
        } else if (this.sslPort != -1) {
            listeningUrl = (String)listeningUrl + "https";
        }
        listeningUrl = (String)listeningUrl + "://";
        listeningUrl = CdStringUtils.isNotNullAndNotBlank((String)this.host) ? (String)listeningUrl + this.host : (String)listeningUrl + "localhost";
        listeningUrl = (String)listeningUrl + ":";
        if (this.port != -1) {
            listeningUrl = (String)listeningUrl + this.port;
        } else if (this.sslPort != -1) {
            listeningUrl = (String)listeningUrl + this.sslPort;
        }
        listeningUrl = (String)listeningUrl + "/";
        Object url = configuration.getUrl();
        if (((String)url).startsWith("/")) {
            url = ((String)url).substring(1);
        }
        if (((String)url).endsWith("*")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        listeningUrl = (String)listeningUrl + (String)url;
        return listeningUrl;
    }

    public void start() throws Exception {
        OlapLoggers.HTTP.info((Object)("icCube : listening on [http:" + this.port + "][https:" + this.sslPort + "][host:" + (this.host == null ? "all-interfaces" : this.host) + "]"));
        OlapLoggers.HTTP.info((Object)"");
        this.server.start();
    }

    public void stop() {
        OlapLoggers.HTTP.info((Object)"[HTTP] shutdown requested");
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception ex) {
            OlapLoggers.HTTP.info((Object)"[HTTP] failed to properly shutdown", (Throwable)ex);
        }
        OlapLoggers.HTTP.info((Object)"[HTTP] bye");
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] Jetty before-checkpoint");
        Arrays.asList(this.server.getConnectors()).forEach(c -> LifeCycle.stop((Object)c));
        CRaCUtils.LOG.info("[CRaC] Jetty before-checkpoint completed");
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] Jetty after-restore");
        Arrays.asList(this.server.getConnectors()).forEach(c -> LifeCycle.start((Object)c));
        CRaCUtils.LOG.info("[CRaC] Jetty after-restore completed");
    }

    static class MyLifeCycleListener
    implements LifeCycle.Listener {
        private final CdFatalErrorHandler fatalErrorHandler;

        public MyLifeCycleListener(CdFatalErrorHandler fatalErrorHandler) {
            this.fatalErrorHandler = fatalErrorHandler;
        }

        public void lifeCycleStarting(LifeCycle event) {
        }

        public void lifeCycleStarted(LifeCycle event) {
        }

        public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            this.fatalErrorHandler.handle(cause, -1);
        }

        public void lifeCycleStopping(LifeCycle event) {
        }

        public void lifeCycleStopped(LifeCycle event) {
        }
    }
}

