/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.tidy.serialize;

import com.google.gson.GsonBuilder;
import crazydev.iccube.gvi.GviMaterializedDataTableErrorResponse;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.OlapResDrillthroughStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetT;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetTpp;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.gvi.request.common.GviJsonFileResponse;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.executemdx.GviExecuteMdxQuery;
import crazydev.iccube.server.gvi.request.executemdx.GviResultStoreReferenceKey;
import crazydev.iccube.server.gvi.request.executemdx.GviResultStoreSerializerEx;
import crazydev.iccube.server.gvi.request.executesql.GviExecuteSqlQuery;
import crazydev.iccube.tidytable.sql.SqlTidyTable;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class GviTidySerializerUtils {
    private GviTidySerializerUtils() {
    }

    public static GviResponse asMdxResponseAndCache(OlapEngineRequestContext context, GviExecuteMdxQuery query, @Nullable OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo, @Nullable OlapResultStoreInformation resultInfo, OlapResStatementDataSet result) throws IOException {
        IOlapSerializedTidyResource jsonT = null;
        if (result instanceof OlapResSelectStatementDataSetT) {
            OlapResSelectStatementDataSetT resultT = (OlapResSelectStatementDataSetT)result;
            jsonT = resultT.serializeAsJson(context, resultInfo);
        } else if (result instanceof OlapResSelectStatementDataSetTpp) {
            OlapResSelectStatementDataSetTpp resultTpp = (OlapResSelectStatementDataSetTpp)result;
            jsonT = resultTpp.serializeAsJson(context, resultInfo);
        } else if (result instanceof OlapResDrillthroughStatementDataSet) {
            OlapResDrillthroughStatementDataSet resultDT = (OlapResDrillthroughStatementDataSet)result;
            jsonT = resultDT.serializeAsJson(context, resultInfo);
        }
        if (jsonT != null) {
            if (resultCacheInfo != null && resultCacheInfo.isCacheWriteEnabled()) {
                GviTidySerializerUtils.cacheMdxResult(context, resultCacheInfo, resultInfo, jsonT);
            }
            return new GviJsonFileResponse(jsonT);
        }
        OlapLoggers.MDX_EVALUATION.error((Object)("[mdx] unexpected tidy MDX statement : " + (result == null ? "<null>" : result.getClass().getName())));
        return GviQuery.asError(new GviError(GviErrorCode.MDX_TYPE_UNEXPECTED, new Serializable[0]));
    }

    private static void cacheMdxResult(OlapEngineRequestContext engineRequestContext, OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo, @Nullable OlapResultStoreInformation info, IOlapSerializedTidyResource json) {
        try {
            GviResultStoreReferenceKey resultKey = (GviResultStoreReferenceKey)resultCacheInfo.getResultKey();
            GviResultStoreSerializerEx resultSerializer = new GviResultStoreSerializerEx(info, json);
            OlapResultCache resultCache = resultCacheInfo.getResultCache();
            if (resultCache.addResult(engineRequestContext, (OlapResultStoreReferenceKey)resultKey, (OlapResultStoreSerializer)resultSerializer)) {
                engineRequestContext.onDetailAdded("MDX (cache)", "Result stored into cache");
                if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                    OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX " + engineRequestContext.getRequestId().getId() + " result stored into cache"));
                }
            }
        }
        catch (RuntimeException ex) {
            json.release();
            throw ex;
        }
    }

    public static GviResponse asMdxResponseFromCache(OlapEngineRequestContext context, GviExecuteMdxQuery query, OlapResultStoreInformation resultInfo, OlapResultStoreDeSerializer result) throws IOException {
        IOlapSerializedTidyResource resourceT = OlapSerializedTidyResourceFactory.create((OlapSerializedTidyResourceFactory.Prefix)OlapSerializedTidyResourceFactory.Prefix.mdx, (OlapEngineRequestContext)context, arg_0 -> ((OlapResultStoreDeSerializer)result).read(arg_0));
        return new GviJsonFileResponse(resourceT, resultInfo);
    }

    public static GviResponse asSqlResponse(OlapEngineRequestContext context, GviExecuteSqlQuery query, SqlTidyTable tidyTable) throws IOException {
        IOlapSerializedTidyResource jsonT = tidyTable.serializeAsJson(context);
        return new GviJsonFileResponse(jsonT);
    }

    public static String asErrorResponse(GviMaterializedDataTableErrorResponse table) {
        String jsonE = new GsonBuilder().create().toJson((Object)table.getErrors());
        return "{\"version\":1,\"errors\":" + jsonE + ",\"status\":\"error\"}";
    }
}

