/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.report.GviPrintExQuery;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintReportBatchJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.IcCubePrintState;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class GviPrintReportBatchExQuery
extends GviPrintExQuery {
    private final String reportPath;
    @Nullable
    private final String reportParams;
    @Nullable
    private final IcCubePrintState reportState;

    public GviPrintReportBatchExQuery(String uuid, GviPrintParams printParams, @Nullable IcCubePrintState reportState) {
        super(uuid, printParams);
        this.reportPath = printParams.getReportPath();
        this.reportParams = printParams.getReportParams();
        this.reportState = reportState;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Print Report Batch";
    }

    @Override
    protected GviResponse doExecuteMF(GviQueryContext queryContext, OlapPrincipal principal, IcCubePrintService printService, GviPrintParams printParams) throws InterruptedException {
        if (!printService.isPrintOnServerAvailable()) {
            return new GviGenericErrorResponse(new GviError(GviErrorCode.PRINT_NOT_ENABLED, new Serializable[0]));
        }
        IcCubePrintReportBatchJob job = new IcCubePrintReportBatchJob(printService, queryContext.getRequestClientUUID(), principal, printParams, this.reportState);
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)"[printing] report (batch) printing started (MF)");
        }
        IcCubeRequestStatusManager requests = queryContext.getRequestStatusManager();
        OlapBabylonService babylon = queryContext.getBabylonService();
        IcCubePrintJobResult result = printService.execute(babylon, requests, job);
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)"[printing] report (batch) printing completed (MF)");
        }
        GviResponse response = result.getResponse();
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] report (batch) printing completed (MF) : " + response.getFriendlyType()));
        }
        return response;
    }
}

