/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class GviPrintExQuery
extends GviQuery {
    protected final int timeout;
    protected final Map<String, String> commandLine;
    @Nullable
    protected final GviPrintParams printParams;

    protected GviPrintExQuery(String uuid, GviPrintParams printParams) {
        super(uuid);
        this.timeout = printParams.getTimeout();
        this.commandLine = Collections.emptyMap();
        this.printParams = printParams;
    }

    @Override
    public abstract String getUserFriendlyTypeName();

    @Override
    @Nullable
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    @Override
    public GviResponse execute(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubeServerSessionContext sessionContext = requestContext.getSessionContext();
        IcCubePrintService printService = requestContext.getPrintService();
        if (printService == null) {
            return new GviGenericErrorResponse(new GviError(GviErrorCode.PRINT_NOT_ENABLED, new Serializable[0]));
        }
        OlapPrincipal principal = sessionContext.getUser();
        try {
            GviResponse response = this.doExecuteMF(queryContext, principal, printService, this.printParams);
            return response;
        }
        catch (InterruptedException expected) {
            return new GviGenericErrorResponse(new GviError(GviErrorCode.PRINT_ERROR, new Serializable[]{"cancelled"}));
        }
    }

    protected GviResponse doExecuteMF(GviQueryContext queryContext, OlapPrincipal principal, IcCubePrintService printService, GviPrintParams printParams) throws InterruptedException {
        throw new RuntimeException("internal error: unexpected print request (MF)");
    }
}

