/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.common.collection.CdPair;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapDashboardsFeature;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyUniqueNameStyle;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.gwt.server.reporting.component.OlapReportConfigFileType;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapCubeInfo;
import crazydev.iccube.olap.entity.OlapEntitySubType;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionMeta;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.special.time.OlapTimeDimension;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.eval.set.OlapSetInfoEx;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInfo;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.errors.GviException;
import crazydev.iccube.server.gvi.request.common.errors.GviSchemaNotFoundException;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoCube;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoCubeDimension;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoCubeHierarchy;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoCubeLevel;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoCubeMeasure;
import crazydev.iccube.server.gvi.request.report.meta.GviReportingMetaInfoSet;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperRatio;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSize;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSizes;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.ux.admin.queries.users.UxUserPhotoQueryMeta;
import crazydev.iccube.ux.common.app.UxApp;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GviGetReportingMetaInfoQuery
extends GviSchemaOlapEngineQuery {
    private final boolean withoutSchemaInfo;

    public GviGetReportingMetaInfoQuery(String uuid, @Nullable String schema, boolean withoutSchemaInfo, boolean withWidgetTemplates) {
        super(uuid, schema);
        this.withoutSchemaInfo = withoutSchemaInfo;
    }

    @Override
    public boolean isForMdxConsole() {
        return true;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Get Reporting Meta Info";
    }

    protected boolean isReportingMF() {
        return this.version != null;
    }

    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws OlapMissingSchemaException, GviException {
        SchemaInfoJson schemaJson;
        List<Object> cubesJson;
        List<Object> schemasJson;
        boolean skip;
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubePrintComponentConfiguration printConfiguration = requestContext.getPrintConfiguration();
        OlapEngineRequestContext olapEngineRequestContext = queryContext.getOlapEngineRequestContext();
        boolean bl = skip = this.isReportingMF() && !this.withoutSchemaInfo;
        if (OlapLoggers.GVI_REQUEST_META.isInfoEnabled()) {
            OlapLoggers.GVI_REQUEST_META.info((Object)("[GVI] reporting meta-info [withoutSchemaInfo:" + this.withoutSchemaInfo + "] [schema:" + this.getSchema() + "] [skip:" + skip + "] [print:" + (printConfiguration != null) + "]"));
        }
        Map<String, Object> versionJson = this.setupVersionJson(skip);
        Map<String, Object> featuresJson = this.setupFeaturesJson(requestContext, skip);
        Map<String, Object> appPermsJson = this.setupAppPermsJson(queryContext, skip);
        Map<String, Object> editorInfoJson = this.setupGizmoEditorInfoJson(queryContext, OlapDocsGizmoEntityType.DASHBOARD, skip);
        Map<String, Object> appEditorInfoJson = this.setupGizmoEditorInfoJson(queryContext, OlapDocsGizmoEntityType.APPLICATION, skip);
        Map<String, Object> gadgetEditorInfoJson = this.setupGizmoEditorInfoJson(queryContext, OlapDocsGizmoEntityType.GADGET, skip);
        Map<String, Object> queryEditorInfoJson = this.setupGizmoEditorInfoJson(queryContext, OlapDocsGizmoEntityType.QUERY, skip);
        Map<String, Object> userJson = this.setupUserJson(queryContext, skip);
        Map<String, Object> consoleJson = this.setupConsoleJson(queryContext, skip);
        List<Object> appsJson = this.setupAppsJson(queryContext, skip);
        Map<String, Object> envJson = this.setupEnvJson(queryContext, skip);
        List<Object> localesJson = this.setupLocalesJson(queryContext, skip);
        List<Object> paperSizesJson = this.setupPaperSizesJson(printConfiguration, skip);
        List<Object> paperRatiosJson = this.setupPaperRatiosJson(printConfiguration, this.isReportingMF());
        if (this.withoutSchemaInfo) {
            schemasJson = null;
            cubesJson = null;
            schemaJson = null;
        } else {
            if (this.isReportingMF()) {
                schemasJson = null;
                cubesJson = null;
            } else {
                if (OlapLoggers.GVI_REQUEST_META.isInfoEnabled()) {
                    OlapLoggers.GVI_REQUEST_META.info((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving schema/cube list"));
                }
                List<OlapSchemaInfo> allSchemas = this.getAuthorizedSchemaInfos(olapEngineRequestContext);
                if (OlapLoggers.GVI_REQUEST_META.isInfoEnabled()) {
                    OlapLoggers.GVI_REQUEST_META.info((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving schema/cube list completed"));
                }
                schemasJson = this.setupSchemasJson(allSchemas);
                cubesJson = this.setupCubesJson(allSchemas);
            }
            if (OlapLoggers.GVI_REQUEST.isInfoEnabled()) {
                OlapLoggers.GVI_REQUEST.info((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] setup JSON"));
            }
            schemaJson = this.getSchema() == null ? null : this.setupSchemaJson(olapEngineRequestContext);
        }
        Map<String, Object> aiJson = this.setupAIJson(requestContext, skip);
        Map<String, Object> metaInfoJson = this.setupMetaInfoJson(aiJson, consoleJson, appsJson, envJson, localesJson, versionJson, featuresJson, appPermsJson, editorInfoJson, appEditorInfoJson, gadgetEditorInfoJson, queryEditorInfoJson, userJson, paperSizesJson, paperRatiosJson, schemasJson, cubesJson, schemaJson);
        if (OlapLoggers.GVI_REQUEST.isInfoEnabled()) {
            OlapLoggers.GVI_REQUEST.info((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] setup data-table"));
        }
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("meta-info", "OBJECT", "Meta. Info"));
        GviTableRow row = new GviTableRow();
        row.addCell(metaInfoJson);
        table.addRow(row);
        if (OlapLoggers.GVI_REQUEST.isInfoEnabled()) {
            OlapLoggers.GVI_REQUEST.info((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] completed"));
        }
        return new GviDataTableResponse(queryContext, table);
    }

    private Map<String, Object> setupAIJson(IcCubeServerRequestContext requestContext, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> sb = new HashMap<String, Object>();
        IcCubeAIConfiguration ai = requestContext.getAIConfiguration();
        sb.put("active", ai.isActive());
        if (ai.isActive()) {
            sb.put("requestTimeoutS", ai.getRequestTimeoutS());
            sb.put("systemPrompt", ai.getSystemPrompt());
            sb.put("initialPrompt", ai.getInitialPrompt());
            sb.put("initialPromptPage0", ai.getInitialPromptPage0());
            sb.put("model", ai.getModel());
        }
        return sb;
    }

    @Override
    protected IOlapDocsRequestContext createRepositoryContext(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return new OlapReportRepositoryRequestContext(serverRequestContext, this.version, true);
    }

    @Override
    protected OlapDocsRepository getDocsRepository(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return serverRequestContext.getApplicationContext().getDocsRepository(queryContext.asRuntimeContext());
    }

    private Map<String, Object> setupMetaInfoJson(Map<String, Object> aiJson, Map<String, Object> consoleJson, List<Object> appsJson, Map<String, Object> envJson, List<Object> localesJson, Map<String, Object> versionInfoJson, Map<String, Object> featuresJson, Map<String, Object> appPermsJson, Map<String, Object> editorInfoJson, Map<String, Object> appEditorInfoJson, Map<String, Object> gadgetEditorInfoJson, Map<String, Object> queryEditorInfoJson, Map<String, Object> userInfoJson, List<Object> paperSizesJson, List<Object> paperRatiosJson, List<Object> schemasInfoJson, List<Object> cubesInfoJson, @Nullable SchemaInfoJson schemaInfoJson) {
        HashMap<String, Object> sb = new HashMap<String, Object>();
        sb.put("aiInfo", aiJson);
        sb.put("consoleInfo", consoleJson);
        sb.put("appsInfo", appsJson);
        sb.put("envInfo", envJson);
        sb.put("localesInfo", localesJson);
        sb.put("versionInfo", versionInfoJson);
        sb.put("features", featuresJson);
        sb.put("appPerms", appPermsJson);
        sb.put("editorInfo", editorInfoJson);
        sb.put("appEditorInfo", appEditorInfoJson);
        sb.put("gadgetEditorInfo", gadgetEditorInfoJson);
        sb.put("queryEditorInfo", queryEditorInfoJson);
        sb.put("userInfo", userInfoJson);
        sb.put("paperSizes", paperSizesJson);
        sb.put("paperRatios", paperRatiosJson);
        sb.put("schemasInfo", schemasInfoJson);
        sb.put("cubesInfo", cubesInfoJson);
        if (schemaInfoJson != null) {
            sb.put("schemaInfo", schemaInfoJson);
        }
        return sb;
    }

    private Map<String, Object> setupVersionJson(boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        CdVersion version = IcCubeServerVersion.get();
        HashMap<String, Object> sb = new HashMap<String, Object>();
        sb.put("raw", version.asString());
        sb.put("major", version.major());
        sb.put("minor", version.minor());
        sb.put("patch", version.patch());
        return sb;
    }

    private Map<String, Object> setupFeaturesJson(IcCubeServerRequestContext requestContext, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        IcCubeServerApplicationContext appContext = requestContext.getApplicationContext();
        IcCubeServerConfiguration conf = appContext.getConfiguration();
        OlapReportingComponentConfiguration reporting = conf.getReportingConfiguration();
        OlapReportConfigFileType configurationType = reporting != null ? reporting.getConfigurationType() : null;
        IOlapAuthenticationService authentication = appContext.getAuthenticationService();
        String logoutRedirectUrl = authentication.getLogoutRedirectUrl();
        IcCubePrintService printService = requestContext.getPrintService();
        IcCubePrintComponentConfiguration printConfiguration = printService != null ? printService.getConfiguration() : null;
        Integer printTimeout = printConfiguration != null ? Integer.valueOf(printConfiguration.getTimeout()) : null;
        IcCubeServerProperties props = requestContext.getServerProperties();
        HashMap<String, Object> sb = new HashMap<String, Object>();
        if (requestContext.isSessionLess()) {
            sb.put("sessionLess", true);
        }
        if (configurationType != null) {
            sb.put("configurationType", configurationType.name());
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)logoutRedirectUrl)) {
            sb.put("logoutRedirectUrl", logoutRedirectUrl);
        }
        if (props.isMdxParseMeta()) {
            sb.put("withParseMdx", true);
        }
        OlapEngineSessionContext session = requestContext.getOlapEngineRequestContext().getSessionContext();
        OlapMdxExecutors executors = session.getMdxExecutors();
        int tidyMaterializedAxisTupleCount = executors.getTidyMaterializedAxisTupleCountMax(null);
        int tidyRowCount = executors.getTidyRowCountMax(null);
        int tidyColumnCount = executors.getTidyColumnCountMax(null);
        int tidyCellCount = executors.getTidyCellCountMax(null);
        sb.put("tidyMaterializedAxisTupleCount", tidyMaterializedAxisTupleCount);
        sb.put("tidyRowCount", tidyRowCount);
        sb.put("tidyColumnCount", tidyColumnCount);
        sb.put("tidyCellCount", tidyCellCount);
        sb.put("maxFormContentSize", appContext.getHttpMaxFormContentSize());
        sb.put("printWithMultiPartFormData", true);
        if (printTimeout != null) {
            sb.put("printTimeout", printTimeout);
        }
        return sb;
    }

    private Map<String, Object> setupAppPermsJson(GviQueryContext queryContext, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubePrintService service = requestContext.getPrintService();
        boolean printService = service != null && service.isPrintOnServerAvailable();
        String poweredBy = requestContext.getPoweredBy();
        HashMap<String, Object> sb = new HashMap<String, Object>();
        sb.put("meta", poweredBy);
        sb.put("printServer", printService);
        OlapRolePermissions perms = requestContext.getCurrentPermissions();
        OlapRoleFlatDashboardsProfile dashboards = perms.getDashboardsPermissions();
        ArrayList features = new ArrayList(dashboards.getDeniedFeatures());
        HashMap editorJSON = new HashMap();
        ArrayList<String> featuresJSON = new ArrayList<String>();
        for (OlapDashboardsFeature feature : features) {
            featuresJSON.add(feature.name());
        }
        editorJSON.put("deniedFeatures", featuresJSON);
        sb.put("editor", editorJSON);
        return sb;
    }

    private void addDirInfo(Map<String, Object> sb, String name, String caption, @Nullable String path) {
        if (path != null) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("name", caption);
            obj.put("path", path);
            sb.put(name, obj);
        }
    }

    private Map<String, Object> setupGizmoEditorInfoJson(GviQueryContext queryContext, OlapDocsGizmoEntityType type, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        HashMap<String, Object> sb = new HashMap<String, Object>();
        try {
            Node root = gizmos.gizmosRoot(repositoryContext);
            Node node = gizmos.gizmosRootShared(repositoryContext);
            OlapPath path = node.getPath().relativeTo(root.getPath());
            String sPath = repository.toLogicalSimplePath(repositoryContext, false, path.toSimplePath());
            this.addDirInfo(sb, "shared", babylonService.translate("docsShared", new Serializable[0]), sPath);
            String sPath2 = "myDrive:";
            this.addDirInfo(sb, "myDrive", babylonService.translate("docsMyDrive", new Serializable[0]), "myDrive:");
            if (repositoryContext.isDocAdministrator()) {
                root = gizmos.gizmosRoot(repositoryContext);
                node = gizmos.gizmosRootUsers(repositoryContext);
                path = node.getPath().relativeTo(root.getPath());
                sPath = repository.toLogicalSimplePath(repositoryContext, false, path.toSimplePath());
                this.addDirInfo(sb, "users", babylonService.translate("docsUsers", new Serializable[0]), sPath);
            }
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.GVI_REQUEST_META.error((Object)("[GVI] could not retrieve " + String.valueOf((Object)type) + " editor folders"), (Throwable)((Object)ex));
        }
        return sb;
    }

    private Map<String, Object> setupUserJson(GviQueryContext queryContext, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        OlapEngineRequestContext engineReqContext = queryContext.getOlapEngineRequestContext();
        HashMap<String, Object> sb = new HashMap<String, Object>();
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubeServerSessionContext sessionContext = requestContext.getSessionContext();
        IcCubeServerApplicationContext applicationContext = sessionContext.getApplicationContext();
        String revision = this.getUserRevision(applicationContext);
        sb.put("revision", revision);
        UxUrl userPhoto = UxUserPhotoQueryMeta.UserPhoto.createQueryUrlForReport(engineReqContext.getUserName(), revision);
        String userPhotoUrl = userPhoto.toUrl();
        sb.put("photo", userPhotoUrl);
        OlapTenant userTenant = engineReqContext.getUserTenant();
        if (userTenant != null) {
            sb.put("tenant", userTenant.getName());
        }
        sb.put("name", engineReqContext.getUserName());
        sb.put("role", engineReqContext.getUserRoleName());
        String authType = engineReqContext.getUser().getAuthType();
        sb.put("authType", authType);
        Locale locale = engineReqContext.getSessionContext().getUserLocale();
        sb.put("locale", locale.toString());
        Separators separators = Separators.getSeparators(engineReqContext, locale);
        sb.put("decimalSeparator", separators.decimalSeparator);
        sb.put("thousandSeparator", separators.thousandSeparator);
        OlapRoleApplicationPermissions perms = engineReqContext.getApplicationPermissions();
        String dashboard = perms.getDashboardJavascriptInfo();
        sb.put("perms", dashboard);
        if (requestContext.isAdministrator() || requestContext.isDocAdministrator()) {
            sb.put("adminPerms", "editor");
        }
        String application = perms.getDashboardApplicationJavascriptInfo();
        sb.put("applicationPerms", application);
        String dataSources = perms.getDashboardDataSourcesJavascriptInfo();
        sb.put("dataSourcesPerms", dataSources);
        String gadget = perms.getGadgetJavascriptInfo();
        sb.put("gadgetPerms", gadget);
        if (perms.isMdxIdeEnabled()) {
            sb.put("mdxConsolePerms", "writer");
        }
        return sb;
    }

    private String getUserRevision(IcCubeServerApplicationContext applicationContext) {
        return applicationContext.getUserRevision();
    }

    private List<Object> setupPaperSizesJson(@Nullable IcCubePrintComponentConfiguration conf, boolean skip) {
        IcCubePaperSizes paperSizes;
        if (skip) {
            return new ArrayList<Object>();
        }
        List<Object> papers = conf != null ? ((paperSizes = conf.getPaperSizes()) != null ? paperSizes.getPaperSizes() : Collections.emptyList()) : Collections.emptyList();
        ArrayList<Object> sb = new ArrayList<Object>();
        for (IcCubePaperSize paper : papers) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", paper.getName());
            obj.put("name", paper.getName());
            obj.put("width", paper.getWidthEx());
            obj.put("height", paper.getHeightEx());
            obj.put("marginTop", paper.getMarginTopEx());
            obj.put("marginBottom", paper.getMarginBottomEx());
            obj.put("marginLeft", paper.getMarginLeftEx());
            obj.put("marginRight", paper.getMarginRightEx());
            obj.put("units", paper.getUnit());
            sb.add(obj);
        }
        return sb;
    }

    private List<Object> setupPaperRatiosJson(@Nullable IcCubePrintComponentConfiguration conf, boolean skip) {
        List<Object> ratios;
        if (skip) {
            return new ArrayList<Object>();
        }
        if (conf != null) {
            IcCubePaperSizes papers = conf.getPaperSizes();
            ratios = papers.getRatios();
        } else {
            ratios = new ArrayList();
        }
        ArrayList<Object> sb = new ArrayList<Object>();
        for (IcCubePaperRatio icCubePaperRatio : ratios) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("name", icCubePaperRatio.getName());
            obj.put("ratio", icCubePaperRatio.getRatio());
            sb.add(obj);
        }
        return sb;
    }

    private List<Object> setupSchemasJson(List<OlapSchemaInfo> allSchemas) {
        ArrayList<Object> sb = new ArrayList<Object>();
        for (OlapSchemaInfo schema : allSchemas) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("uniqueName", schema.getName());
            obj.put("name", schema.getName());
            sb.add(obj);
        }
        return sb;
    }

    private List<Object> setupCubesJson(List<OlapSchemaInfo> allSchemas) {
        ArrayList<Object> sb = new ArrayList<Object>();
        for (OlapSchemaInfo schema : allSchemas) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("schema", schema.getName());
            obj.put("cubes", this.doSetupCubesJson(schema.getCubes()));
            sb.add(obj);
        }
        return sb;
    }

    private List<Object> doSetupCubesJson(List<OlapCubeInfo> cubes) {
        ArrayList<Object> sb = new ArrayList<Object>();
        for (OlapCubeInfo cube : cubes) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("uniqueName", cube.getName());
            obj.put("name", cube.getName());
            obj.put("caption", cube.getCaption());
            sb.add(obj);
        }
        return sb;
    }

    private OlapRoleApplicationPermissions getApplicationPermissions(GviQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        return engineRequestContext.getApplicationPermissions();
    }

    private boolean isAppAdminEnabled(GviQueryContext queryContext) {
        OlapRoleApplicationPermissions perms = this.getApplicationPermissions(queryContext);
        return perms.isMonitoringEnabled() || perms.isAlertEnabled() || perms.isReportDocManagementEnabled();
    }

    private boolean isAppBuilderEnabled(GviQueryContext queryContext) {
        OlapRoleApplicationPermissions perms = this.getApplicationPermissions(queryContext);
        return perms.isBuilderEnabled();
    }

    private boolean isAppMdxIdeEnabled(GviQueryContext queryContext) {
        OlapRoleApplicationPermissions perms = this.getApplicationPermissions(queryContext);
        return perms.isMdxIdeEnabled();
    }

    private boolean isAppReportingEnabled(GviQueryContext queryContext) {
        OlapRoleApplicationPermissions perms = this.getApplicationPermissions(queryContext);
        return perms.isReportingEnabled();
    }

    private Map<String, Object> setupAppJson(UxApp app) {
        HashMap<String, Object> sb = new HashMap<String, Object>();
        sb.put("id", app.id);
        sb.put("caption", app.caption);
        sb.put("url", app.url.toUrl());
        sb.put("enabled", app.enabled);
        return sb;
    }

    private Map<String, Object> setupConsoleJson(GviQueryContext queryContext, boolean skip) {
        if (skip) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> sb = new HashMap<String, Object>();
        String consoleURL = UxUrlConstants.APP_URL_CONSOLE.toUrl() + "/";
        sb.put("url", consoleURL);
        return sb;
    }

    private List<Object> setupAppsJson(GviQueryContext queryContext, boolean skip) {
        if (skip) {
            return new ArrayList<Object>();
        }
        Locale locale = queryContext.getOlapEngineRequestContext().getLocale();
        UxBabylonService babylon = new UxBabylonService(UxApi.REST, locale);
        ArrayList<Object> sb = new ArrayList<Object>();
        sb.add(this.setupAppJson(new UxApp("admin", babylon.translate("appAdmin", new Serializable[0]), UxUrlConstants.APP_URL_ADMIN, this.isAppAdminEnabled(queryContext))));
        sb.add(this.setupAppJson(new UxApp("builder", babylon.translate("appBuilder", new Serializable[0]), UxUrlConstants.APP_URL_BUILDER, this.isAppBuilderEnabled(queryContext))));
        sb.add(this.setupAppJson(new UxApp("mdxConsole", babylon.translate("appMdxConsole", new Serializable[0]), UxUrlConstants.APP_URL_MDX, this.isAppMdxIdeEnabled(queryContext))));
        sb.add(this.setupAppJson(new UxApp("dashboards", babylon.translate("appDashboards", new Serializable[0]), UxUrlConstants.APP_URL_DASHBOARDS, this.isAppReportingEnabled(queryContext))));
        sb.add(this.setupAppJson(new UxApp("help", babylon.translate("appHelp", new Serializable[0]), UxUrlConstants.APP_URL_HELP, true)));
        return sb;
    }

    private Map<String, Object> setupEnvJson(GviQueryContext queryContext, boolean skip) {
        OlapTenant tenant;
        if (skip) {
            return new HashMap<String, Object>();
        }
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubeServerApplicationContext applicationContext = requestContext.getApplicationContext();
        IcCubeServerConfiguration configuration = applicationContext.getConfiguration();
        String envName = configuration.getEnvironmentName();
        String envColor = configuration.getEnvironmentColor();
        String tenantName = null;
        if (queryContext.isWithMultiTenant() && (tenant = queryContext.getUserTenant()) != null) {
            tenantName = tenant.getName();
        }
        HashMap<String, Object> sb = new HashMap<String, Object>();
        sb.put("name", envName);
        if (tenantName != null) {
            sb.put("tenant", tenantName);
        }
        sb.put("color", envColor);
        return sb;
    }

    private List<Object> setupLocalesJson(GviQueryContext queryContext, boolean skip) {
        if (skip) {
            return new ArrayList<Object>();
        }
        Locale[] locales = Locale.getAvailableLocales();
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        ArrayList<CdPair> infos = new ArrayList<CdPair>();
        for (Locale locale : locales) {
            String localeInternalName = locale.toString();
            if (CdStringUtils.isNullOrBlank((String)localeInternalName)) continue;
            String caption = locale.getDisplayName(locale);
            Separators separators = Separators.getSeparators(requestContext, locale);
            infos.add(new CdPair((Object)localeInternalName, (Object)new LocaleInfo(localeInternalName, caption, separators.decimalSeparator, separators.thousandSeparator)));
        }
        infos.sort(Comparator.comparing(o -> ((LocaleInfo)o.snd).caption));
        ArrayList<Object> sb = new ArrayList<Object>();
        for (CdPair locale : infos) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("locale", (String)locale.fst);
            obj.put("caption", ((LocaleInfo)locale.snd).caption);
            obj.put("decimalSeparator", ((LocaleInfo)locale.snd).decimalSeparator);
            obj.put("thousandSeparator", ((LocaleInfo)locale.snd).thousandSeparator);
            sb.add(obj);
        }
        return sb;
    }

    private SchemaInfoJson setupSchemaJson(OlapEngineRequestContext olapEngineRequestContext) throws GviSchemaNotFoundException {
        if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
            OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving schema meta-info"));
        }
        try {
            List sets;
            List<OlapCube> cubes;
            OlapSchema schema = this.getExistingLoadedSchema(olapEngineRequestContext, IcCubeSchemaAccessLockMode.READ);
            IOlapSchemaPermission schemaPermission = olapEngineRequestContext.getSchemaPermissions(schema);
            OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle = schema.getDefinitionFactory().getHierarchyUniqueNameStyle();
            String measuresName = "Measures";
            String measuresCaption = schema.getLocalization().getCaptionEx(olapEngineRequestContext.getLocale(), "[Measures]", "Measures");
            Date schemaLastRefreshTimestamp = schema.getNullableLastRefreshTime();
            Date schemaLastDataUpdateTimestamp = schema.getNullableLastDataUpdatedTime();
            SchemaInfoJson json = new SchemaInfoJson(this.getSchema(), schemaLastRefreshTimestamp, schemaLastDataUpdateTimestamp, hierarchyUniqueNameStyle, "Measures", measuresCaption);
            if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube(s)"));
            }
            if ((cubes = this.getLoadedCubes(olapEngineRequestContext, IcCubeSchemaAccessLockMode.READ)) != null) {
                for (OlapCube cube : cubes) {
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] meta-info"));
                    }
                    IOlapCubePermission cPerms = schemaPermission.getCubePermissions(cube);
                    IOlapDimensionsPermission dPerms = schemaPermission.getDimensionsPermissions(cube);
                    OlapNameContext namingContext = dPerms.getNamingContext(olapEngineRequestContext.getNameContext());
                    ArrayList<GviReportingMetaInfoCubeDimension> dimensionsMETA = new ArrayList<GviReportingMetaInfoCubeDimension>();
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] dimensions"));
                    }
                    List dimensions = cube.getDimensionsMeta(olapEngineRequestContext.getLocale(), cPerms, dPerms);
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] hierarchies"));
                    }
                    Set<String> uniqueHierarchies = this.setupUniqueHierarchies(dPerms, olapEngineRequestContext.getLocale(), namingContext, dimensions);
                    for (OlapDimensionMeta dimension : dimensions) {
                        boolean isVisible;
                        boolean mapped = !dimension.measureGroupNames.isEmpty();
                        boolean bl = isVisible = !dimension.dimension.isFactIndexing() || dimension.dimension.isAlwaysVisibleReporting();
                        if (!mapped && !isVisible) continue;
                        if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                            OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] dimension [" + dimension.dimension.getNameX() + "]"));
                        }
                        dimensionsMETA.add(this.setupDimension(olapEngineRequestContext, olapEngineRequestContext.getLocale(), namingContext, schema, cube, dPerms, uniqueHierarchies, dimension));
                    }
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] measures"));
                    }
                    List measures = cube.getMeasuresDimension().getMeasureMembers(dPerms.getMemberFilter());
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] calculated members"));
                    }
                    List<OlapMember> calcMembers = this.getCubeCalcMembers(olapEngineRequestContext, cube, dPerms.getMemberFilter());
                    if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                        OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] measures & calc.measures completed"));
                    }
                    GviReportingMetaInfoCube meta = this.setupCube(olapEngineRequestContext.getLocale(), namingContext, cube, dimensionsMETA, measures, calcMembers);
                    json.cubes.add(meta);
                }
            }
            if ((sets = schema.getSetDeclarations(schemaPermission)) != null) {
                for (OlapSetDeclaration set : sets) {
                    String setName = set.getSetName();
                    String setCaption = set.getSetCaption(olapEngineRequestContext.getLocale(), schema);
                    String cubeName = set.getCubeName();
                    String displayFolder = set.getDisplayFolder();
                    String setDescription = set.getSetDescription(olapEngineRequestContext.getLocale(), schema);
                    OlapSetInfoEx info = schema.getSetInfoEx((OlapNameContext)olapEngineRequestContext.getNameContext(), schemaPermission, set);
                    GviReportingMetaInfoSet meta = new GviReportingMetaInfoSet(setName, setCaption, cubeName, displayFolder, setDescription, info != null ? info.estimatedSize : null, info != null && info.dimensionality != null && !info.dimensionality.isEmpty() ? info.dimensionality : null);
                    json.sets.add(meta);
                }
            }
            if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
                OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving schema meta-info completed"));
            }
            return json;
        }
        catch (OlapMissingSchemaException ex) {
            throw new GviSchemaNotFoundException(ex.getSchemaName());
        }
    }

    private Set<String> setupUniqueHierarchies(IOlapDimensionsPermission dimensionsPermission, Locale locale, OlapNameContext namingContext, List<OlapDimensionMeta> dimensions) {
        HashMap<String, Integer> captions = new HashMap<String, Integer>();
        for (OlapDimensionMeta meta : dimensions) {
            IOlapDimensionPermission permission = dimensionsPermission.getDimensionPermissions(meta.dimension);
            List hierarchies = meta.dimension.getHierarchies(permission);
            for (OlapHierarchy hierarchy : hierarchies) {
                String caption = hierarchy.getCaption(locale, namingContext);
                Integer count = (Integer)captions.get(caption);
                if (count == null) {
                    captions.put(caption, 1);
                    continue;
                }
                captions.put(caption, count + 1);
            }
        }
        HashSet<String> uniques = new HashSet<String>();
        for (Map.Entry entry : captions.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            uniques.add((String)entry.getKey());
        }
        return uniques;
    }

    private GviReportingMetaInfoCube setupCube(Locale locale, OlapNameContext nameContext, OlapCube cube, List<GviReportingMetaInfoCubeDimension> dimensions, List<OlapMeasureMember> measures, List<OlapMember> calcMembers) {
        String caption = cube.getCaption(locale, nameContext);
        String name = cube.getName(nameContext);
        ArrayList<GviReportingMetaInfoCubeMeasure> measuresMETA = new ArrayList<GviReportingMetaInfoCubeMeasure>();
        for (OlapMeasureMember measure : measures) {
            measuresMETA.add(this.setupMeasure(locale, nameContext, measure));
        }
        for (int idx = 0; idx < calcMembers.size(); ++idx) {
            OlapMember member = calcMembers.get(idx);
            if (!member.isMeasure()) continue;
            measuresMETA.add(this.setupCalcMeasure(locale, nameContext, cube, member));
        }
        return new GviReportingMetaInfoCube(caption, name, name, dimensions, measuresMETA);
    }

    private GviReportingMetaInfoCubeDimension setupDimension(OlapEngineRequestContext context, Locale locale, OlapNameContext nameContext, OlapSchema schema, OlapCube cube, IOlapDimensionsPermission dimensionsPermission, Set<String> uniqueHierarchies, OlapDimensionMeta meta) {
        OlapTimeDimension dimensionT;
        Locale definedLocale;
        OlapDimension dimension = meta.dimension;
        GviReportingMetaInfoCubeDimension dim = new GviReportingMetaInfoCubeDimension();
        dim.put("dimensionalityIndex", dimension.getTupleDimensionalityIndex());
        if (dimension instanceof OlapTimeDimension && (definedLocale = (dimensionT = (OlapTimeDimension)dimension).getLocale()) != null) {
            dim.put("definedTimeLocale", definedLocale.toString());
        }
        dim.put("rowCount", dimension.rowCount());
        dim.put("uniqueName", dimension.getUniqueName(nameContext));
        dim.put("name", dimension.getName(nameContext));
        dim.put("caption", dimension.getCaption(locale, nameContext));
        String description = dimension.getDescription(locale);
        if (CdStringUtils.isNotNullAndNotBlank((String)description)) {
            dim.put("description", description);
        }
        if (!meta.measureGroupNames.isEmpty()) {
            dim.put("measureGroupNames", new ArrayList(meta.measureGroupNames));
            dim.put("measureGroupCaptions", new ArrayList(meta.measureGroupCaptions));
        }
        ArrayList<GviReportingMetaInfoCubeHierarchy> hierarchiesMETA = new ArrayList<GviReportingMetaInfoCubeHierarchy>();
        IOlapDimensionPermission permission = dimensionsPermission.getDimensionPermissions(dimension);
        if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
            OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] hierarchies"));
        }
        List hierarchies = dimension.getHierarchies(permission);
        for (OlapHierarchy hierarchy : hierarchies) {
            hierarchiesMETA.add(this.setupHierarchy(context, locale, nameContext, schema, cube, dimensionsPermission, permission, uniqueHierarchies, hierarchy));
        }
        dim.put("hierarchies", hierarchiesMETA);
        return dim;
    }

    private GviReportingMetaInfoCubeHierarchy setupHierarchy(OlapEngineRequestContext context, Locale locale, OlapNameContext nameContext, OlapSchema schema, OlapCube cube, IOlapDimensionsPermission permissions, IOlapDimensionPermission dimensionPermission, Set<String> uniqueHierarchies, OlapHierarchy hierarchy) {
        OlapMember defaultMember;
        OlapMember allMember;
        OlapHierarchy isAttributeOfHierarchy;
        String folderName;
        GviReportingMetaInfoCubeHierarchy meta = new GviReportingMetaInfoCubeHierarchy();
        if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
            OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] hierarchy [" + hierarchy.getNameX() + "]"));
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(folderName = hierarchy.getFolderName()))) {
            meta.put("folderName", folderName);
        }
        boolean aggrMemberOnly = !hierarchy.aggrFactsOnAncestors();
        meta.put("aggrMemberOnly", aggrMemberOnly);
        meta.put("dimensionalityIndex", hierarchy.getTupleDimensionalityIndex());
        Locale definedLocale = hierarchy.getLocale();
        if (definedLocale != null) {
            meta.put("definedTimeLocale", definedLocale.toString());
        }
        if ((isAttributeOfHierarchy = hierarchy.getAttributeOfHierarchy()) != null) {
            meta.put("isAttributeOfHierarchy", isAttributeOfHierarchy.getUniqueName(nameContext));
            meta.put("isAttributeOfHierarchyName", isAttributeOfHierarchy.getName(nameContext));
            meta.put("isAttributeOfHierarchyCaption", isAttributeOfHierarchy.getCaption(locale, nameContext));
        }
        meta.put("base", hierarchy.isBase());
        meta.put("uniqueName", hierarchy.getUniqueName(nameContext));
        String hCaption = hierarchy.getCaption(locale, nameContext);
        meta.put("name", hierarchy.getName(nameContext));
        meta.put("caption", hCaption);
        String description = hierarchy.getDescription(locale);
        if (CdStringUtils.isNotNullAndNotBlank((String)description)) {
            meta.put("description", description);
        }
        if (uniqueHierarchies.contains(hCaption)) {
            meta.put("nameUnique", 1);
        }
        if ((allMember = hierarchy.getAllMember()) != null) {
            HashMap<String, String> am = new HashMap<String, String>();
            am.put("uniqueName", allMember.getUniqueName(nameContext));
            meta.put("allMember", am);
        }
        if ((defaultMember = hierarchy.getNullableDefaultMember(permissions.getMemberFilter())) != null && !OlapMember.equal((OlapMember)defaultMember, (OlapMember)allMember)) {
            HashMap<String, String> dm = new HashMap<String, String>();
            dm.put("uniqueName", defaultMember.getUniqueName(nameContext));
            meta.put("defaultMember", dm);
        }
        int[] counts = new int[]{0, 0};
        ArrayList<GviReportingMetaInfoCubeLevel> levelsMETA = new ArrayList<GviReportingMetaInfoCubeLevel>();
        OlapMemberFilter memberFilter = permissions.getMemberFilter();
        IOlapHierarchyPermission permission = dimensionPermission.getHierarchyPermission(hierarchy);
        List levels = hierarchy.getLevels(permission);
        if (OlapLoggers.GVI_REQUEST_META.isDebugEnabled()) {
            OlapLoggers.GVI_REQUEST_META.debug((Object)("[GVI] reporting meta-info [schema:" + this.getSchema() + "] retrieving cube [" + cube.getNameX() + "] levels [" + levels.size() + "] [" + (memberFilter != null) + "]"));
        }
        for (OlapLevel level : levels) {
            levelsMETA.add(this.setupLevel(context, locale, nameContext, schema, memberFilter, level, counts));
        }
        meta.put("levels", levelsMETA);
        meta.put("membersCount", counts[0]);
        meta.put("calcMembersCount", counts[1]);
        return meta;
    }

    private List<OlapMember> getSchemaCalcMembers(OlapEngineRequestContext context, OlapSchema schema, @Nullable OlapMemberFilter tupleFilter) {
        OlapSchemaCalculatedMemberManager schemaCalcMemberManager = schema.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)schemaCalcMemberManager);
        List calcMembers = calcMemberManager.getVisibleCalculatedMembers(tupleFilter);
        return calcMembers;
    }

    private List<OlapMember> getCubeCalcMembers(OlapEngineRequestContext context, OlapCube cube, @Nullable OlapMemberFilter filter) {
        OlapSchema schema = cube.getSchema();
        OlapCubeCalculatedMemberManager cubeCalcMemberManager = cube.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)cubeCalcMemberManager);
        List calcMembers = calcMemberManager.getVisibleCalculatedMembers(filter);
        return calcMembers;
    }

    private GviReportingMetaInfoCubeLevel setupLevel(OlapEngineRequestContext context, Locale locale, OlapNameContext nameContext, OlapSchema schema, @Nullable OlapMemberFilter memberFilter, OlapLevel level, int[] counts) {
        List<OlapHierarchy> hierarchies;
        OlapLevel hLevel;
        GviReportingMetaInfoCubeLevel meta = new GviReportingMetaInfoCubeLevel();
        int membersCount = level.getMemberCount(memberFilter);
        List<OlapMember> calcMembers = this.getSchemaCalcMembers(context, schema, memberFilter);
        int calcMembersCount = 0;
        for (OlapMember calcMember : calcMembers) {
            if (!calcMember.getLevel().equals((Object)level)) continue;
            ++calcMembersCount;
        }
        meta.put("uniqueName", level.getUniqueName(nameContext));
        meta.put("name", level.getName(nameContext));
        meta.put("caption", level.getCaption(locale, nameContext));
        String description = level.getDescription(locale);
        if (CdStringUtils.isNotNullAndNotBlank((String)description)) {
            meta.put("description", description);
        }
        meta.put("key", level.getKeyForReportingMetaInfo());
        meta.put("keyUC", level.isStringKeyUpperCase());
        OlapLevelType levelType = level.getLevelType();
        if (levelType != null) {
            meta.put("levelType", levelType.name());
        }
        if ((hLevel = level.getHollowLevel()) != null) {
            meta.put("hollowOfLevelName", "[" + CdMdxUtils.escape((String)hLevel.getHierarchy().getName(nameContext)) + "].[" + CdMdxUtils.escape((String)hLevel.getName(nameContext)) + "]");
            meta.put("hollowOfLevelCaption", "[" + CdMdxUtils.escape((String)hLevel.getHierarchy().getCaption(locale, nameContext)) + "].[" + CdMdxUtils.escape((String)hLevel.getCaption(locale, nameContext)) + "]");
        }
        if (level.getHierarchy().isBase() && !(hierarchies = level.getDimension().getHierarchies().stream().filter(hierarchy -> !hierarchy.isBase() && level.hasOneRelationWithBase(hierarchy)).toList()).isEmpty()) {
            ArrayList<String> ahn = new ArrayList<String>();
            for (OlapHierarchy olapHierarchy : hierarchies) {
                ahn.add(olapHierarchy.getName(nameContext));
            }
            meta.put("attributeHierarchyNames", ahn);
            ArrayList<String> ahc = new ArrayList<String>();
            for (OlapHierarchy hierarchy3 : hierarchies) {
                ahc.add(hierarchy3.getCaption(locale, nameContext));
            }
            meta.put("attributeHierarchyCaptions", ahc);
        }
        meta.put("property", level.getMemberPropertiesForReportingMetaInfo());
        ArrayList props = new ArrayList();
        List properties = level.getMemberProperties(memberFilter);
        for (OlapUserDefinedMemberProperty olapUserDefinedMemberProperty : properties) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("name", olapUserDefinedMemberProperty.getName());
            prop.put("type", olapUserDefinedMemberProperty.getInputType().name());
            prop.put("isAttribute", olapUserDefinedMemberProperty.isAttribute());
            props.add(prop);
        }
        meta.put("properties", props);
        meta.put("isAll", level.isAll());
        meta.put("membersCount", membersCount);
        meta.put("calcMembersCount", calcMembersCount);
        counts[0] = counts[0] + membersCount;
        counts[1] = counts[1] + calcMembersCount;
        return meta;
    }

    private GviReportingMetaInfoCubeMeasure setupMeasure(Locale locale, OlapNameContext nameContext, OlapMeasureMember measure) {
        String dp;
        GviReportingMetaInfoCubeMeasure meta = new GviReportingMetaInfoCubeMeasure();
        meta.put("dataType", measure.getCubeDataType().getShortName());
        meta.put("aggregationType", measure.getHierarchyAggregationType().name());
        OlapHierarchy hierarchyR = measure.getRollupHierarchy();
        if (hierarchyR != null) {
            meta.put("rollupHierarchyName", "[" + CdMdxUtils.escape((String)hierarchyR.getDimension().getName(nameContext)) + "].[" + CdMdxUtils.escape((String)hierarchyR.getName(nameContext)) + "]");
            meta.put("rollupHierarchyCaption", "[" + CdMdxUtils.escape((String)hierarchyR.getDimension().getCaption(locale, nameContext)) + "].[" + CdMdxUtils.escape((String)hierarchyR.getCaption(locale, nameContext)) + "]");
        }
        meta.put("measureGroupRowCount", measure.getFactManager().sizeInRowsEx());
        meta.put("measureGroupPartitionCount", measure.getFactManager().partitionCount());
        if (measure.measureHasNullsInFactColumns()) {
            meta.put("measureGroupHasNull", true);
        }
        GviGetReportingMetaInfoQuery.setupNonEmptyBehavior(meta, (OlapMember)measure);
        GviGetReportingMetaInfoQuery.setupCellProperties(meta, (OlapMember)measure);
        String description = measure.getDescription(locale);
        if (CdStringUtils.isNotNullAndNotBlank((String)description)) {
            meta.put("description", description);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(dp = measure.getDisplayFolder(locale, nameContext)))) {
            meta.put("displayFolder", dp);
        }
        meta.put("uniqueName", measure.getUniqueName(nameContext));
        meta.put("name", measure.getName(nameContext));
        meta.put("caption", measure.getCaption(locale, nameContext));
        meta.put("measureGroupName", measure.getMeasureGroupName());
        meta.put("measureGroupCaption", measure.getMeasureGroupCaption(locale, nameContext));
        return meta;
    }

    private GviReportingMetaInfoCubeMeasure setupCalcMeasure(Locale locale, OlapNameContext nameContext, OlapCube cube, OlapMember measure) {
        GviReportingMetaInfoCubeMeasure meta = new GviReportingMetaInfoCubeMeasure();
        String dp = measure.getDisplayFolder(locale, nameContext);
        GviGetReportingMetaInfoQuery.setupNonEmptyBehavior(meta, measure);
        GviGetReportingMetaInfoQuery.setupCellProperties(meta, measure);
        if (CdStringUtils.isNotNullAndNotBlank((String)dp)) {
            meta.put("displayFolder", dp);
        }
        meta.put("uniqueName", measure.getUniqueName(nameContext));
        meta.put("name", measure.getName(nameContext));
        meta.put("caption", measure.getCaption(locale, nameContext));
        try {
            String mg = measure.getAssociatedMeasureGroup();
            if (mg != null) {
                OlapFactMeasureGroupBaseManager facts = cube.getFactManager(mg);
                String measureGroupName = facts.getMeasureGroupName();
                OlapSchema schema = cube.getSchema();
                OlapSchemaLocalization localization = schema.getLocalization();
                String measureGroupCaption = localization.getMeasureGroupCaption(locale, cube, measureGroupName);
                meta.put("measureGroupName", measureGroupName);
                meta.put("measureGroupCaption", !CdStringUtils.isNullOrBlank((String)measureGroupCaption) ? measureGroupCaption : measureGroupName);
            }
        }
        catch (RuntimeException ignored) {
            OlapLoggers.GVI_REQUEST_META.warn((Object)("Could not retrieved the measure group name of [" + measure.getNameX() + "]"), (Throwable)ignored);
        }
        meta.put("subType", OlapEntitySubType.CALCULATED.getShortName());
        return meta;
    }

    private static void setupNonEmptyBehavior(GviReportingMetaInfoCubeMeasure sb, OlapMember measure) {
        String definedNonEmptyBehaviorInfo = null;
        S_NonEmptyBehavior definedNonEmptyBehavior = measure.getDefinedNonEmptyBehavior();
        if (definedNonEmptyBehavior != null) {
            definedNonEmptyBehaviorInfo = definedNonEmptyBehavior.asMdxResult().value();
        }
        if (definedNonEmptyBehaviorInfo != null) {
            sb.put("definedNonEmptyBehavior", definedNonEmptyBehaviorInfo);
        }
    }

    private static void setupCellProperties(GviReportingMetaInfoCubeMeasure sb, OlapMember measure) {
        OlapCellProperties props = measure.getCellProperties();
        if (props != null) {
            Boolean isCached;
            if (props.isEmptyIsZeroDefined() && props.isEmptyIsZero()) {
                sb.put("isEmptyZero", true);
            }
            if ((isCached = props.isCached()) != null && isCached.booleanValue()) {
                sb.put("isCached", true);
            }
        }
    }

    static class SchemaInfoJson {
        final String name;
        @Nullable
        final Long schemaLastRefreshTimestamp;
        @Nullable
        final String schemaLastRefreshTime_ISO_8601;
        @Nullable
        final Long schemaLastDataUpdateTimestamp;
        @Nullable
        final String schemaLastDataUpdateTime_ISO_8601;
        final String hierarchyUniqueNameStyle;
        final String measuresName;
        final String measuresCaption;
        final List<GviReportingMetaInfoSet> sets = new ArrayList<GviReportingMetaInfoSet>();
        final List<GviReportingMetaInfoCube> cubes = new ArrayList<GviReportingMetaInfoCube>();

        public SchemaInfoJson(String name, @Nullable Date schemaLastRefreshTimestamp, @Nullable Date schemaLastDataUpdateTimestamp, OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle, String measuresName, String measuresCaption) {
            this.name = name;
            if (schemaLastRefreshTimestamp != null) {
                this.schemaLastRefreshTimestamp = schemaLastRefreshTimestamp.getTime();
                this.schemaLastRefreshTime_ISO_8601 = CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastRefreshTimestamp);
            } else {
                this.schemaLastRefreshTimestamp = null;
                this.schemaLastRefreshTime_ISO_8601 = null;
            }
            if (schemaLastDataUpdateTimestamp != null) {
                this.schemaLastDataUpdateTimestamp = schemaLastDataUpdateTimestamp.getTime();
                this.schemaLastDataUpdateTime_ISO_8601 = CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastDataUpdateTimestamp);
            } else {
                this.schemaLastDataUpdateTimestamp = null;
                this.schemaLastDataUpdateTime_ISO_8601 = null;
            }
            this.hierarchyUniqueNameStyle = hierarchyUniqueNameStyle.name();
            this.measuresName = measuresName;
            this.measuresCaption = measuresCaption;
        }
    }

    public static class Separators {
        public final String decimalSeparator;
        public final String thousandSeparator;

        public Separators(String decimalSeparator, String thousandSeparator) {
            this.decimalSeparator = decimalSeparator;
            this.thousandSeparator = thousandSeparator;
        }

        public static Separators getSeparators(OlapEngineRequestContext context, Locale locale) {
            locale = context.getLocaleForFormattingNumeric(locale);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return new Separators(String.valueOf(symbols.getDecimalSeparator()), String.valueOf(symbols.getGroupingSeparator()));
        }
    }

    static class LocaleInfo {
        public final String localeInternalName;
        public final String caption;
        public final String decimalSeparator;
        public final String thousandSeparator;

        public LocaleInfo(String localeInternalName, String caption, String decimalSeparator, String thousandSeparator) {
            this.localeInternalName = localeInternalName;
            this.caption = caption;
            this.decimalSeparator = decimalSeparator;
            this.thousandSeparator = thousandSeparator;
        }
    }
}

