/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.report.GviAbstractReportQuery;
import crazydev.iccube.server.request.processor.print.IcCubePrintServletHttpSession;
import jakarta.servlet.http.HttpSession;

public class GviFetchReportPatchesQuery
extends GviAbstractReportQuery {
    public GviFetchReportPatchesQuery(String uuid) {
        super(uuid);
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Fetch Report Patches";
    }

    @Override
    protected void assertAccessRights(OlapRoleApplicationPermissions perms) throws OlapRoleAuthorizationException {
        this.assertReadAccess(perms);
    }

    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws OlapDocsErrorException {
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] fetching report patches");
        }
        String reportPatches = null;
        IcCubeServerSessionContext sessionContext = queryContext.getIcCubeServerRequestContext().getSessionContext();
        HttpSession session = sessionContext.getHttpSession();
        if (session instanceof IcCubePrintServletHttpSession) {
            IcCubePrintServletHttpSession printSession = (IcCubePrintServletHttpSession)session;
            reportPatches = printSession.getReportPatches();
            if (reportPatches == null) {
                if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                    OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] fetching report patches: none");
                }
            } else if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] fetching report patches: ok");
            }
        }
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("report-patches", "Report Patches"));
        GviTableRow row = new GviTableRow();
        row.addCell(reportPatches == null ? "" : reportPatches);
        table.addRow(row);
        return new GviDataTableResponse(queryContext, table);
    }
}

