/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import crazydev.common.credentials.CdCredentials;
import crazydev.common.gvi.GviConstants;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityMode;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoSaveMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.server.gvi.request.chat.GviAIChat;
import crazydev.iccube.server.gvi.request.chat.GviAIChatCompletionQuery;
import crazydev.iccube.server.gvi.request.chat.GviAIConfiguration;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.executemdx.GviExecuteMdxQuery;
import crazydev.iccube.server.gvi.request.executesql.GviExecuteSqlQuery;
import crazydev.iccube.server.gvi.request.getmembers.GviLoginQuery;
import crazydev.iccube.server.gvi.request.parseMdx.GviParseMdxQuery;
import crazydev.iccube.server.gvi.request.parser.GviQueryParserException;
import crazydev.iccube.server.gvi.request.report.GviCancelActiveRequestsQuery;
import crazydev.iccube.server.gvi.request.report.GviCreateGizmoFolderQuery;
import crazydev.iccube.server.gvi.request.report.GviDeleteGizmoFolderQuery;
import crazydev.iccube.server.gvi.request.report.GviDeleteGizmoQuery;
import crazydev.iccube.server.gvi.request.report.GviFetchReportPatchesQuery;
import crazydev.iccube.server.gvi.request.report.GviFetchReportStateQuery;
import crazydev.iccube.server.gvi.request.report.GviGetGizmoQuery;
import crazydev.iccube.server.gvi.request.report.GviGetReportingMetaInfoQuery;
import crazydev.iccube.server.gvi.request.report.GviListGizmoNamesQuery;
import crazydev.iccube.server.gvi.request.report.GviMoveGizmoFolderQuery;
import crazydev.iccube.server.gvi.request.report.GviMoveGizmoQuery;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.gvi.request.report.GviPrintReportBatchExQuery;
import crazydev.iccube.server.gvi.request.report.GviSaveGizmoQuery;
import crazydev.iccube.server.gvi.request.report.GviSchemaDataUpdateReportQuery;
import crazydev.iccube.server.gvi.request.report.GviSearchGizmoNamesQuery;
import crazydev.iccube.server.request.processor.print.IcCubePrintState;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestParams;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.map.HashedMap;
import org.jetbrains.annotations.Nullable;

public abstract class GviQueryParser {
    private GviQueryParser() {
    }

    public static void logHttpParameter(@Nullable OlapChattyRequest chattyRequest, @Nullable OlapRequestVerbosity verbosity, String name, String value) {
        if (OlapLoggers.GVI_REQUEST.isDebugEnabled() && OlapLoggers.isDebugEnabled((OlapChattyRequest)chattyRequest, (OlapRequestVerbosity)verbosity)) {
            if (value != null && ((String)value).length() > 1024) {
                value = ((String)value).substring(0, 1024) + "...";
            }
            OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] request parameter [" + name + "] = " + (String)value));
        }
        if ("action".equals(name) && "getReportingMetaInfo".equals(value)) {
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] dashboard request [%s]".formatted(value));
        }
    }

    public static GviQuery parseQuery(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        GviConstants.Action action = GviQueryParser.parseAction(httpParams);
        CdVersion clientVersion = GviQueryParser.parseOptionalVersionParam(httpParams, action, GviConstants.Param.version);
        GviQuery query = GviQueryParser.parseQuery(httpParams, clientVersion, action);
        query.setVersion(clientVersion);
        String rootVersion = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.rootVersion);
        query.setRootVersion(rootVersion);
        String locale = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.locale);
        query.setLocale(locale);
        Long timestamp = GviQueryParser.parseOptionalLongParam(httpParams, action, GviConstants.Param.timestamp);
        query.setTimestamp(timestamp);
        String windowUid = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.windowUId);
        query.setWindowUid(windowUid);
        String widgetUid = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.widgetUId);
        query.setWidgetUid(widgetUid);
        boolean noAutoCancel = GviQueryParser.parseOptionalBooleanParamEx(httpParams, action, GviConstants.Param.noAutoCancel, false);
        query.setNoAutoCancel(noAutoCancel);
        String reportUUID = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.requestReportUUID);
        query.setReportUUID(reportUUID);
        String auditReportPath = GviQueryParser.parseOptionalParam(httpParams, action, GviConstants.Param.auditReportPath);
        query.setAuditReportPath(auditReportPath);
        return query;
    }

    private static GviQuery parseQuery(IcCubeGviServerRequestParams httpParams, @Nullable CdVersion clientVersion, GviConstants.Action action) throws GviQueryParserException {
        switch (action) {
            case aiWidgetChatCompletion: {
                return GviQueryParser.parseAIWidgetChatCompletion(httpParams);
            }
            case cancelActiveRequests: {
                return GviQueryParser.parseCancelActiveRequests(httpParams);
            }
            case createGizmoFolder: {
                return GviQueryParser.parseCreateGizmoFolder(httpParams);
            }
            case deleteGizmo: {
                return GviQueryParser.parseDeleteGizmo(httpParams);
            }
            case deleteGizmoFolder: {
                return GviQueryParser.parseDeleteGizmoFolder(httpParams);
            }
            case executeMdx: {
                return GviQueryParser.parseExecuteMdx(httpParams, clientVersion);
            }
            case executeSql: {
                return GviQueryParser.parseExecuteSql(httpParams);
            }
            case fetchReportPatches: {
                return GviQueryParser.parseFetchReportPatches(httpParams);
            }
            case fetchReportState: {
                return GviQueryParser.parseFetchReportState(httpParams);
            }
            case getGizmo: {
                return GviQueryParser.parseGetGizmo(httpParams);
            }
            case getReportingMetaInfo: {
                return GviQueryParser.parseGetReportingMetaInfo(httpParams);
            }
            case listGizmoNames: {
                return GviQueryParser.parseListGizmoNames(httpParams);
            }
            case saveGizmo: {
                return GviQueryParser.parseSaveGizmo(httpParams);
            }
            case searchGizmoNames: {
                return GviQueryParser.parseSearchGizmoNames(httpParams);
            }
            case login: {
                return GviQueryParser.parseLogin(httpParams);
            }
            case moveGizmo: {
                return GviQueryParser.parseMoveGizmo(httpParams);
            }
            case moveGizmoFolder: {
                return GviQueryParser.parseMoveGizmoFolder(httpParams);
            }
            case parseMdx: {
                return GviQueryParser.parseParseMdx(httpParams, clientVersion);
            }
            case printReportBatchEx: {
                return GviQueryParser.parsePrintReportBatchEx(httpParams, clientVersion);
            }
            case schemaDataUpdate: {
                return GviQueryParser.parseSchemaDataUpdate(httpParams);
            }
        }
        throw new GviQueryParserException("unsupported query type '" + action.name() + "' (i.e., 'action' HTTP params)");
    }

    static GviQuery parseGetReportingMetaInfo(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String schema = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.getReportingMetaInfo, GviConstants.Param.schema);
        boolean withoutSchemaInfo = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.getReportingMetaInfo, GviConstants.Param.withoutSchemaInfo, false);
        boolean withWidgetTemplates = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.getReportingMetaInfo, GviConstants.Param.withWidgetTemplates, true);
        return new GviGetReportingMetaInfoQuery(uuid, schema, withoutSchemaInfo, withWidgetTemplates);
    }

    static GviLoginQuery parseLogin(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String userInformation = GviQueryParser.parseParam(httpParams, GviConstants.Action.login, GviConstants.Param.userName);
        boolean userNameCheck = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.login, GviConstants.Param.userNameCheck, false);
        CdCredentials credentials = CdCredentials.extractCredentials((String)userInformation, null);
        return new GviLoginQuery(uuid, credentials.userName, userNameCheck);
    }

    static GviAIChatCompletionQuery parseAIWidgetChatCompletion(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        GviAIChat chat;
        GviAIConfiguration configuration;
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        try {
            String configurationV = GviQueryParser.getHttpParam(httpParams, GviConstants.Param.configuration);
            Gson gson = new GsonBuilder().create();
            configuration = (GviAIConfiguration)gson.fromJson(configurationV, GviAIConfiguration.class);
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUEST.error((Object)"Configuration JSON error", (Throwable)ex);
            throw new GviQueryParserException("Configuration JSON error : " + ex.getMessage());
        }
        try {
            String chatV = GviQueryParser.getHttpParam(httpParams, GviConstants.Param.chat);
            Gson gson = new GsonBuilder().create();
            chat = (GviAIChat)gson.fromJson(chatV, GviAIChat.class);
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUEST.error((Object)"Chat JSON error", (Throwable)ex);
            throw new GviQueryParserException("Chat JSON error : " + ex.getMessage());
        }
        return new GviAIChatCompletionQuery(uuid, configuration, chat);
    }

    static GviParseMdxQuery parseParseMdx(IcCubeGviServerRequestParams httpParams, @Nullable CdVersion clientVersion) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String schema = GviQueryParser.parseParam(httpParams, GviConstants.Action.parseMdx, GviConstants.Param.schema);
        String cube = GviQueryParser.parseParam(httpParams, GviConstants.Action.parseMdx, GviConstants.Param.cube);
        String mdx = GviQueryParser.parseOptionalParamEx(httpParams, GviConstants.Action.parseMdx, GviConstants.Param.mdx, "");
        int version = GviQueryParser.parseIntegerParam(httpParams, GviConstants.Action.parseMdx, GviConstants.Param.mdxVersion);
        return new GviParseMdxQuery(uuid, schema, cube, mdx, version);
    }

    static GviExecuteMdxQuery parseExecuteMdx(IcCubeGviServerRequestParams httpParams, @Nullable CdVersion clientVersion) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String schema = GviQueryParser.parseParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.schema);
        boolean script = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.script, false);
        String mdxDebug = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.mdxDebug);
        String debug = mdxDebug != null && !"-1".equals(mdxDebug) ? mdxDebug : null;
        String mdxO = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.mdx);
        String mdx = mdxO != null ? mdxO : "";
        Integer cellCountMax = GviQueryParser.parseOptionalIntegerParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.cellCountMax);
        Integer tidyMaxRowCount = GviQueryParser.parseOptionalIntegerParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.tidyMaxRowCount);
        Integer timeout_ = GviQueryParser.parseOptionalIntegerParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.timeout);
        Integer timeoutS_ = GviQueryParser.parseOptionalIntegerParam(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.timeoutS);
        Integer timeoutS = timeoutS_ != null ? timeoutS_ : timeout_;
        String[] initialSelection = GviQueryParser.parseOptionalParamArr(httpParams, GviConstants.Action.executeMdx, GviConstants.Param.initialSelection);
        String initialSelectionV = GviQueryParser.getHttpParam(httpParams, GviConstants.Param.initialSelection);
        return new GviExecuteMdxQuery(uuid, schema, script, debug, mdx, initialSelection, initialSelectionV, cellCountMax, tidyMaxRowCount, timeoutS);
    }

    static GviExecuteSqlQuery parseExecuteSql(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String schema = GviQueryParser.parseParam(httpParams, GviConstants.Action.executeSql, GviConstants.Param.schema);
        String jdbcDataSourceName = GviQueryParser.parseParam(httpParams, GviConstants.Action.executeSql, GviConstants.Param.jdbcDataSourceName);
        String sql_ = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.executeSql, GviConstants.Param.sql);
        String sql = sql_ != null ? sql_ : "";
        Integer tidyMaxRowCount = GviQueryParser.parseOptionalIntegerParam(httpParams, GviConstants.Action.executeSql, GviConstants.Param.tidyMaxRowCount);
        return new GviExecuteSqlQuery(uuid, schema, jdbcDataSourceName, sql, tidyMaxRowCount);
    }

    static GviQuery parseCancelActiveRequests(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        long timestamp = GviQueryParser.parseLongParam(httpParams, GviConstants.Action.cancelActiveRequests, GviConstants.Param.timestamp);
        String windowUId = GviQueryParser.parseParam(httpParams, GviConstants.Action.cancelActiveRequests, GviConstants.Param.windowUId);
        String widgetUId = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.cancelActiveRequests, GviConstants.Param.widgetUId);
        return new GviCancelActiveRequestsQuery(uuid, timestamp, windowUId, widgetUId);
    }

    @Nullable
    private static String parsePrintParameterString(GviConstants.Action query, String parameter, @Nullable String value) {
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            return value;
        }
        return null;
    }

    @Nullable
    private static Double parsePrintParameterDouble(GviConstants.Action query, String parameter, @Nullable String value) throws GviQueryParserException {
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new GviQueryParserException("Error parsing double HTTP parameter '" + parameter + "' with value '" + value + "' for query '" + query.name() + "' : " + ex.getMessage());
            }
        }
        return null;
    }

    @Nullable
    private static Integer parsePrintParameterInteger(GviConstants.Action query, String parameter, @Nullable String value) throws GviQueryParserException {
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new GviQueryParserException("Error parsing integer HTTP parameter '" + parameter + "' with value '" + value + "' for query '" + query.name() + "' : " + ex.getMessage());
            }
        }
        return null;
    }

    @Nullable
    private static IcCubePrintState parsePrintStateParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) {
        return httpParams.getPrintState();
    }

    private static GviPrintParams parsePrintParameters(IcCubeGviServerRequestParams httpParams, GviConstants.Action query) throws GviQueryParserException {
        String prefix = "pp_";
        String appUrl = null;
        String appLocalUrl = null;
        String appCustomizationUrl = null;
        String reportPath = null;
        String patches = null;
        Integer timeout = null;
        Integer debugWaitingTime = null;
        Double scale = null;
        String pageSizeUnits = null;
        Double pageWidth = null;
        Double pageHeight = null;
        Double marginTop = null;
        Double marginRight = null;
        Double marginLeft = null;
        Double marginBottom = null;
        String fileName = null;
        LinkedHashMap<String, String> reportingOptions = new LinkedHashMap<String, String>();
        for (String name : httpParams.getParamNames()) {
            if (!name.startsWith("pp_")) continue;
            String actualName = name.substring("pp_".length());
            String value = httpParams.getParamValue(name);
            if ("appUrl".equals(actualName)) {
                appUrl = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("appLocalUrl".equals(actualName)) {
                appLocalUrl = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("appCustomizationUrl".equals(actualName)) {
                appCustomizationUrl = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("reportPath".equals(actualName)) {
                reportPath = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("patches".equals(actualName)) {
                patches = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("timeout".equals(actualName) || "timeoutS".equals(actualName)) {
                timeout = GviQueryParser.parsePrintParameterInteger(query, actualName, value);
                continue;
            }
            if ("debugWaitingTime".equals(actualName) || "debugWaitingTimeS".equals(actualName)) {
                debugWaitingTime = GviQueryParser.parsePrintParameterInteger(query, actualName, value);
                continue;
            }
            if ("scale".equals(actualName)) {
                scale = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("pageSizeUnits".equals(actualName)) {
                pageSizeUnits = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            if ("pageWidth".equals(actualName)) {
                pageWidth = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("pageHeight".equals(actualName)) {
                pageHeight = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("marginTop".equals(actualName)) {
                marginTop = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("marginRight".equals(actualName)) {
                marginRight = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("marginLeft".equals(actualName)) {
                marginLeft = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("marginBottom".equals(actualName)) {
                marginBottom = GviQueryParser.parsePrintParameterDouble(query, actualName, value);
                continue;
            }
            if ("fileName".equals(actualName)) {
                fileName = GviQueryParser.parsePrintParameterString(query, actualName, value);
                continue;
            }
            reportingOptions.put(actualName, value);
        }
        GviQueryParser.assertPrintParameterNotNull(query, "appUrl", appUrl);
        GviQueryParser.assertPrintParameterNotNull(query, "appLocalUrl", appLocalUrl);
        GviQueryParser.assertPrintParameterNotNull(query, "appCustomizationUrl", appCustomizationUrl);
        GviQueryParser.assertPrintParameterNotNull(query, "reportPath", reportPath);
        GviQueryParser.assertPrintParameterNotNull(query, "timeout", timeout);
        GviQueryParser.assertPrintParameterNotNull(query, "scale", scale);
        GviQueryParser.assertPrintParameterNotNull(query, "pageSizeUnits", pageSizeUnits);
        GviQueryParser.assertPrintParameterNotNull(query, "pageWidth", pageWidth);
        GviQueryParser.assertPrintParameterNotNull(query, "pageHeight", pageHeight);
        marginTop = GviQueryParser.assertPrintParameterNotNullDouble(query, "marginTop", marginTop, 0.0);
        marginRight = GviQueryParser.assertPrintParameterNotNullDouble(query, "marginRight", marginRight, 0.0);
        marginLeft = GviQueryParser.assertPrintParameterNotNullDouble(query, "marginLeft", marginLeft, 0.0);
        marginBottom = GviQueryParser.assertPrintParameterNotNullDouble(query, "marginBottom", marginBottom, 0.0);
        return new GviPrintParams(appUrl, appLocalUrl, appCustomizationUrl, reportPath, null, patches, timeout, debugWaitingTime, scale, pageSizeUnits, pageWidth, pageHeight, marginTop, marginRight, marginLeft, marginBottom, fileName, reportingOptions);
    }

    private static void assertPrintParameterNotNull(GviConstants.Action query, String name, @Nullable Object value) throws GviQueryParserException {
        if (value == null) {
            throw new GviQueryParserException("missing HTTP parameter '" + name + "' for query '" + query.name() + "'");
        }
    }

    private static double assertPrintParameterNotNullDouble(GviConstants.Action query, String name, @Nullable Double value, double defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static GviQuery parsePrintReportBatchEx(IcCubeGviServerRequestParams httpParams, @Nullable CdVersion clientVersion) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        GviPrintParams printParams = GviQueryParser.parsePrintParameters(httpParams, GviConstants.Action.printReportBatchEx);
        IcCubePrintState reportState = GviQueryParser.parsePrintStateParam(httpParams, GviConstants.Action.printReportBatchEx, GviConstants.Param.reportState);
        return new GviPrintReportBatchExQuery(uuid, printParams, reportState);
    }

    static GviQuery parseCreateGizmoFolder(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.path);
        String name = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.name);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviCreateGizmoFolderQuery(uuid, type, path, name);
    }

    static GviQuery parseMoveGizmoFolder(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.moveGizmoFolder, GviConstants.Param.path);
        String nameTo = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.moveGizmoFolder, GviConstants.Param.nameTo);
        String pathTO = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.moveGizmoFolder, GviConstants.Param.pathTo);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviMoveGizmoFolderQuery(uuid, type, path, nameTo, pathTO);
    }

    static GviQuery parseDeleteGizmoFolder(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.deleteGizmoFolder, GviConstants.Param.path);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviDeleteGizmoFolderQuery(uuid, type, path);
    }

    static GviQuery parseListGizmoNames(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.listGizmoNames, GviConstants.Param.path);
        boolean withImage = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.listGizmoNames, GviConstants.Param.withImage, false);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviListGizmoNamesQuery(uuid, type, path, withImage);
    }

    static GviQuery parseSearchGizmoNames(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.searchGizmoNames, GviConstants.Param.path);
        String pattern = GviQueryParser.parseParam(httpParams, GviConstants.Action.searchGizmoNames, GviConstants.Param.pattern);
        boolean folderOnly = GviQueryParser.parseBooleanParam(httpParams, GviConstants.Action.searchGizmoNames, GviConstants.Param.folderOnly);
        boolean withImage = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.searchGizmoNames, GviConstants.Param.withImage, false);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.createGizmoFolder, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviSearchGizmoNamesQuery(uuid, type, path, pattern, folderOnly, withImage);
    }

    static GviQuery parseDeleteGizmo(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.deleteGizmo, GviConstants.Param.path);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.deleteGizmo, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviDeleteGizmoQuery(uuid, type, path);
    }

    static GviQuery parseGetGizmo(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.getGizmo, GviConstants.Param.path);
        String modeS = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.getGizmo, GviConstants.Param.mode);
        OlapDocsGizmoEntityMode mode = modeS != null ? OlapDocsGizmoEntityMode.valueOf(modeS) : null;
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.getGizmo, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        boolean withAuthSchema = GviQueryParser.parseOptionalBooleanParamEx(httpParams, GviConstants.Action.getGizmo, GviConstants.Param.withAuthSchema, false);
        return new GviGetGizmoQuery(uuid, mode, type, path, withAuthSchema);
    }

    static GviQuery parseSaveGizmo(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.path);
        String content = GviQueryParser.parseParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.content);
        boolean overwrite = GviQueryParser.parseBooleanParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.overwrite);
        String name = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.name);
        String modeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.mode);
        if ("saveAs".equals(modeS) || "rename".equals(modeS)) {
            if (name == null) {
                throw new GviQueryParserException("missing name parameter");
            }
        } else if (!"save".equals(modeS)) {
            throw new GviQueryParserException("mode parameter: invalid value [" + modeS + "] expected:save|saveAs|rename");
        }
        OlapDocsGizmoSaveMode mode = OlapDocsGizmoSaveMode.valueOf(modeS);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviSaveGizmoQuery(uuid, type, path, content, overwrite, name, mode);
    }

    static GviQuery parseMoveGizmo(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        boolean overwrite = GviQueryParser.parseBooleanParam(httpParams, GviConstants.Action.moveGizmo, GviConstants.Param.overwrite);
        String path = GviQueryParser.parseParam(httpParams, GviConstants.Action.moveGizmo, GviConstants.Param.path);
        String nameTo = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.moveGizmo, GviConstants.Param.nameTo);
        String pathTO = GviQueryParser.parseOptionalParam(httpParams, GviConstants.Action.moveGizmo, GviConstants.Param.pathTo);
        String typeS = GviQueryParser.parseParam(httpParams, GviConstants.Action.saveGizmo, GviConstants.Param.type);
        OlapDocsGizmoEntityType type = "REPORT".equals(typeS) ? OlapDocsGizmoEntityType.DASHBOARD : OlapDocsGizmoEntityType.valueOf(typeS);
        return new GviMoveGizmoQuery(uuid, type, overwrite, path, nameTo, pathTO);
    }

    static GviQuery parseFetchReportPatches(IcCubeGviServerRequestParams httpParams) {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        return new GviFetchReportPatchesQuery(uuid);
    }

    static GviQuery parseFetchReportState(IcCubeGviServerRequestParams httpParams) {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        return new GviFetchReportStateQuery(uuid);
    }

    static GviSchemaDataUpdateReportQuery parseSchemaDataUpdate(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String uuid = GviQueryParser.parseRequestUuid(httpParams);
        boolean longPolling = GviQueryParser.parseBooleanParam(httpParams, GviConstants.Action.schemaDataUpdate, GviConstants.Param.longPolling);
        String schemaDataUpdateJSON = GviQueryParser.parseParam(httpParams, GviConstants.Action.schemaDataUpdate, GviConstants.Param.schemaDataUpdate);
        HashedMap schemaDataUpdate = new HashedMap();
        Gson gson = new Gson();
        Map entries = (Map)gson.fromJson(schemaDataUpdateJSON, Map.class);
        if (entries != null) {
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                String schema = (String)value.get("schema");
                Number timestamp = (Number)value.get("timestamp");
                schemaDataUpdate.put(schema, new GviSchemaDataUpdateReportQuery.SchemaDataUpdate(schema, timestamp.longValue(), -1L));
            }
        }
        return new GviSchemaDataUpdateReportQuery(uuid, longPolling, (Map<String, GviSchemaDataUpdateReportQuery.SchemaDataUpdate>)schemaDataUpdate);
    }

    private static GviConstants.Action parseAction(IcCubeGviServerRequestParams httpParams) throws GviQueryParserException {
        String actionName = GviQueryParser.getHttpParam(httpParams, GviConstants.Param.action);
        if (actionName == null) {
            if (GviQueryParser.getHttpParam(httpParams, GviConstants.Param.mdx) != null) {
                return GviConstants.Action.executeMdx;
            }
            throw new GviQueryParserException("missing query type (i.e., 'action' HTTP params)");
        }
        try {
            return GviConstants.Action.valueOf((String)actionName);
        }
        catch (IllegalArgumentException ex) {
            throw new GviQueryParserException("unknown query type '" + actionName + "' (i.e., 'action' HTTP params)");
        }
    }

    public static String getHttpParam(IcCubeGviServerRequestParams httpParams, GviConstants.Param param) {
        return httpParams.getParamValue(param.name());
    }

    private static String parseRequestUuid(IcCubeGviServerRequestParams httpParams) {
        String uuid = GviQueryParser.getHttpParam(httpParams, GviConstants.Param.uuid);
        if (uuid == null) {
            return UUID.randomUUID().toString();
        }
        return uuid;
    }

    private static String parseParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            throw new GviQueryParserException("missing HTTP parameter '" + String.valueOf(param) + "' for query '" + query.name() + "'");
        }
        return value;
    }

    private static boolean parseBooleanParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.parseParam(httpParams, query, param);
        return Boolean.valueOf(value);
    }

    @Nullable
    private static String[] parseOptionalParamArr(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        Map json = (Map)new Gson().fromJson("{arr:" + value + "}", Map.class);
        Object arr = json.get("arr");
        if (arr instanceof List) {
            List arrL = (List)arr;
            String[] values = new String[arrL.size()];
            for (int ii = 0; ii < values.length; ++ii) {
                String elementS;
                Object element = arrL.get(ii);
                if (!(element instanceof String)) {
                    throw new GviQueryParserException("parameter '" + String.valueOf(param) + "' : not an array of a strings");
                }
                values[ii] = elementS = (String)element;
            }
            if (values.length == 0) {
                return null;
            }
            return values;
        }
        throw new GviQueryParserException("parameter '" + String.valueOf(param) + "' : not an array");
    }

    @Nullable
    private static CdVersion parseOptionalVersionParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        CdVersion version = CdVersion.create((String)value);
        return version;
    }

    @Nullable
    private static String parseOptionalParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return value;
    }

    private static String parseOptionalParamEx(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param, String defaultValue) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private static boolean parseOptionalBooleanParamEx(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param, boolean defaultValue) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static Long parseOptionalLongParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return GviQueryParser.parseLong(query, param, value);
    }

    private static long parseLongParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.parseParam(httpParams, query, param);
        return GviQueryParser.parseLong(query, param, value);
    }

    private static Integer parseOptionalIntegerParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.getHttpParam(httpParams, param);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return GviQueryParser.parseInteger(query, param, value);
    }

    private static int parseIntegerParam(IcCubeGviServerRequestParams httpParams, GviConstants.Action query, GviConstants.Param param) throws GviQueryParserException {
        String value = GviQueryParser.parseParam(httpParams, query, param);
        return GviQueryParser.parseInteger(query, param, value);
    }

    private static Long parseLong(GviConstants.Action query, GviConstants.Param param, String value) throws GviQueryParserException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new GviQueryParserException("Error parsing long HTTP parameter '" + String.valueOf(param) + "' with value '" + value + "' for query '" + query.name() + "' : " + ex.getMessage());
        }
    }

    private static Integer parseInteger(GviConstants.Action query, GviConstants.Param param, String value) throws GviQueryParserException {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new GviQueryParserException("Error parsing integer HTTP parameter '" + String.valueOf(param) + "' with value '" + value + "' for query '" + query.name() + "' : " + ex.getMessage());
        }
    }
}

