/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.executesql;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.reportquery.OlapReportQueryContext;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.common.errors.GviException;
import crazydev.iccube.server.gvi.tidy.serialize.GviTidySerializerUtils;
import crazydev.iccube.tidytable.sql.SqlTidyTable;
import crazydev.iccube.tidytable.sql.SqlTidyTableHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class GviExecuteSqlQuery
extends GviSchemaOlapEngineQuery {
    private final String jdbcDataSourceName;
    private final String sql;
    @Nullable
    private final Integer tidyMaxRowCount;

    public GviExecuteSqlQuery(String uuid, String schema, String jdbcDataSourceName, String sql, @Nullable Integer tidyMaxRowCount) {
        super(uuid, schema);
        this.jdbcDataSourceName = jdbcDataSourceName;
        this.sql = sql;
        this.tidyMaxRowCount = tidyMaxRowCount != null ? (tidyMaxRowCount == -1 ? null : tidyMaxRowCount) : null;
    }

    @Override
    public GviQueryKind getKind() {
        return GviQueryKind.SQL;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Execute SQL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws OlapMissingSchemaException, GviException {
        SqlTidyTable tidyTable;
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        engineRequestContext.onDetailAdded("JDBC Data Source", this.jdbcDataSourceName);
        engineRequestContext.onSqlDetailAdded("SQL", this.getSchema(), this.jdbcDataSourceName, this.sql);
        OlapSchema schema = this.getExistingLoadedSchema(engineRequestContext, IcCubeSchemaAccessLockMode.READ);
        IOlapSchemasPermission schemasPermissions = engineRequestContext.getSchemasPermissions();
        IOlapSchemaPermission permissions = schemasPermissions.getSchemaPermissions(engineRequestContext, schema, true);
        OlapBuilderBaseDataSource ds = schema.getReportingDataSource(permissions, this.jdbcDataSourceName);
        if (!(ds instanceof OlapBuilderJdbcDataSource)) {
            return GviExecuteSqlQuery.asError(new GviError(GviErrorCode.DATA_SOURCE_NOT_FOUND, new Serializable[]{this.jdbcDataSourceName}));
        }
        if (CdStringUtils.isNullOrBlank((String)this.sql)) {
            tidyTable = SqlTidyTable.create();
        } else {
            OlapBuilderJdbcDataSource jdbcDataSource = (OlapBuilderJdbcDataSource)ds;
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
            try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
                IOlapBuilderDataTableDef table = jdbcDataSource.createTableForExecuteSql(engineRequestContext, connectionPool, errorManager, this.sql);
                tidyTable = this.executeSqlQuery(engineRequestContext, connectionPool, schema, table);
            }
        }
        try {
            return GviTidySerializerUtils.asSqlResponse(engineRequestContext, this, tidyTable);
        }
        catch (IOException ex) {
            OlapLoggers.REQUEST.error((Object)("SQL " + engineRequestContext.getRequestId().getId() + " could not serialize the response"), (Throwable)ex);
            return GviExecuteSqlQuery.asError(new GviError(GviErrorCode.RESPONSE_SERIALIZATION_ERROR, new Serializable[]{ex.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlTidyTable executeSqlQuery(OlapEngineRequestContext requestContext, OlapBuilderConnectionPool connectionPool, OlapSchema schema, IOlapBuilderDataTableDef table) {
        OlapReportQueryContext context = new OlapReportQueryContext(requestContext, null, schema.getSchemaDefinition());
        boolean forTableBrowsing = true;
        try {
            SqlTidyTable tidyTable;
            OlapThreadPoolExecutorTaskSchedulingPolicy policy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
            requestContext.setupBuilderLoadExecutors(true);
            SqlTidyTableHelper tidyTableBuilder = new SqlTidyTableHelper(table, this.tidyMaxRowCount);
            OlapBuilderTableProcessingHelper.processTables((OlapBuilderContext)context, (OlapBuilderConnectionPool)connectionPool, (OlapThreadPoolExecutorTaskSchedulingPolicy)policy, Collections.singletonList(table));
            SqlTidyTable sqlTidyTable = tidyTable = tidyTableBuilder.toTidyTable();
            return sqlTidyTable;
        }
        finally {
            requestContext.releaseBuilderLoadExecutors(true);
        }
    }
}

