/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.executemdx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.result.tidy.OlapResSerializableTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.tidytable.drillthrough.MdxDrillthroughTidyTableColumn;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GviScriptInfos
extends OlapResSerializableTidyTable {
    private static final List<String> identifiers = List.of("$ic3.error$", "$ic3.type$", "$ic3.details$");
    private final List<OlapResStatementDataSet> results;

    public GviScriptInfos(List<OlapResStatementDataSet> results) {
        this.results = results;
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context) throws IOException {
        return OlapSerializedTidyResourceFactory.create((OlapSerializedTidyResourceFactory.Prefix)OlapSerializedTidyResourceFactory.Prefix.mdx, (OlapEngineRequestContext)context, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            this.serializeTable(w, gson, context, true, 10000, false, null);
            w.close();
        });
    }

    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int tidyMaxRowCount, boolean tidyMaxRowCountReached, @Nullable OlapResultStoreInformation info) throws IOException {
        int rowCount = this.results.size();
        w.beginObject();
        this.serialize(w, "classID", TidyTableClassID.MDX_DRILLTHROUGH_TABLE.name());
        this.serialize(w, "rowCount", rowCount);
        this.serialize(w, "tidyMaxRowCount", tidyMaxRowCount);
        this.serialize(w, "tidyMaxRowCountReached", tidyMaxRowCountReached);
        this.serializeQuery(w, context);
        if (rowCount > 0) {
            this.serializeColumns(w, g, context, json);
        }
        w.endObject();
    }

    protected void serializeQuery(JsonWriter w, OlapEngineRequestContext context) throws IOException {
        w.name("query");
        w.beginObject();
        w.endObject();
    }

    private void serializeColumns(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        w.name("columns");
        w.beginArray();
        for (int cc = 0; cc < identifiers.size(); ++cc) {
            this.serializeColumn(w, g, context, json, cc);
        }
        w.endArray();
    }

    private void serializeColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int cc) throws IOException {
        OlapBabylonService babylonService = context.getBabylonService();
        MdxDrillthroughTidyTableColumn column = new MdxDrillthroughTidyTableColumn(identifiers.get(cc));
        for (OlapResStatementDataSet res : this.results) {
            OlapResScriptInfo info = res.asScriptResultInfo((CdBabylonService)babylonService);
            switch (cc) {
                case 0: {
                    boolean error = res.isError();
                    column.addScalarEntity((OlapScalarEntity)OlapBooleanEntity.value((boolean)error));
                    break;
                }
                case 1: {
                    String type = info.getType();
                    column.addScalarEntity((OlapScalarEntity)new OlapStringEntity(type));
                    break;
                }
                case 2: {
                    String details = info.getDetails();
                    column.addScalarEntity((OlapScalarEntity)new OlapStringEntity(details));
                }
            }
        }
        column.inferType();
        column.compact();
        column.freeze();
        if (json) {
            column.setNaN();
        }
        String cellsJ = g.toJson((Object)column);
        w.jsonValue(cellsJ);
    }
}

