/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.executemdx;

import com.google.gson.Gson;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfo;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfoGvi;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class GviResultStoreReferenceKey
extends OlapResultStoreReferenceKey {
    private static long SHALLOW_SIZE_OF = -1L;
    private final String mdx;
    @Nullable
    private final String[] initialSelection;
    @Nullable
    private final Integer cellCountMax;
    @Nullable
    private final Integer tidyMaxRowCount;
    @Nullable
    private final Integer timeoutS;

    public GviResultStoreReferenceKey(String mdx, @Nullable String[] initialSelection, @Nullable Integer cellCountMax, @Nullable Integer tidyMaxRowCount, @Nullable Integer timeoutS) {
        this.mdx = mdx;
        this.initialSelection = initialSelection;
        this.cellCountMax = cellCountMax;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.timeoutS = timeoutS;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)((Object)this)));
        return size += CdRamUsageEstimator.sizeOf((String)this.mdx);
    }

    public String getMdx() {
        return this.mdx;
    }

    public int getMdxSize() {
        return this.mdx.length();
    }

    public OlapMdxResultCacheInfo asMdxResultCacheInfo(OlapResultCacheKey cache) {
        String initialSelection = this.initialSelection != null ? new Gson().toJson((Object)this.initialSelection) : null;
        String cellCountMax = this.cellCountMax != null ? String.valueOf(this.cellCountMax) : null;
        String tidyMaxRowCount = this.tidyMaxRowCount != null ? String.valueOf(this.tidyMaxRowCount) : null;
        String timeoutS = this.timeoutS != null ? String.valueOf(this.timeoutS) : null;
        return new OlapMdxResultCacheInfoGvi(cache, this.mdx, initialSelection, cellCountMax, tidyMaxRowCount, timeoutS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GviResultStoreReferenceKey that = (GviResultStoreReferenceKey)((Object)o);
        return Objects.equals(this.mdx, that.mdx) && Arrays.equals(this.initialSelection, that.initialSelection) && Objects.equals(this.cellCountMax, that.cellCountMax) && Objects.equals(this.tidyMaxRowCount, that.tidyMaxRowCount) && Objects.equals(this.timeoutS, that.timeoutS);
    }

    public int hashCode() {
        int result = Objects.hash(this.mdx, this.cellCountMax, this.tidyMaxRowCount, this.timeoutS);
        result = 31 * result + Arrays.hashCode(this.initialSelection);
        return result;
    }
}

