/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.executemdx;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxStatementCompilationInfo;
import crazydev.iccube.olap.entity.result.OlapResErrorMdxStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptErrorDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptRegularDataSet;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviJsonFileResponse;
import crazydev.iccube.server.gvi.request.common.GviMdxErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.GviResponseInfo;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.common.errors.GviException;
import crazydev.iccube.server.gvi.request.common.errors.GviSchemaNotFoundException;
import crazydev.iccube.server.gvi.request.executemdx.GviResultStoreReferenceKey;
import crazydev.iccube.server.gvi.request.executemdx.GviScriptInfos;
import crazydev.iccube.server.gvi.request.executemdx.GviTidyResultStoreReferenceKey;
import crazydev.iccube.server.gvi.tidy.serialize.GviTidySerializerUtils;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxMdxRange;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GviExecuteMdxQuery
extends GviSchemaOlapEngineQuery {
    private final boolean script;
    @Nullable
    private final String debug;
    private final String mdx;
    @Nullable
    private final Integer cellCountMax;
    @Nullable
    private final Integer tidyMaxRowCount;
    @Nullable
    private final Integer timeoutS;
    @Nullable
    private final String[] initialSelection;
    private final GviResponseInfo info;

    public GviExecuteMdxQuery(String uuid, String schema, boolean script, @Nullable String debug, String mdx, @Nullable String[] initialSelection, @Nullable String initialSelectionV, @Nullable Integer cellCountMax, @Nullable Integer tidyMaxRowCount, @Nullable Integer timeoutS) {
        super(uuid, schema);
        this.script = script;
        this.debug = debug;
        this.mdx = initialSelectionV == null ? mdx : mdx + "\n//initialSelection=" + initialSelectionV;
        this.initialSelection = initialSelection;
        this.cellCountMax = cellCountMax;
        this.tidyMaxRowCount = tidyMaxRowCount != null ? (tidyMaxRowCount == -1 ? null : tidyMaxRowCount) : null;
        this.timeoutS = timeoutS;
        this.info = new GviResponseInfo();
    }

    @Override
    public boolean isForMdxConsole() {
        return true;
    }

    public boolean isForScript() {
        return this.script;
    }

    public boolean isForDebug() {
        return this.debug != null;
    }

    @Override
    public GviQueryKind getKind() {
        return GviQueryKind.MDX;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Execute MDX";
    }

    public String getMdx() {
        return this.mdx;
    }

    @Nullable
    public String[] getInitialSelection() {
        return this.initialSelection;
    }

    @Override
    public String getMdxForCancelReport() {
        return this.mdx;
    }

    @Nullable
    public Integer getTidyMaxRowCount() {
        return this.tidyMaxRowCount;
    }

    @Override
    @Nullable
    public Integer getCellCountMax() {
        return this.cellCountMax;
    }

    @Override
    @Nullable
    public Integer getTimeoutS() {
        return this.timeoutS;
    }

    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws GviException {
        GviResponse response = this.doExecuteEx(queryContext);
        if (!this.info.isEmpty()) {
            response.attachInfo(this.info);
        }
        return response;
    }

    private GviResponse doExecuteEx(GviQueryContext queryContext) throws GviException {
        OlapEngineRequestContext olapEngineRequestContext = queryContext.getOlapEngineRequestContext();
        if (this.isForDebug() && olapEngineRequestContext.isSessionLess()) {
            return this.asErrorTable(olapEngineRequestContext, CdError.create((CdErrorCode)OlapErrorCode.MDX_DEBUG_SESSION_MISMATCH, (Serializable[])new Serializable[0]));
        }
        olapEngineRequestContext.onMdxDetailAdded("MDX", this.getSchema(), this.mdx);
        ICompilationInfo ci = queryContext.getMdxCompilationInfo();
        if (ci instanceof OlapEngineMdxStatementCompilationInfo) {
            OlapEngineMdxStatementCompilationInfo compilationInfo = (OlapEngineMdxStatementCompilationInfo)ci;
            return this.doExecuteForMdxStatement(queryContext, compilationInfo);
        }
        if (ci instanceof OlapEngineMdxScriptCompilationInfo) {
            OlapStatementInstr statement;
            List statements;
            OlapEngineMdxScriptCompilationInfo compilationInfo = (OlapEngineMdxScriptCompilationInfo)ci;
            OlapResScriptDataSet result = compilationInfo.getResult();
            OlapScriptInstr instr = compilationInfo.getScriptInstr();
            if (result == null && instr != null && (statements = instr.getStatements()).size() == 1 && ((statement = (OlapStatementInstr)statements.getFirst()) instanceof OlapTopLevelSelectInstr || statement instanceof OlapDrillthroughInstr)) {
                return this.doExecuteForMdxStatement(queryContext, compilationInfo.toStatementCompilationInfo());
            }
            if (this.isForDebug()) {
                return this.asErrorTable(olapEngineRequestContext, CdError.create((CdErrorCode)OlapErrorCode.DEBUGGER_SCRIPT_ERROR, (Serializable[])new Serializable[0]));
            }
            return this.doExecuteForScriptStatement(queryContext, compilationInfo);
        }
        OlapLoggers.MDX_EVALUATION.error((Object)("internal error : unexpected compilation info : " + (ci != null ? ci.getClass().getName() : "null")));
        throw new RuntimeException("internal error : unexpected compilation info");
    }

    protected GviResponse doExecuteForMdxStatement(GviQueryContext queryContext, OlapEngineMdxStatementCompilationInfo compilationInfo) throws GviException {
        OlapEngineRequestContext olapEngineRequestContext = queryContext.getOlapEngineRequestContext();
        OlapEngineMdxHelper mdxHelper = compilationInfo.getHelper();
        OlapResStatementDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            return this.asGviResponse(queryContext, mdxHelper.getInstrExecListener(), null, olapEngineRequestContext, compilationResult);
        }
        OlapResultCacheInfo resultCacheInfo = new OlapResultCacheInfo();
        GviResponse cachedResponse = this.doExecuteFromCache((OlapResultCacheInfo<GviResultStoreReferenceKey>)resultCacheInfo, compilationInfo.getStatementInstr(), queryContext);
        if (cachedResponse != null) {
            this.info.setProperty(GviResponseInfo.KEYS.executedFromCache, true);
            return cachedResponse;
        }
        OlapSchema schema = resultCacheInfo.getSchema();
        if (schema == null) {
            throw new RuntimeException("internal error : missing schema");
        }
        String reportPath = this.extractReportPathForAudit(queryContext);
        String cachedMdxHash = resultCacheInfo.getMdxHash();
        long startMS = System.currentTimeMillis();
        OlapResStatementDataSet result = mdxHelper.executeMdxStatement(compilationInfo, cachedMdxHash, schema, reportPath);
        this.info.setProperty(GviResponseInfo.KEYS.executedMS, CdTimeUtils.formatMillisA((long)(System.currentTimeMillis() - startMS)));
        return this.asGviResponse(queryContext, mdxHelper.getInstrExecListener(), (OlapResultCacheInfo<GviResultStoreReferenceKey>)resultCacheInfo, olapEngineRequestContext, result);
    }

    @Nullable
    private String extractReportPathForAudit(GviQueryContext queryContext) {
        if (!queryContext.isMdxAuditActive()) {
            return null;
        }
        try {
            String path;
            String reportUUID = this.getReportUUID();
            if (CdStringUtils.isNotNullAndNotBlank((String)reportUUID)) {
                IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
                OlapDocsRepository repository = this.getDocsRepository(queryContext);
                path = repository.asPathFromReportRootData(repositoryContext, reportUUID);
            } else {
                path = this.getAuditReportPath();
            }
            return path;
        }
        catch (OlapDocsErrorException | RuntimeException ex) {
            String reportUUID = this.getReportUUID();
            String auditPath = this.getAuditReportPath();
            Object path = CdStringUtils.isNotNullAndNotBlank((String)reportUUID) ? " [" + reportUUID + "]" : (CdStringUtils.isNotNullAndNotBlank((String)auditPath) ? " [" + auditPath + "]" : "");
            OlapLoggers.REQUEST.warn((Object)("could not retrieve the report path for audit purpose" + (String)path), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private GviResponse doExecuteFromCache(OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo, @Nullable OlapStatementInstr statementInstr, GviQueryContext queryContext) throws GviException {
        String prefix;
        OlapResultStoreDeSerializer cachedResult_;
        OlapEngineRequestContext olapEngineRequestContext = queryContext.getOlapEngineRequestContext();
        if (statementInstr == null) {
            throw new RuntimeException("internal error: missing MDX evaluation instruction");
        }
        IcCubeSchemaAccessLockMode schemaAccessLockMode = statementInstr.getSchemaAccessLockMode();
        OlapSchema schema = this.getExistingLoadedSchema(olapEngineRequestContext, schemaAccessLockMode);
        resultCacheInfo.setSchema(schema);
        if (!statementInstr.isResultCacheEnabled()) {
            return null;
        }
        OlapResultCache resultCache = olapEngineRequestContext.getOrCreateResultCache(IOlapProtocol.GVI, schema);
        if (resultCache == null) {
            return null;
        }
        resultCacheInfo.setResultCache(resultCache);
        GviTidyResultStoreReferenceKey resultKey = new GviTidyResultStoreReferenceKey(this.mdx, this.initialSelection, this.cellCountMax, this.tidyMaxRowCount, this.timeoutS);
        resultCacheInfo.setResultKey((OlapResultStoreReferenceKey)resultKey);
        String reportPath = this.extractReportPathForAudit(queryContext);
        OlapResultStoreDeSerializer olapResultStoreDeSerializer = cachedResult_ = !this.isForDebug() ? resultCache.getResult(olapEngineRequestContext, (OlapResultStoreReferenceKey)resultKey, reportPath) : null;
        if (cachedResult_ == null) {
            return null;
        }
        OlapResultStoreInformation currentResultInfo = this.createResultStoreInformation(olapEngineRequestContext, resultCacheInfo);
        OlapResultStoreInformation cachedResultInfo = cachedResult_.getInfo();
        String cachedRequestId = cachedResultInfo != null ? String.valueOf(cachedResultInfo.requestId) : "n/a";
        olapEngineRequestContext.onDetailAdded("MDX (cache)", "Got result from cache [cached-request-id:" + cachedRequestId + "]");
        if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isInfoEnabled()) {
            OlapLoggers.MDX_EVALUATION_RESULT_CACHE.info((Object)("[result-cache] MDX " + olapEngineRequestContext.getRequestId().getId() + " result from cache [cached-request-id:" + cachedRequestId + "]"));
        }
        if (cachedResultInfo != null && OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
            prefix = "[result-cache] MDX " + olapEngineRequestContext.getRequestId().getId() + " ";
            cachedResultInfo.log(OlapLoggers.MDX_EVALUATION_RESULT_CACHE, prefix, currentResultInfo);
        }
        if (cachedResultInfo != null) {
            prefix = "[result-cache] MDX " + olapEngineRequestContext.getRequestId().getId() + " ";
            cachedResultInfo.assertConsistency(OlapLoggers.MDX_EVALUATION_RESULT_CACHE, prefix, currentResultInfo);
        }
        try {
            return GviTidySerializerUtils.asMdxResponseFromCache(olapEngineRequestContext, this, currentResultInfo, cachedResult_);
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION_RESULT_CACHE.error((Object)("[result-cache] MDX " + olapEngineRequestContext.getRequestId().getId() + " could not retrieve the result from cache"), (Throwable)ex);
            return null;
        }
    }

    private GviResponse asGviResponse(GviQueryContext queryContext, @Nullable OlapInstrExecListener listener, @Nullable OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo, OlapEngineRequestContext olapEngineRequestContext, OlapResStatementDataSet result) {
        OlapResultStoreInformation resultInfo;
        if (result.isError()) {
            OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluated on error : %s \n%s".formatted(result.getErrorMessage(), result.getMdx()));
            return this.asErrorTable(olapEngineRequestContext, result);
        }
        if (result.isBlank()) {
            return new GviDataTableResponse((IOlapCancellingContext)olapEngineRequestContext, null);
        }
        if (result.isCommand()) {
            return new GviDataTableResponse((IOlapCancellingContext)olapEngineRequestContext, null);
        }
        boolean hasCellOnError = result.hasCellsOnError();
        if (hasCellOnError) {
            OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluated w/ cell(s) on error\n%s".formatted(result.getMdx()));
            resultCacheInfo = null;
        }
        if ((resultInfo = this.createResultStoreInformation(olapEngineRequestContext, resultCacheInfo)) != null) {
            String prefix = "MDX " + olapEngineRequestContext.getRequestId().getId() + " ";
            resultInfo.log(OlapLoggers.MDX_EVALUATION, prefix, (Object)result);
        }
        return this.asGviTidyResponse(queryContext, listener, olapEngineRequestContext, resultCacheInfo, resultInfo, result);
    }

    private GviResponse asErrorTable(OlapEngineRequestContext olapEngineRequestContext, OlapResStatementDataSet result) {
        OlapResErrorMdxStatementDataSet errorResult = (OlapResErrorMdxStatementDataSet)result;
        CdError error = errorResult.getException().getError();
        return this.asErrorTable(olapEngineRequestContext, error);
    }

    private GviMdxErrorResponse asErrorTable(OlapEngineRequestContext olapEngineRequestContext, CdError error) {
        UxMdxRange range = olapEngineRequestContext.isReportingMF() ? UxUtils.setupMdxRange(0, error.getLocation()) : null;
        return new GviMdxErrorResponse(error.getCode(), error.getParams(), this.mdx, range);
    }

    @Nullable
    private OlapResultStoreInformation createResultStoreInformation(OlapEngineRequestContext context, @Nullable OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo) {
        if (resultCacheInfo == null || resultCacheInfo.getResultCache() == null || resultCacheInfo.getResultKey() == null) {
            return null;
        }
        OlapResultCache cache = resultCacheInfo.getResultCache();
        OlapResultCacheKey cacheKey = cache.getCacheKey();
        String locale = cacheKey.getLocale().toString();
        String roleName = cacheKey.getRoleName();
        String schemaName = cacheKey.getSchemaName();
        String schemaId = cacheKey.getSchemaId();
        Date schemaRefreshTime = cacheKey.getSchemaRefreshTime();
        String schemaPermsId = cacheKey.getSchemaPermission().getUuid();
        GviResultStoreReferenceKey resultKey = (GviResultStoreReferenceKey)resultCacheInfo.getResultKey();
        String mdxHash = resultKey.getHash();
        long requestId = context.getRequestId().getId();
        return new OlapResultStoreInformation(locale, roleName, schemaName, schemaId, schemaRefreshTime, schemaPermsId, mdxHash, requestId);
    }

    private GviResponse asGviTidyResponse(GviQueryContext queryContext, @Nullable OlapInstrExecListener listener, OlapEngineRequestContext engineRequestContext, @Nullable OlapResultCacheInfo<GviResultStoreReferenceKey> resultCacheInfo, @Nullable OlapResultStoreInformation resultInfo, OlapResStatementDataSet result) {
        try {
            if (this.isForDebug() && listener instanceof OlapMdxDebugNodeCollector) {
                OlapMdxDebugNodeCollector debugger = (OlapMdxDebugNodeCollector)listener;
                String schemaName = result.getSchemaName();
                IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
                IcCubeServerSessionContext sessionContext = serverRequestContext.getSessionContext();
                String queryId = this.debug;
                boolean scriptOffset = false;
                sessionContext.setMdxDebuggerTree(schemaName, new DebugMdxQueryExecTree(queryId, 0, debugger.getRoot()));
                this.info.setProperty(GviResponseInfo.KEYS.debuggerTreeUID, queryId);
            }
            return GviTidySerializerUtils.asMdxResponseAndCache(engineRequestContext, this, !this.isForDebug() ? resultCacheInfo : null, resultInfo, result);
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("[response] MDX " + engineRequestContext.getRequestId().getId() + " could not serialize the response"), (Throwable)ex);
            return GviExecuteMdxQuery.asError(new GviError(GviErrorCode.RESPONSE_SERIALIZATION_ERROR, new Serializable[]{ex.getMessage()}));
        }
    }

    private GviResponse doExecuteForScriptStatement(GviQueryContext queryContext, OlapEngineMdxScriptCompilationInfo compilationInfo) throws GviSchemaNotFoundException {
        OlapResScriptRegularDataSet result;
        OlapEngineRequestContext context = queryContext.getOlapEngineRequestContext();
        OlapResScriptDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            if (compilationResult instanceof OlapResScriptErrorDataSet) {
                OlapResScriptErrorDataSet dataSetError = (OlapResScriptErrorDataSet)compilationResult;
                CdError error = dataSetError.getError().getError();
                return this.asErrorTable(context, error);
            }
            OlapLoggers.MDX_EVALUATION.error((Object)("internal error: unexpected MDX script compilation : " + compilationResult.getClass().getName()));
            throw new RuntimeException("internal error: unexpected MDX script compilation");
        }
        OlapScriptInstr scriptInstr = compilationInfo.getScriptInstr();
        if (scriptInstr == null) {
            throw new RuntimeException("internal error: missing MDX script evaluation instruction");
        }
        List statements = scriptInstr.getStatements();
        if (statements.isEmpty()) {
            result = new OlapResScriptRegularDataSet(compilationInfo.getName(), compilationInfo.getSchema());
        } else {
            for (OlapStatementInstr statement : statements) {
                if (!(statement instanceof OlapTopLevelSelectInstr) && !(statement instanceof OlapDrillthroughInstr)) continue;
                CdError error = CdError.create((CdErrorCode)OlapErrorCode.MDX_SCRIPT_WITH_SELECT, (Serializable[])new Serializable[0]);
                error.setLocation((CdErrorLocation)statement.getLocationRange());
                return this.asErrorTable(context, error);
            }
            IcCubeSchemaAccessLockMode schemaAccessLockMode = scriptInstr.getSchemaAccessLockMode();
            OlapSchema schema = this.getExistingLoadedSchema(context, schemaAccessLockMode);
            OlapEngineMdxScriptExecutionInfo executionInfo = compilationInfo.asExecutionInfo();
            OlapEngineMdxHelper mdxHelper = compilationInfo.getHelper();
            result = mdxHelper.executeMdxScriptUX(executionInfo, schema);
        }
        if (result instanceof OlapResScriptErrorDataSet) {
            OlapResScriptErrorDataSet resultE = (OlapResScriptErrorDataSet)result;
            CdError error = resultE.getError().getError();
            return this.asErrorTable(context, error);
        }
        if (result instanceof OlapResScriptRegularDataSet) {
            OlapResScriptRegularDataSet resultDS = result;
            try {
                List results = resultDS.getStatementResults();
                IOlapSerializedTidyResource jsonT = new GviScriptInfos(results).serializeAsJson(context);
                return new GviJsonFileResponse(jsonT);
            }
            catch (IOException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)("[response] MDX " + context.getRequestId().getId() + " could not serialize the response"), (Throwable)ex);
                return GviExecuteMdxQuery.asError(new GviError(GviErrorCode.RESPONSE_SERIALIZATION_ERROR, new Serializable[]{ex.getMessage()}));
            }
        }
        OlapLoggers.MDX_EVALUATION.error((Object)("internal error: unexpected MDX script evaluation : " + result.getClass().getName()));
        throw new RuntimeException("internal error: unexpected MDX script evaluation");
    }
}

