/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInfo;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.gvi.request.common.GviOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.errors.GviSchemaNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class GviSchemaOlapEngineQuery
extends GviOlapEngineQuery {
    private final String schema;

    protected GviSchemaOlapEngineQuery(String uuid, String schema) {
        super(uuid);
        this.schema = schema;
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    public List<OlapSchemaInfo> getAuthorizedSchemaInfos(OlapEngineRequestContext olapEngineRequestContext) {
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapRequestNamesContext nameContext = olapEngineRequestContext.getNameContext();
        Locale locale = olapEngineRequestContext.getLocale();
        OlapRoleApplicationPermissions applicationPermissions = olapEngineRequestContext.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = olapEngineRequestContext.getSchemasPermissions();
        return olapEngine.getAuthorizedSchemaInfos(locale, (OlapNameContext)nameContext, olapEngineRequestContext, applicationPermissions, schemasPermissions);
    }

    public OlapSchema getExistingLoadedSchema(OlapEngineRequestContext olapEngineRequestContext, IcCubeSchemaAccessLockMode mode) throws GviSchemaNotFoundException {
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapSchema loadedSchema = olapEngine.getAuthorizedSchema(olapEngineRequestContext, mode, this.schema);
        if (loadedSchema == null) {
            throw new GviSchemaNotFoundException(this.schema);
        }
        return loadedSchema;
    }

    @Nullable
    public OlapSchema getLoadedSchema(OlapEngineRequestContext olapEngineRequestContext, IcCubeSchemaAccessLockMode mode) {
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapSchema loadedSchema = olapEngine.getAuthorizedSchema(olapEngineRequestContext, mode, this.schema);
        return loadedSchema;
    }

    @Nullable
    protected OlapCube getLoadedCube(OlapEngineRequestContext olapEngineRequestContext, IcCubeSchemaAccessLockMode mode, @Nullable String cubeName) throws OlapMissingSchemaException {
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        return olapEngine.getAuthorizedCube(olapEngineRequestContext, mode, this.schema, cubeName);
    }

    @Nullable
    public List<OlapCube> getLoadedCubes(OlapEngineRequestContext olapEngineRequestContext, IcCubeSchemaAccessLockMode mode) throws OlapMissingSchemaException {
        return GviSchemaOlapEngineQuery.getLoadedCubes(olapEngineRequestContext, mode, this.schema);
    }

    @Nullable
    public static List<OlapCube> getLoadedCubes(OlapEngineRequestContext olapEngineRequestContext, IcCubeSchemaAccessLockMode mode, String schema) throws OlapMissingSchemaException {
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        List cubes = olapEngine.getAuthorizedCubes(olapEngineRequestContext, mode, schema);
        if (cubes == null || cubes.size() < 2) {
            return cubes;
        }
        OlapCube firstCube = null;
        for (OlapCube cube : cubes) {
            if (!cube.hasPerspective() || cube.getPerspective() != null) continue;
            firstCube = cube;
            break;
        }
        if (firstCube == null) {
            return cubes;
        }
        ArrayList<OlapCube> cubesFixed = new ArrayList<OlapCube>();
        cubesFixed.add(firstCube);
        for (OlapCube cube : cubes) {
            if (cube == firstCube) continue;
            cubesFixed.add(cube);
        }
        return cubesFixed;
    }
}

