/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import crazydev.common.version.CdVersion;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.request.request.IcCubeRequestType;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import org.jetbrains.annotations.Nullable;

public abstract class GviQuery {
    protected final String clientUUID;
    @Nullable
    protected CdVersion version;
    @Nullable
    protected String rootVersion;
    @Nullable
    private String locale;
    @Nullable
    private Long timestamp;
    @Nullable
    private String windowUid;
    @Nullable
    private String widgetUid;
    private boolean noAutoCancel;
    @Nullable
    private String reportUUID;
    @Nullable
    private String auditReportPath;

    protected GviQuery(String uuid) {
        this.clientUUID = uuid;
    }

    public static GviResponse asError(GviError error) {
        return new GviGenericErrorResponse(error, null);
    }

    public boolean isForMdxConsole() {
        return false;
    }

    public IcCubeRequestType getRequestType() {
        return IcCubeRequestType.OTHER;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public String getTrackingInfo() {
        String kind = this.getKind().name();
        String schema = this.getSchema();
        String type = this.getClass().getSimpleName();
        String uuid = this.getClientUUID();
        return kind + " (" + (String)(schema != null ? "schema:" + schema : "schema:none") + ") " + type + " " + uuid;
    }

    @Nullable
    public CdVersion getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable CdVersion version) {
        this.version = version;
    }

    @Nullable
    public String getRootVersion() {
        return this.rootVersion;
    }

    public void setRootVersion(@Nullable String rootVersion) {
        this.rootVersion = rootVersion;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable String locale) {
        this.locale = locale;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(@Nullable Long timestamp) {
        this.timestamp = timestamp;
    }

    @Nullable
    public String getWindowUid() {
        return this.windowUid;
    }

    public void setWindowUid(@Nullable String windowUid) {
        this.windowUid = windowUid;
    }

    @Nullable
    public String getWidgetUid() {
        return this.widgetUid;
    }

    public void setWidgetUid(@Nullable String widgetUid) {
        this.widgetUid = widgetUid;
    }

    @Nullable
    public String getReportUUID() {
        return this.reportUUID;
    }

    public void setReportUUID(@Nullable String reportUUID) {
        this.reportUUID = reportUUID;
    }

    @Nullable
    public String getAuditReportPath() {
        return this.auditReportPath;
    }

    public void setAuditReportPath(@Nullable String auditReportPath) {
        this.auditReportPath = auditReportPath;
    }

    public boolean isNoAutoCancel() {
        return this.noAutoCancel;
    }

    public void setNoAutoCancel(boolean noAutoCancel) {
        this.noAutoCancel = noAutoCancel;
    }

    @Nullable
    public String getMdxForCancelReport() {
        return null;
    }

    @Nullable
    public abstract String getSchema();

    public abstract boolean isSchemaWrite();

    public String getInternalTypeName() {
        return this.getClass().getSimpleName();
    }

    public GviQueryKind getKind() {
        return GviQueryKind.OTHER;
    }

    public abstract String getUserFriendlyTypeName();

    public boolean isMonitored() {
        return true;
    }

    public abstract GviResponse execute(GviQueryContext var1);

    protected IOlapDocsRequestContext createRepositoryContext(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return new OlapReportRepositoryRequestContext(serverRequestContext, this.version, null);
    }

    protected OlapDocsRepository getDocsRepository(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return serverRequestContext.getApplicationContext().getDocsRepository(queryContext.asRuntimeContext());
    }

    @Nullable
    public Integer getCellCountMax() {
        return null;
    }

    @Nullable
    public Integer getTimeoutS() {
        return null;
    }
}

