/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.server.gvi.request.common.GviRegularResponse;
import crazydev.iccube.server.gvi.request.common.GviResponseInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class GviJsonFileResponse
extends GviRegularResponse {
    private final IOlapSerializedTidyResource json;
    @Nullable
    private final OlapResultStoreInformation currentResultInfo;

    public GviJsonFileResponse(IOlapSerializedTidyResource json) {
        this(json, null);
    }

    public GviJsonFileResponse(IOlapSerializedTidyResource json, @Nullable OlapResultStoreInformation currentResultInfo) {
        this.json = json;
        this.currentResultInfo = currentResultInfo;
    }

    @Override
    public String getFriendlyType() {
        return "json";
    }

    @Override
    protected void doWriteResponseHeader(HttpServletResponse response) {
        super.doWriteResponseHeader(response);
        if (this.currentResultInfo != null) {
            this.currentResultInfo.setResponseHeaders(response);
        }
    }

    @Override
    protected void doWriteResponseBody(OutputStream out, OlapBabylonService babylon) throws IOException {
        out.write("{\"version\":1,\"status\":\"ok\"".getBytes(StandardCharsets.UTF_8));
        GviResponseInfo extraInfo = this.info;
        if (extraInfo != null && !extraInfo.isEmpty()) {
            out.write(",\"info\":".getBytes(StandardCharsets.UTF_8));
            this.info.serializeAsJson(out);
        }
        out.write(",\"table\":".getBytes(StandardCharsets.UTF_8));
        this.json.write(out);
        out.write("}".getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    @Override
    public void release() {
        try {
            this.json.release();
            super.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

