/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.chat;

import com.google.gson.Gson;
import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.gvi.request.chat.GviAIChatErrorChunk;
import crazydev.iccube.server.gvi.request.chat.GviAIChatMetaChunk;
import crazydev.iccube.server.gvi.request.chat.GviAIChatTokenChunk;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class GviAIChatStreamResponse {
    private final Generator generator;

    public GviAIChatStreamResponse(Generator generator) {
        this.generator = generator;
    }

    public void stream(GviQueryContext context, GviAIChatMetaChunk metaChunk) {
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response");
        GviError error = null;
        try {
            error = this.unsafeStream(context, metaChunk);
        }
        catch (IOException ex) {
            OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : IO error", (Throwable)ex);
            error = new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{ex.getMessage()});
        }
        if (error != null) {
            OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : error");
            this.safeSendError(context, error);
        }
        this.safeCloseStream(context);
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response completed");
    }

    @Nullable
    protected GviError unsafeStream(GviQueryContext context, GviAIChatMetaChunk metaChunk) throws IOException {
        HttpServletResponse servletResponse = context.getIcCubeServerRequestContext().getHttpResponse();
        ServletOutputStream out = servletResponse.getOutputStream();
        CountDownLatch streamSync = new CountDownLatch(1);
        final AtomicBoolean streamCancelled = new AtomicBoolean(false);
        AtomicReference streamError = new AtomicReference();
        String json = new Gson().toJson((Object)metaChunk) + "\n";
        out.write(json.getBytes(StandardCharsets.UTF_8));
        out.flush();
        this.generator.generate(new StreamingResponseHandler<AiMessage>(this, (OutputStream)out, streamSync, streamError){
            final /* synthetic */ OutputStream val$out;
            final /* synthetic */ CountDownLatch val$streamSync;
            final /* synthetic */ AtomicReference val$streamError;
            {
                this.val$out = outputStream;
                this.val$streamSync = countDownLatch;
                this.val$streamError = atomicReference;
                Objects.requireNonNull(this$0);
            }

            public void onNext(String token) {
                if (streamCancelled.get()) {
                    OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM onNext() received on request cancelled");
                    throw new RuntimeException("onNext() received on request cancelled");
                }
                try {
                    if (!token.isEmpty()) {
                        GviAIChatTokenChunk chunk = new GviAIChatTokenChunk(token, false);
                        String json = new Gson().toJson((Object)chunk) + "\n";
                        this.val$out.write(json.getBytes(StandardCharsets.UTF_8));
                        this.val$out.flush();
                    }
                }
                catch (IOException ex) {
                    OlapLoggers.AI_RESPONSE.error((Object)"[AI] onNext(token) error : throwing a tunneled exception", (Throwable)ex);
                    throw new TunneledException(new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{"token error : " + ex.getMessage()}));
                }
            }

            public void onComplete(Response<AiMessage> response) {
                if (streamCancelled.get()) {
                    OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM onComplete() received on request cancelled");
                    return;
                }
                OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM response complete");
                if (OlapLoggers.AI_RESPONSE.isDebugEnabled()) {
                    OlapLoggers.AI_RESPONSE.debug((Object)("[AI] LLM response complete content : " + String.valueOf(response.content())));
                }
                this.val$streamSync.countDown();
            }

            public void onError(Throwable error) {
                if (streamCancelled.get()) {
                    OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM onError() received on request cancelled", error);
                    return;
                }
                OlapLoggers.AI_RESPONSE.error((Object)"[AI] onError() error", error);
                this.val$streamError.compareAndSet(null, error instanceof TunneledException ? ((TunneledException)error).error : new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{"error : " + error.getMessage()}));
                this.val$streamSync.countDown();
            }
        });
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : waiting for completion");
        try {
            streamSync.await();
        }
        catch (InterruptedException ex) {
            OlapLoggers.AI_RESPONSE.info((Object)"[AI] LL generating response : waiting interrupted", (Throwable)ex);
            streamCancelled.set(true);
        }
        return (GviError)((Object)streamError.get());
    }

    private void safeSendError(GviQueryContext context, GviError error) {
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : send error");
        try {
            HttpServletResponse servletResponse = context.getIcCubeServerRequestContext().getHttpResponse();
            ServletOutputStream out = servletResponse.getOutputStream();
            String errorCode = error.getCode().getValue();
            String errorMessage = error.asMessage((CdBabylonService)context.getBabylonService());
            GviAIChatErrorChunk chunk = new GviAIChatErrorChunk(errorCode, errorMessage);
            String json = new Gson().toJson((Object)chunk) + "\n";
            out.write(json.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException ex) {
            OlapLoggers.AI_RESPONSE.error((Object)"[AI] LLM generating response : send error on error", (Throwable)ex);
        }
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : send error completed");
    }

    private void safeCloseStream(GviQueryContext context) {
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : closing stream");
        try {
            HttpServletResponse servletResponse = context.getIcCubeServerRequestContext().getHttpResponse();
            ServletOutputStream out = servletResponse.getOutputStream();
            GviAIChatTokenChunk chunk = new GviAIChatTokenChunk("", true);
            String json = new Gson().toJson((Object)chunk) + "\n";
            out.write(json.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException ex) {
            OlapLoggers.AI_RESPONSE.error((Object)"[AI] LLM generating response : closing stream on error", (Throwable)ex);
        }
        OlapLoggers.AI_RESPONSE.info((Object)"[AI] LLM generating response : closing stream completed");
    }

    static interface Generator {
        public void generate(StreamingResponseHandler<AiMessage> var1);
    }

    static class TunneledException
    extends RuntimeException {
        final GviError error;

        TunneledException(GviError error) {
            this.error = error;
        }
    }
}

