/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;

public class GviAIChatMessage {
    private final Role role;
    private final String content;

    public GviAIChatMessage(Role role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatMessage asLangChainMessage() {
        if (this.role == Role.system) {
            return new SystemMessage(this.content);
        }
        if (this.role == Role.assistant) {
            return new AiMessage(this.content);
        }
        if (this.role == Role.user) {
            return new UserMessage(this.content);
        }
        throw new RuntimeException("internal error : unexpected message role [" + String.valueOf((Object)this.role) + "]");
    }

    public static enum Role {
        system,
        user,
        assistant;

    }
}

