/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.chat;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.chat.GviAIChat;
import crazydev.iccube.server.gvi.request.chat.GviAIChatHistory;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModel;
import crazydev.iccube.server.gvi.request.chat.GviAIChatMessage;
import crazydev.iccube.server.gvi.request.chat.GviAIChatMetaChunk;
import crazydev.iccube.server.gvi.request.chat.GviAIChatStreamResponse;
import crazydev.iccube.server.gvi.request.chat.GviAIChatType;
import crazydev.iccube.server.gvi.request.chat.GviAIConfiguration;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.GviStreamingResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.common.errors.GviException;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GviAIChatCompletionQuery
extends GviSchemaOlapEngineQuery {
    private final GviAIConfiguration configuration;
    private final GviAIChat chat;

    public GviAIChatCompletionQuery(String uuid, GviAIConfiguration configuration, GviAIChat chat) {
        super(uuid, configuration.schema);
        this.configuration = configuration;
        this.chat = chat;
    }

    @Override
    public GviQueryKind getKind() {
        return GviQueryKind.OTHER;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "AI Widget Chat Completion";
    }

    @Override
    @Nullable
    public String getSchema() {
        return super.getSchema();
    }

    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws OlapMissingSchemaException, GviException {
        try {
            IcCubeServerApplicationContext aContext = queryContext.getIcCubeServerRequestContext().getApplicationContext();
            IcCubeAIConfiguration ai = aContext.getConfiguration().getAIConfiguration();
            if (ai.isActive()) {
                if (this.chat.type == GviAIChatType.init) {
                    return this.doExecuteInit(queryContext, ai);
                }
                if (this.chat.type == GviAIChatType.ask) {
                    return this.doExecuteAsk(queryContext, ai);
                }
                OlapLoggers.REQUEST.warn((Object)("AI Chat internal error : unexpected type [" + String.valueOf((Object)this.chat.type) + "]"));
                return new GviGenericErrorResponse(new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{"The AI has encountered an internal error."}));
            }
            OlapLoggers.REQUEST.warn((Object)"AI Chat not activated");
            return new GviGenericErrorResponse(new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{"The AI feature is not activated on the server."}));
        }
        catch (Exception ex) {
            OlapLoggers.REQUEST.error((Object)"AI Chat error", (Throwable)ex);
            return new GviGenericErrorResponse(new GviError(GviErrorCode.AI_CHAT_ERROR, new Serializable[]{ex.getMessage()}));
        }
    }

    private GviResponse doExecuteInit(GviQueryContext context, IcCubeAIConfiguration ai) {
        String prompt = this.createInitialPrompt(ai);
        List<ChatMessage> messages = this.createMessages(ai, prompt, null);
        return this.doSendTokens(context, ai, prompt, messages);
    }

    private GviResponse doExecuteAsk(GviQueryContext context, IcCubeAIConfiguration ai) {
        String prompt = this.chat.question;
        List<ChatMessage> messages = this.createMessages(ai, prompt, this.chat.history);
        return this.doSendTokens(context, ai, prompt, messages);
    }

    private GviResponse doSendTokens(GviQueryContext context, IcCubeAIConfiguration ai, String prompt, List<ChatMessage> messages) {
        GviAIChatLlmModel llm = ai.createLlmModel();
        GviAIChatStreamResponse response = llm.ask(this.configuration, messages);
        GviAIChatMetaChunk metaChunk = new GviAIChatMetaChunk(this.chat.type, this.configuration.schema, this.chat.question, new GviAIChatMessage(GviAIChatMessage.Role.user, prompt));
        HttpServletResponse servletResponse = context.getIcCubeServerRequestContext().getHttpResponse();
        servletResponse.setContentType("application/x-ndjson");
        servletResponse.setStatus(200);
        response.stream(context, metaChunk);
        return new GviStreamingResponse();
    }

    private String createInitialPrompt(IcCubeAIConfiguration ai) {
        String iPrompt;
        String prompt = null;
        if (CdStringUtils.isNotNullAndNotBlank((String)this.configuration.initialPrompt)) {
            prompt = this.configuration.initialPrompt;
        }
        if (prompt == null && CdStringUtils.isNotNullAndNotBlank((String)(iPrompt = ai.getInitialPrompt()))) {
            prompt = iPrompt;
        }
        if (prompt == null) {
            prompt = "You are a data analyst replying to user questions. Here is a data table.\n\nThe name of the table is :\n\n${tableName}\n\nThe content of the table is :\n\n${tableContent}\n\n${initialPromptPage0}\n\nQuestion :\n\n${initialQuestion}\n";
        }
        String initialPromptPage0 = this.createInitialPromptPage0(ai);
        prompt = prompt.replace("${tableName}", this.chat.tableName).replace("${tableContent}", this.chat.tableData).replace("${initialPromptPage0}", initialPromptPage0).replace("${initialQuestion}", this.chat.question);
        return prompt;
    }

    private String createInitialPromptPage0(IcCubeAIConfiguration ai) {
        String iPrompt;
        if (CdStringUtils.isNullOrBlank((String)this.chat.tableDataCaptionPage0)) {
            return "";
        }
        String prompt = null;
        if (CdStringUtils.isNotNullAndNotBlank((String)this.configuration.initialPromptPage0)) {
            prompt = this.configuration.initialPromptPage0;
        }
        if (prompt == null && CdStringUtils.isNotNullAndNotBlank((String)(iPrompt = ai.getInitialPromptPage0()))) {
            prompt = iPrompt;
        }
        if (prompt == null) {
            prompt = "The values of the table represent :\n\n${tableDataCaptionPage0}\n";
        }
        prompt = prompt.replace("${tableDataCaptionPage0}", this.chat.tableDataCaptionPage0);
        return prompt;
    }

    private List<ChatMessage> createMessages(IcCubeAIConfiguration ai, String prompt, @Nullable GviAIChatHistory history) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        String sPrompt = this.systemPrompt(ai, this.configuration.systemPrompt);
        if (sPrompt != null) {
            messages.add((ChatMessage)new SystemMessage(sPrompt));
        }
        if (history != null) {
            for (GviAIChatMessage message : history.messages) {
                messages.add(message.asLangChainMessage());
            }
        }
        messages.add((ChatMessage)new UserMessage(prompt));
        return messages;
    }

    @Nullable
    private String systemPrompt(IcCubeAIConfiguration ai, @Nullable String systemPrompt) {
        if (CdStringUtils.isNotNullAndNotBlank((String)systemPrompt)) {
            return systemPrompt;
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)ai.getSystemPrompt())) {
            return ai.getSystemPrompt();
        }
        return null;
    }
}

