/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

@XmlRootElement(name="gviComponentConfiguration")
public class GviComponentConfiguration {
    @XmlElement(name="url", required=true)
    private String url;
    @XmlElement(name="csrfOff", required=false)
    private boolean csrfOff;
    @XmlElement(name="enableCompression", required=false)
    private boolean enableCompression = true;
    @XmlElement(name="filter", required=true)
    private List<String> filters;

    protected GviComponentConfiguration() {
    }

    public void validate() throws OlapConfigurationException {
        if (this.url == null || CdStringUtils.isNullOrBlank((String)this.url)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"url"});
        }
        if (this.filters == null || this.filters.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"GVI authentication filter"});
        }
        for (String filter : this.filters) {
            if (!CdStringUtils.isNullOrBlank((String)filter)) continue;
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"GVI authentication filter"});
        }
    }

    public String getUrl() {
        return this.url.trim();
    }

    public List<String> getFilterConfiguration() {
        return this.filters;
    }

    public boolean isWithCSRF() {
        return !this.csrfOff;
    }
}

