/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="icCubeProperty")
public class IcCubeServerProperty {
    @XmlAttribute(name="value", required=true)
    private String value;

    public IcCubeServerProperty() {
    }

    public IcCubeServerProperty(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    private void preValidateForSystemProperty() {
        this.value = CdConfigurationUtils.substVars((String)(this.value != null ? this.value : ""));
    }

    public void validateAsBoolean(String name) throws OlapConfigurationException {
        this.preValidateForSystemProperty();
        try {
            this.asBoolean();
        }
        catch (RuntimeException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.PROPERTY_TYPE_ERROR, new Serializable[]{name, "boolean", ex.getMessage()});
        }
    }

    public void validateAsInteger(String name) throws OlapConfigurationException {
        this.preValidateForSystemProperty();
        try {
            this.asInteger();
        }
        catch (RuntimeException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.PROPERTY_TYPE_ERROR, new Serializable[]{name, "integer", ex.getMessage()});
        }
    }

    public void validateAsIntegers(String name) throws OlapConfigurationException {
        this.preValidateForSystemProperty();
        try {
            this.asIntegers();
        }
        catch (RuntimeException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.PROPERTY_TYPE_ERROR, new Serializable[]{name, "integers", ex.getMessage()});
        }
    }

    public void validateAsFileSystemRoot(String name) throws OlapConfigurationException {
        this.preValidateForSystemProperty();
        if (CdStringUtils.isNullOrBlank((String)this.value)) {
            return;
        }
        File path = new File(this.value);
        if (!path.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CONFIGURATION_FILE_PROPERTY_NOT_EXISTING, new Serializable[]{name, this.value});
        }
        if (!path.isDirectory()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CONFIGURATION_FILE_PROPERTY_NOT_DIRECTORY, new Serializable[]{name, this.value});
        }
        if (!path.isAbsolute()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CONFIGURATION_FILE_PROPERTY_NOT_ABSOLUTE, new Serializable[]{name, this.value});
        }
    }

    public File asDirectory() {
        return new File(this.value);
    }

    public boolean asBoolean() {
        return "true".equalsIgnoreCase(this.value) || "yes".equalsIgnoreCase(this.value);
    }

    public int asInteger() {
        return Integer.parseInt(this.value);
    }

    public List<Integer> asIntegers() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        String[] vs = this.value.split(",");
        if (vs != null) {
            for (String v : vs) {
                if (!CdStringUtils.isNotNullAndNotBlank((String)v)) continue;
                sizes.add(Integer.parseInt(v.trim()));
            }
        }
        return sizes;
    }

    public String asString() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

