/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration;

import crazydev.common.collection.CdPair;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.configuration.IcCubeServerProperty;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="icCubeProperties")
public class IcCubeServerProperties {
    @XmlElement(name="fatalErrorExit", required=false)
    private IcCubeServerProperty fatalErrorExit;
    @XmlElement(name="disableEditOwnsRole", required=false)
    private IcCubeServerProperty disableEditOwnsRole;
    @XmlElement(name="disableLoadOnStartupSchema", required=false)
    private IcCubeServerProperty disableLoadOnStartupSchema;
    @XmlElement(name="gcInfoActive", required=false)
    private IcCubeServerProperty gcInfoActive;
    @XmlElement(name="gcInfoMillis", required=false)
    private IcCubeServerProperty gcInfoMillis;
    @XmlElement(name="loadAverageSeconds", required=false)
    private IcCubeServerProperty loadAverageSeconds;
    @XmlElement(name="fileSystemRoot", required=true)
    private IcCubeServerProperty fileSystemRoot;
    @XmlElement(name="fileSystemRootVisibleInDocs", required=false)
    private IcCubeServerProperty fileSystemRootVisibleInDocs;
    @XmlElement(name="additionalPlugins", required=false)
    private IcCubeServerProperty additionalPlugins;
    @XmlElement(name="systemTrayIcon", required=true)
    private IcCubeServerProperty systemTrayIcon;
    @XmlElement(name="maxSchemaDefinitionFileSizeForDeploymentZipped", required=true)
    private IcCubeServerProperty maxSchemaDefinitionFileSizeForDeploymentZipped;
    @XmlElement(name="maxFileSizeForGuiVisualization", required=true)
    private IcCubeServerProperty maxFileSizeForGuiVisualization;
    @XmlElement(name="maxChildrenCountForMdxDebugger", required=true)
    private IcCubeServerProperty maxChildrenCountForMdxDebugger;
    @XmlElement(name="maxChildrenCountForSchemaBrowser", required=true)
    private IcCubeServerProperty maxChildrenCountForSchemaBrowser;
    @XmlElement(name="maxMemberCountForBrowseDimension", required=false)
    private IcCubeServerProperty maxMemberCountForBrowseDimension;
    @XmlElement(name="maxRowCountForBrowseDataTable", required=true)
    private IcCubeServerProperty maxRowCountForBrowseDataTable;
    @XmlElement(name="unmapOff", required=false)
    private IcCubeServerProperty unmapOff = new IcCubeServerProperty("false");
    @XmlElement(name="vectorParallelSortOff", required=false)
    private IcCubeServerProperty vectorParallelSortOff = new IcCubeServerProperty("false");
    @XmlElement(name="singleMeasureDimensionalityOff", required=false)
    private IcCubeServerProperty singleMeasureDimensionalityOff = new IcCubeServerProperty("false");
    @XmlElement(name="nonMappedPermissionsOff", required=false)
    private IcCubeServerProperty nonMappedPermissionsOff = new IcCubeServerProperty("false");
    @XmlElement(name="schemaPermissionsCacheOff", required=false)
    private IcCubeServerProperty schemaPermissionsCacheOff = new IcCubeServerProperty("false");
    @XmlElement(name="ux.pagination.pageSize", required=false)
    private IcCubeServerProperty uxPaginationPageSize = new IcCubeServerProperty("10");
    @XmlElement(name="ux.pagination.pageSizes", required=false)
    private IcCubeServerProperty uxPaginationPageSizes = new IcCubeServerProperty("5, 10, 20, 30, 40, 50");
    @XmlElement(name="report.refreshOnDataUpdate.waitTimeout", required=false)
    private IcCubeServerProperty reportRefreshOnDataUpdateWaitTimeout = new IcCubeServerProperty("600");
    @XmlElement(name="login.form.redirect", required=false)
    private IcCubeServerProperty loginFormRedirect = new IcCubeServerProperty("false");
    @XmlElement(name="mdx.parsedMeta", required=false)
    private IcCubeServerProperty mdxParsedMeta = new IcCubeServerProperty("on");

    public IcCubeServerProperties() {
    }

    public IcCubeServerProperties(String fileSystemRoot, boolean systemTrayIcon, int maxSchemaDefinitionFileSizeForDeployment, int maxFileSizeForGuiVisualization, int maxChildrenCountForMdxDebugger, int maxChildrenCountForSchemaBrowser, int maxRowCountForBrowseDataTable, boolean unmapOff, boolean vectorParallelSortOff) {
        this.disableLoadOnStartupSchema = new IcCubeServerProperty("false");
        this.gcInfoActive = new IcCubeServerProperty("false");
        this.gcInfoMillis = new IcCubeServerProperty("200");
        this.loadAverageSeconds = new IcCubeServerProperty("20");
        this.fileSystemRoot = new IcCubeServerProperty(String.valueOf(fileSystemRoot));
        this.systemTrayIcon = new IcCubeServerProperty(String.valueOf(systemTrayIcon));
        this.maxSchemaDefinitionFileSizeForDeploymentZipped = new IcCubeServerProperty(String.valueOf(maxSchemaDefinitionFileSizeForDeployment));
        this.maxFileSizeForGuiVisualization = new IcCubeServerProperty(String.valueOf(maxFileSizeForGuiVisualization));
        this.maxChildrenCountForMdxDebugger = new IcCubeServerProperty(String.valueOf(maxChildrenCountForMdxDebugger));
        this.maxChildrenCountForSchemaBrowser = new IcCubeServerProperty(String.valueOf(maxChildrenCountForSchemaBrowser));
        this.maxRowCountForBrowseDataTable = new IcCubeServerProperty(String.valueOf(maxRowCountForBrowseDataTable));
        this.unmapOff = new IcCubeServerProperty(String.valueOf(unmapOff));
        this.vectorParallelSortOff = new IcCubeServerProperty(String.valueOf(vectorParallelSortOff));
    }

    public void validate() throws OlapConfigurationException {
        if (this.fatalErrorExit == null) {
            this.fatalErrorExit = new IcCubeServerProperty("true");
        }
        this.validateBooleanProperty("fatalErrorExit", Flag.OPTIONAL);
        this.validateBooleanProperty("disableEditOwnsRole", Flag.OPTIONAL);
        this.validateBooleanProperty("disableLoadOnStartupSchema", Flag.OPTIONAL);
        this.validateBooleanProperty("gcInfoActive", Flag.OPTIONAL);
        this.validateIntegerProperty("gcInfoMillis", Flag.OPTIONAL);
        this.validateIntegerProperty("loadAverageSeconds", Flag.OPTIONAL);
        this.validateFileSystemRootProperty();
        this.validateBooleanProperty("systemTrayIcon", Flag.MANDATORY);
        this.validateIntegerProperty("maxSchemaDefinitionFileSizeForDeploymentZipped", Flag.MANDATORY);
        this.validateIntegerProperty("maxFileSizeForGuiVisualization", Flag.MANDATORY);
        this.validateIntegerProperty("maxChildrenCountForMdxDebugger", Flag.MANDATORY);
        this.validateIntegerProperty("maxChildrenCountForSchemaBrowser", Flag.MANDATORY);
        if (this.maxMemberCountForBrowseDimension == null) {
            this.maxMemberCountForBrowseDimension = new IcCubeServerProperty("100000");
        }
        this.validateIntegerProperty("maxMemberCountForBrowseDimension", Flag.MANDATORY);
        this.validateIntegerProperty("maxRowCountForBrowseDataTable", Flag.MANDATORY);
        this.validateBooleanProperty("unmapOff", Flag.OPTIONAL);
        this.validateBooleanProperty("vectorParallelSortOff", Flag.OPTIONAL);
        this.validateBooleanProperty("singleMeasureDimensionalityOff", Flag.OPTIONAL);
        this.validateIntegerProperty("uxPaginationPageSize", Flag.OPTIONAL);
        this.validateIntegersProperty("uxPaginationPageSizes", Flag.OPTIONAL);
        this.validateIntegerProperty("reportRefreshOnDataUpdateWaitTimeout", Flag.OPTIONAL);
        this.validateBooleanProperty("loginFormRedirect", Flag.OPTIONAL);
    }

    private void validateFileSystemRootProperty() throws OlapConfigurationException {
        if (this.fileSystemRoot == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_IS_MISSING, new Serializable[]{"icCubeProperties:fileSystemRoot"});
        }
        this.fileSystemRoot.validateAsFileSystemRoot("fileSystemRoot");
    }

    private void validateBooleanProperty(String name, Flag flag) throws OlapConfigurationException {
        try {
            Field field = this.getClass().getDeclaredField(name);
            IcCubeServerProperty property = (IcCubeServerProperty)field.get(this);
            if (property == null && flag == Flag.MANDATORY) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_IS_MISSING, new Serializable[]{"icCubeProperties:" + name});
            }
            if (property != null) {
                property.validateAsBoolean(name);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new CdProgrammingException("Property [" + name + "] error", (Throwable)ex);
        }
    }

    private void validateIntegerProperty(String name, Flag flag) throws OlapConfigurationException {
        try {
            Field field = this.getClass().getDeclaredField(name);
            IcCubeServerProperty property = (IcCubeServerProperty)field.get(this);
            if (property == null && flag == Flag.MANDATORY) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_IS_MISSING, new Serializable[]{"icCubeProperties:" + name});
            }
            if (property != null) {
                property.validateAsInteger(name);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new CdProgrammingException("icCube server property [" + name + "] error", (Throwable)ex);
        }
    }

    private void validateIntegersProperty(String name, Flag flag) throws OlapConfigurationException {
        try {
            Field field = this.getClass().getDeclaredField(name);
            IcCubeServerProperty property = (IcCubeServerProperty)field.get(this);
            if (property == null && flag == Flag.MANDATORY) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.PROPERTY_IS_MISSING, new Serializable[]{"icCubeProperties:" + name});
            }
            if (property != null) {
                property.validateAsIntegers(name);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new CdProgrammingException("icCube server property [" + name + "] error", (Throwable)ex);
        }
    }

    public List<CdPair<String, String>> getOrderedProperties() {
        try {
            ArrayList<CdPair<String, String>> ordered = new ArrayList<CdPair<String, String>>();
            Field[] fields = this.getClass().getDeclaredFields();
            if (fields != null) {
                for (Field field : fields) {
                    if (!IcCubeServerProperty.class.isAssignableFrom(field.getType())) continue;
                    IcCubeServerProperty property = (IcCubeServerProperty)field.get(this);
                    String value = property == null ? null : property.getValue();
                    ordered.add((CdPair<String, String>)new CdPair((Object)field.getName(), (Object)(value == null ? "<null>" : value)));
                }
            }
            Collections.sort(ordered, new Comparator<CdPair<String, String>>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(CdPair<String, String> o1, CdPair<String, String> o2) {
                    return ((String)o1.fst).compareTo((String)o2.fst);
                }
            });
            return ordered;
        }
        catch (IllegalAccessException ex) {
            throw new CdProgrammingException("icCube server properties error", (Throwable)ex);
        }
    }

    public boolean isFatalErrorExit() {
        return this.fatalErrorExit == null || this.fatalErrorExit.asBoolean();
    }

    public boolean isDisableEditOwnsRole() {
        return this.disableEditOwnsRole != null && this.disableEditOwnsRole.asBoolean();
    }

    public boolean isDisableLoadOnStartupSchema() {
        return this.disableLoadOnStartupSchema != null && this.disableLoadOnStartupSchema.asBoolean();
    }

    public boolean isGcInfoActive() {
        return this.gcInfoActive != null && this.gcInfoActive.asBoolean();
    }

    public int getGcInfoMillis() {
        return this.gcInfoMillis == null ? 200 : this.gcInfoMillis.asInteger();
    }

    public int getLoadAverageSeconds() {
        return this.loadAverageSeconds == null ? 20 : this.loadAverageSeconds.asInteger();
    }

    @Nullable
    public File getFileSystemRoot() {
        if (this.fileSystemRoot.getValue().isEmpty()) {
            return null;
        }
        return this.fileSystemRoot.asDirectory();
    }

    public void setFileSystemRoot(IcCubeServerProperty fileSystemRoot) {
        this.fileSystemRoot = fileSystemRoot;
    }

    public boolean isFileSystemRootVisibleInDocs() {
        if (this.fileSystemRootVisibleInDocs == null) {
            return false;
        }
        return this.fileSystemRootVisibleInDocs.asBoolean();
    }

    @Nullable
    public File getAdditionalPlugins() {
        if (this.additionalPlugins == null || CdStringUtils.isNullOrBlank((String)this.additionalPlugins.getValue())) {
            return null;
        }
        File directory = this.additionalPlugins.asDirectory();
        if (!directory.isDirectory()) {
            return null;
        }
        return directory;
    }

    public boolean isSystemTrayIcon() {
        return this.systemTrayIcon.asBoolean();
    }

    public int getMaxSchemaDefinitionFileSizeForDeployment() {
        return this.maxSchemaDefinitionFileSizeForDeploymentZipped.asInteger();
    }

    public int getMaxFileSizeForGuiVisualization() {
        return this.maxFileSizeForGuiVisualization.asInteger();
    }

    public int getMaxChildrenCountForMdxDebugger() {
        return this.maxChildrenCountForMdxDebugger.asInteger();
    }

    public int getMaxChildrenCountForSchemaBrowser() {
        return this.maxChildrenCountForSchemaBrowser.asInteger();
    }

    public int getMaxMemberCountForBrowseDimension() {
        return this.maxMemberCountForBrowseDimension != null ? this.maxMemberCountForBrowseDimension.asInteger() : 100000;
    }

    public int getMaxRowCountForBrowseDataTable() {
        return this.maxRowCountForBrowseDataTable.asInteger();
    }

    public boolean isUnmapOff() {
        return this.unmapOff != null && this.unmapOff.asBoolean();
    }

    public boolean isVectorParallelSortOff() {
        return this.vectorParallelSortOff != null && this.vectorParallelSortOff.asBoolean();
    }

    public void fixSingleMeasureDimensionalityOffForTest() {
        this.singleMeasureDimensionalityOff = new IcCubeServerProperty("true");
    }

    public boolean isSingleMeasureDimensionalityOff() {
        return this.singleMeasureDimensionalityOff != null && this.singleMeasureDimensionalityOff.asBoolean();
    }

    public boolean isNonMappedPermissionsOff() {
        return this.nonMappedPermissionsOff != null && this.nonMappedPermissionsOff.asBoolean();
    }

    public boolean isSchemaPermissionsCacheOff() {
        return this.schemaPermissionsCacheOff != null && this.schemaPermissionsCacheOff.asBoolean();
    }

    public int getUxPaginationPageSize() {
        return this.uxPaginationPageSize != null ? this.uxPaginationPageSize.asInteger() : 10;
    }

    public List<Integer> getUxPaginationPageSizes() {
        return this.uxPaginationPageSizes != null ? this.uxPaginationPageSizes.asIntegers() : Arrays.asList(5, 10, 20, 30, 40, 50);
    }

    public int getReportRefreshOnDataUpdateWaitTimeout() {
        return this.reportRefreshOnDataUpdateWaitTimeout != null ? this.reportRefreshOnDataUpdateWaitTimeout.asInteger() : 600;
    }

    public boolean isLoginFormRedirect() {
        return this.loginFormRedirect != null && this.loginFormRedirect.asBoolean();
    }

    public boolean isMdxParseMeta() {
        return this.mdxParsedMeta == null || "on".equalsIgnoreCase(this.mdxParsedMeta.asString());
    }

    static enum Flag {
        MANDATORY,
        OPTIONAL;

    }
}

