/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.OlapServletFilterConfiguration;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@XmlRootElement(name="filterConfiguration")
public class IcCubeServerFilterConfiguration {
    @XmlElement(name="filter", required=true)
    private List<OlapServletFilterConfiguration> filters;

    protected IcCubeServerFilterConfiguration() {
    }

    public void validate() throws OlapConfigurationException {
        if (this.filters == null || this.filters.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"filter"});
        }
        for (OlapServletFilterConfiguration filter : this.filters) {
            filter.validate();
        }
        HashSet<String> uniques = new HashSet<String>();
        for (OlapServletFilterConfiguration filter : this.filters) {
            if (uniques.contains(filter.getFilterName())) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.CONFIGURATION_DUPLICATED_FILTER, new Serializable[]{filter.getFilterName()});
            }
            uniques.add(filter.getFilterName());
        }
    }

    public List<OlapServletFilterConfiguration> getFilters() {
        return this.filters == null ? new ArrayList() : this.filters;
    }
}

