/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authorization.permissions.service.OlapOnTheFlyRolePermissionsService;
import crazydev.iccube.collection.olapiterator.cache.OlapCachingIterator;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.OlapWebAppConfiguration;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.authentication.IcCubeAuthenticationServiceConfiguration;
import crazydev.iccube.server.authorization.IcCubeAuthorizationServiceConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfigurations;
import crazydev.iccube.server.configuration.IcCubeCancellingRequestConfiguration;
import crazydev.iccube.server.configuration.IcCubeClusterConfiguration;
import crazydev.iccube.server.configuration.IcCubeEnvironmentConfiguration;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.configuration.IcCubeMultiTenantConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerFilterConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.configuration.IcCubeTimeoutRequestConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.xmla.IcCubeXmlaComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="icCubeConfiguration")
public class IcCubeServerConfiguration {
    public static final String IC_CUBE_LOG_DIRECTORY = "icCube.logDirectory";
    public static final String CONFIGURATION_FILE_ENCODING = "UTF-8";
    public static final String LOG_FILE_ENCODING = "UTF-8";
    private static final IcCubeClusterConfiguration CLUSTER_INACTIVE = new IcCubeClusterConfiguration(false);
    @XmlTransient
    private final IcCubeAuthorizationServiceConfiguration authorizationService = new IcCubeAuthorizationServiceConfiguration(OlapOnTheFlyRolePermissionsService.class.getName());
    @XmlElement(name="id", required=false)
    private String id = "n/a";
    @XmlElement(name="environment", required=false)
    private IcCubeEnvironmentConfiguration environment;
    @XmlElement(name="icCubeAuthenticationService", required=true)
    private IcCubeAuthenticationServiceConfiguration authenticationService;
    @XmlElement(name="webApp", required=false)
    @Nullable
    private OlapWebAppConfiguration webAppConfiguration;
    @XmlElement(name="icCubeProperties", required=true)
    private IcCubeServerProperties properties;
    @XmlElement(name="directories", required=true)
    private OlapDirectoriesConfiguration directories;
    @XmlElement(name="olapEngineComponentConfiguration", required=true)
    private OlapEngineComponentConfiguration olapEngineConfiguration;
    @XmlElement(name="httpComponentConfiguration", required=false)
    @Nullable
    private IcCubeHttpComponentConfiguration httpConfiguration;
    @XmlElement(name="xmlaComponentConfiguration", required=false)
    @Nullable
    private IcCubeXmlaComponentConfiguration xmlaConfiguration;
    @XmlElement(name="uxComponentConfiguration", required=false)
    @Nullable
    private UxComponentConfiguration uxConfiguration;
    @XmlElement(name="reportingComponentConfiguration", required=false)
    @Nullable
    private OlapReportingComponentConfiguration reportingConfiguration;
    @XmlElement(name="gviComponentConfiguration", required=false)
    @Nullable
    private GviComponentConfiguration gviConfiguration;
    @XmlElement(name="printComponentConfiguration", required=false)
    @Nullable
    private IcCubePrintComponentConfiguration printConfiguration;
    @XmlElement(name="mimeTypes", required=false)
    @Nullable
    private IcCubeMimeTypesConfiguration mimeTypesConfiguration;
    @XmlElement(name="filterConfiguration", required=true)
    private IcCubeServerFilterConfiguration filterConfiguration;
    @XmlElement(name="cancellingRequestConfiguration", required=false)
    @Nullable
    private IcCubeCancellingRequestConfiguration cancellingRequestConfiguration;
    @XmlElement(name="timeoutRequestConfiguration", required=false)
    @Nullable
    private IcCubeTimeoutRequestConfiguration timeoutRequestConfiguration;
    @XmlElement(name="monitoringConfigurations", required=false)
    @Nullable
    private IcBigBrotherMgrConfigurations monitoringConfigurations;
    @XmlElement(name="multiTenantConfiguration", required=false)
    @Nullable
    private IcCubeMultiTenantConfiguration multiTenantConfiguration;
    @XmlElement(name="clusterConfiguration", required=false)
    @Nullable
    private IcCubeClusterConfiguration clusterConfiguration;
    @XmlElement(name="aiConfiguration", required=false)
    @Nullable
    private IcCubeAIConfiguration aiConfiguration;
    @XmlElement(name="userDefinedProperties", required=false)
    @Nullable
    private OlapUserDefinedProperties userDefinedProperties;
    @XmlTransient
    @Nullable
    private File xmlFile;

    public static IcCubeServerConfiguration parseFromXml(File file) throws JAXBException, IOException {
        IcCubeServerConfiguration configuration = (IcCubeServerConfiguration)CdXmlUtils.unmarshall((boolean)true, (String)"UTF-8", (File)file, (Class[])new Class[]{IcCubeServerConfiguration.class});
        configuration.xmlFile = file;
        return configuration;
    }

    @Nullable
    public File getXmlFile() {
        return this.xmlFile;
    }

    public void validate(OlapRuntime runtime, boolean withMultiTenant) throws OlapConfigurationException {
        if (this.environment != null) {
            this.environment.validate();
        }
        if (this.properties == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"properties"});
        }
        this.properties.validate();
        if (this.directories == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"directories"});
        }
        this.directories.validate(runtime, withMultiTenant);
        if (this.userDefinedProperties != null) {
            this.userDefinedProperties.validate(runtime);
        }
        if (this.olapEngineConfiguration == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"olapEngineComponentConfiguration"});
        }
        this.olapEngineConfiguration.validate(this.userDefinedProperties);
        if (this.httpConfiguration != null) {
            this.httpConfiguration.validate();
        }
        if (this.xmlaConfiguration != null) {
            this.xmlaConfiguration.validate();
        }
        if (this.uxConfiguration != null) {
            if (this.httpConfiguration == null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"httpComponentConfiguration"});
            }
            this.uxConfiguration.validate();
        }
        if (this.authenticationService == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"authenticationService"});
        }
        this.authenticationService.validate();
        if (this.authorizationService == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"authorizationService"});
        }
        this.authorizationService.validate();
        if (this.reportingConfiguration != null) {
            if (this.httpConfiguration == null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"httpComponentConfiguration"});
            }
            this.reportingConfiguration.validate();
        }
        if (this.gviConfiguration != null) {
            if (this.httpConfiguration == null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"httpComponentConfiguration"});
            }
            this.gviConfiguration.validate();
        }
        if (this.printConfiguration != null) {
            if (this.httpConfiguration == null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"httpComponentConfiguration"});
            }
            this.printConfiguration.validate();
        }
        if (this.mimeTypesConfiguration != null) {
            this.mimeTypesConfiguration.validate();
        }
        if (this.monitoringConfigurations != null) {
            this.monitoringConfigurations.validate(runtime);
        }
        if (this.multiTenantConfiguration != null) {
            this.multiTenantConfiguration.validate();
        }
        if (this.clusterConfiguration == null) {
            this.clusterConfiguration = new IcCubeClusterConfiguration(false);
        }
        this.clusterConfiguration.validate();
        if (this.aiConfiguration == null) {
            this.aiConfiguration = new IcCubeAIConfiguration(false);
        }
        this.aiConfiguration.validate();
        if (this.filterConfiguration == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"filterConfiguration"});
        }
        this.filterConfiguration.validate();
        if (this.cancellingRequestConfiguration == null) {
            this.cancellingRequestConfiguration = IcCubeCancellingRequestConfiguration.defaultConfiguration();
        }
        this.cancellingRequestConfiguration.validate();
        if (this.timeoutRequestConfiguration == null) {
            this.timeoutRequestConfiguration = IcCubeTimeoutRequestConfiguration.defaultConfiguration();
        }
        this.timeoutRequestConfiguration.validate();
        if (this.webAppConfiguration != null) {
            this.webAppConfiguration.validate();
        }
        OlapProperties properties = this.olapEngineConfiguration.getProperties();
        OlapCachingIterator.MAX_BUFFER_SIZE = properties.getMaxBufferSizeForCachingIterator();
    }

    public String getId() {
        String validId = this.id;
        if (CdStringUtils.isNotNullAndNotBlank((String)validId)) {
            validId = CdConfigurationUtils.substVars((String)validId);
        }
        if (CdStringUtils.isNullOrBlank((String)validId)) {
            validId = "n/a";
        }
        return validId;
    }

    public String getEnvironmentName() {
        return this.environment == null ? "" : this.environment.getName();
    }

    @Nullable
    public String getEnvironmentColor() {
        return this.environment == null ? null : this.environment.getHtmlColor();
    }

    public OlapDirectoriesConfiguration getDirectories() {
        return this.directories;
    }

    public IcCubeServerProperties getProperties() {
        return this.properties;
    }

    public OlapEngineComponentConfiguration getOlapEngineConfiguration() {
        return this.olapEngineConfiguration;
    }

    @Nullable
    public OlapWebAppConfiguration getWebAppConfiguration() {
        return this.webAppConfiguration;
    }

    @Nullable
    public IcCubeHttpComponentConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    @Nullable
    public IcCubeXmlaComponentConfiguration getXmlaConfiguration() {
        return this.xmlaConfiguration;
    }

    @Nullable
    public UxComponentConfiguration getUxConfiguration() {
        return this.uxConfiguration;
    }

    @Nullable
    public OlapReportingComponentConfiguration getReportingConfiguration() {
        return this.reportingConfiguration;
    }

    @Nullable
    public GviComponentConfiguration getGviConfiguration() {
        return this.gviConfiguration;
    }

    @Nullable
    public IcCubePrintComponentConfiguration getPrintConfiguration() {
        return this.printConfiguration;
    }

    public IcCubeAuthenticationServiceConfiguration getAuthenticationService() {
        return this.authenticationService;
    }

    public IcCubeAuthorizationServiceConfiguration getAuthorizationService() {
        return this.authorizationService;
    }

    @Nullable
    public IcCubeMimeTypesConfiguration getMimeTypesConfiguration() {
        return this.mimeTypesConfiguration;
    }

    public OlapUserDefinedProperties getUserDefinedProperties() {
        return this.userDefinedProperties == null ? new OlapUserDefinedProperties() : this.userDefinedProperties;
    }

    public IcCubeServerFilterConfiguration getFilterConfiguration() {
        return this.filterConfiguration;
    }

    @Nullable
    public IcCubeCancellingRequestConfiguration getCancellingRequestConfiguration() {
        return this.cancellingRequestConfiguration;
    }

    @Nullable
    public IcCubeTimeoutRequestConfiguration getTimeoutRequestConfiguration() {
        return this.timeoutRequestConfiguration;
    }

    @Nullable
    public IcBigBrotherMgrConfigurations getMonitoringConfigurations() {
        return this.monitoringConfigurations;
    }

    public boolean isWithMultiTenant() {
        return this.multiTenantConfiguration != null && this.multiTenantConfiguration.isActive();
    }

    public boolean isInCluster() {
        return this.clusterConfiguration != null && this.clusterConfiguration.isActive();
    }

    public IcCubeClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration != null ? this.clusterConfiguration : CLUSTER_INACTIVE;
    }

    public IcCubeAIConfiguration getAIConfiguration() {
        return this.aiConfiguration != null ? this.aiConfiguration : new IcCubeAIConfiguration(false);
    }
}

