/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.reporter;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditMdxExecutedData;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditOpenReportData;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditWriter;
import java.io.IOException;
import java.io.Serializable;

public class IcBigBrotherOlapCubeReporterStateManager {
    private final Object fileLOCK = new Object();
    private volatile boolean configured;
    private boolean withMultiTenant;
    private IcBigBrotherAuditWriter openReportWriter;
    private IcBigBrotherAuditWriter mdxExecutedWriter;

    public void configure(boolean withMultiTenant, String auditDirectory, String maxFileSize, int maxBackupIndex) throws OlapConfigurationException {
        try {
            this.withMultiTenant = withMultiTenant;
            OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit directory     : " + auditDirectory));
            OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit max-file-size : " + maxFileSize));
            OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit max-backups   : " + maxBackupIndex));
            this.openReportWriter = new IcBigBrotherAuditWriter(auditDirectory, "opened_report.csv", IcBigBrotherAuditOpenReportData.HEADER(withMultiTenant), maxFileSize, maxBackupIndex);
            OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit (opened-report) schema file : " + this.openReportWriter.getAbsolutePath()));
            this.mdxExecutedWriter = new IcBigBrotherAuditWriter(auditDirectory, "mdx.csv", IcBigBrotherAuditMdxExecutedData.HEADER(withMultiTenant), maxFileSize, maxBackupIndex);
            OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit (executed-mdx) schema file : " + this.mdxExecutedWriter.getAbsolutePath()));
            this.configured = true;
        }
        catch (IOException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (!this.configured) {
            return;
        }
        Object object = this.fileLOCK;
        synchronized (object) {
            IcBigBrotherOlapCubeReporterStateManager.flush(this.openReportWriter);
            IcBigBrotherOlapCubeReporterStateManager.flush(this.mdxExecutedWriter);
        }
    }

    private static void flush(IcBigBrotherAuditWriter writer) {
        try {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
        catch (IOException ex) {
            OlapLoggers.BIG_BROTHER.warn((Object)("[monitoring] could not properly close/flush audit file " + writer.getAbsolutePath()), (Throwable)ex);
        }
    }

    public long restoreOpenReportAuditUID() {
        return this.restoreAuditUID(this.openReportWriter);
    }

    public long restoreMdxExecutedAuditUID() {
        return this.restoreAuditUID(this.mdxExecutedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long restoreAuditUID(IcBigBrotherAuditWriter writer) {
        if (!this.configured) {
            throw new RuntimeException("internal error: monitoring state manager not configured yet");
        }
        Object object = this.fileLOCK;
        synchronized (object) {
            try {
                long uid = writer.restoreAuditUID();
                return uid;
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BIG_BROTHER.error((Object)("[monitoring] could not restore audit file (uid) " + writer.getAbsolutePath()), (Throwable)ex);
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuditOpenReport(IcBigBrotherAuditOpenReportData data) {
        if (!this.configured) {
            return;
        }
        Object object = this.fileLOCK;
        synchronized (object) {
            try {
                if (this.openReportWriter != null) {
                    this.openReportWriter.write(data.format(this.withMultiTenant));
                }
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BIG_BROTHER.error((Object)("[monitoring] could not save audit information (persistency de-activated) " + this.openReportWriter.getAbsolutePath()), (Throwable)ex);
                this.openReportWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuditMdxExecuted(IcBigBrotherAuditMdxExecutedData data) {
        if (!this.configured) {
            return;
        }
        Object object = this.fileLOCK;
        synchronized (object) {
            try {
                if (this.mdxExecutedWriter != null) {
                    this.mdxExecutedWriter.write(data.format(this.withMultiTenant));
                }
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BIG_BROTHER.error((Object)("[monitoring] could not save audit information (persistency de-activated) " + this.mdxExecutedWriter.getAbsolutePath()), (Throwable)ex);
                this.mdxExecutedWriter = null;
            }
        }
    }
}

