/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.reporter;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryBufferDataTable;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDataSource;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeEngineUserHelper;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.server.requesthandler.monitoring.schemas.GwtLoadBigBrotherSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapMonitoringLoadContextLoggers;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditMdxExecutedData;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditOpenReportData;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherCounterData;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporterStateManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class IcBigBrotherOlapCubeReporter
implements IcBigBrotherReporter {
    private final String DEFAULT_SCHEMA_NAME = "$Monitoring";
    private final String DEFAULT_CUBE_NAME = "$Monitoring";
    private final Object dataLOCK = new Object();
    private final IcBigBrotherOlapCubeReporterStateManager auditStateManager = new IcBigBrotherOlapCubeReporterStateManager();
    private IcCubeEngine engine;
    private IcCubeEngineUserHelper engineUserSessionContext;
    private boolean useSchemasPerms = false;
    private String schemaName;
    private String cubeName;
    private OlapBuilderSchemaDefFactory factory;
    private OlapBuilderInMemoryBufferDataTable timeTable;
    @Nullable
    private OlapBuilderInMemoryBufferDataTable countersFactsTable;
    private boolean openReportAuditStateManagerOff = false;
    private long openReportAuditUID = 0L;
    private boolean mdxExecutedAuditStateManagerOff = false;
    private long mdxExecutedAuditUID = 0L;
    @Nullable
    private List<IcBigBrotherCounterData> counterTableData;
    private volatile boolean init = false;

    @Override
    public void configure(@Nullable OlapNotificationService notificationService, Map<String, String> params) throws OlapConfigurationException {
        String maxFileSize;
        String useSchemasPerms_ = params.get("useSchemasPerms");
        this.useSchemasPerms = CdStringUtils.isNullOrBlank((String)useSchemasPerms_) ? false : Boolean.valueOf(useSchemasPerms_);
        this.schemaName = params.get("schemaName");
        if (CdStringUtils.isNullOrBlank((String)this.schemaName)) {
            this.schemaName = "$Monitoring";
        }
        this.cubeName = params.get("cubeName");
        if (CdStringUtils.isNullOrBlank((String)this.cubeName)) {
            this.cubeName = "$Monitoring";
        }
        if (CdStringUtils.isNullOrBlank((String)(maxFileSize = params.get("maxFileSize")))) {
            maxFileSize = "2MB";
        }
        int maxBackupIndex = Integer.parseInt(params.get("maxBackupIndex"));
        this.auditStateManager.configure(params.get("$icCube.withMultiTenant$") != null, params.get("$audit$"), maxFileSize, maxBackupIndex);
        this.openReportAuditStateManagerOff = false;
        long uid = this.auditStateManager.restoreOpenReportAuditUID();
        if (uid != -1L) {
            this.openReportAuditUID = uid + 1L;
        } else {
            this.openReportAuditUID = 0L;
            this.openReportAuditStateManagerOff = true;
        }
        this.mdxExecutedAuditStateManagerOff = false;
        uid = this.auditStateManager.restoreMdxExecutedAuditUID();
        if (uid != -1L) {
            this.mdxExecutedAuditUID = uid + 1L;
        } else {
            this.mdxExecutedAuditUID = 0L;
            this.mdxExecutedAuditStateManagerOff = true;
        }
    }

    @Override
    public void init(@Nullable IcCubeServerApplicationContext applicationContext, IcBigBrotherMgrConfiguration config, IcCubeEngine engine, List<IcBigBrotherCounter> beans, boolean auditActivated) {
        this.engine = engine;
        this.engineUserSessionContext = engine.createIcCubeUserSessionContext((IOlapContextLoggers)OlapMonitoringLoadContextLoggers.INSTANCE);
        this.factory = new OlapBuilderSchemaDefFactory(this, this.createSchema(beans, auditActivated)){
            final /* synthetic */ IcBigBrotherOlapCubeReporter this$0;
            {
                IcBigBrotherOlapCubeReporter icBigBrotherOlapCubeReporter = this$0;
                Objects.requireNonNull(icBigBrotherOlapCubeReporter);
                this.this$0 = icBigBrotherOlapCubeReporter;
                super(arg0);
            }

            public boolean isMonitoring() {
                return true;
            }

            public boolean isMonitoringUsingSchemaPerms() {
                return this.this$0.useSchemasPerms;
            }
        };
        OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)applicationContext.getOlapEngineApplicationContext());
        File cubes = rContext.getDirectoriesResolved().getCubesDirectory();
        String fileName = this.factory.getSchemaName() + " (internal XML definition)";
        this.factory.setXmlFile(new File(cubes, fileName));
        String definition = this.generateXmlDefinition(this.factory.getSchemaDefinition());
        if (definition != null) {
            this.factory.setXmlDefinition(definition);
        }
        this.init = true;
    }

    @Override
    public void shutdownNow() {
        this.auditStateManager.shutdownNow();
    }

    @Override
    public void onCounterAddStarted() {
    }

    @Override
    public void onCounterAddCompleted() {
    }

    @Override
    public void onAuditAddStarted() {
    }

    @Override
    public void onAuditAddCompleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCounter(int beanIdx, LocalDateTime time, double min, double max, double avg, long count) {
        Object object = this.dataLOCK;
        synchronized (object) {
            IcBigBrotherCounterData data = new IcBigBrotherCounterData(beanIdx, time, min, max, avg, count);
            if (this.counterTableData == null) {
                this.counterTableData = new ArrayList<IcBigBrotherCounterData>();
            }
            this.counterTableData.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuditOpenReport(LocalDateTime time, @Nullable String tenant, String user, String reportPath, String reportName) {
        Object object = this.dataLOCK;
        synchronized (object) {
            if (!this.openReportAuditStateManagerOff) {
                IcBigBrotherAuditOpenReportData data = new IcBigBrotherAuditOpenReportData(this.openReportAuditUID++, time, tenant, user, reportPath, reportName);
                this.auditStateManager.addAuditOpenReport(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuditMdxExecuted(LocalDateTime time, boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, long elapsedMS) {
        Object object = this.dataLOCK;
        synchronized (object) {
            if (!this.mdxExecutedAuditStateManagerOff) {
                IcBigBrotherAuditMdxExecutedData data = new IcBigBrotherAuditMdxExecutedData(this.mdxExecutedAuditUID++, time, fromCache, reportPath, tenant, user, schemaName, cubeName, statement, (double)elapsedMS / 1000.0);
                this.auditStateManager.addAuditMdxExecuted(data);
            }
        }
    }

    private OlapBuilderSchema createSchema(List<IcBigBrotherCounter> beans, boolean auditActivated) {
        OlapBuilderFacts countersFacts;
        OlapBuilderMultiLevelDimension countersDimension;
        OlapBuilderInMemoryLineDataTable countersTable;
        OlapBuilderSchema schema = new OlapBuilderSchema(this.schemaName, "System cube for monitoring", "icCube", false, true);
        OlapBuilderInMemoryDataSource ds = new OlapBuilderInMemoryDataSource("In Memory");
        if (!beans.isEmpty()) {
            StringBuilder sb = new StringBuilder("BeanIdx,Bean Group,Bean Name,Description\n");
            for (int ii = 0; ii < beans.size(); ++ii) {
                IcBigBrotherCounter bean = beans.get(ii);
                sb.append(ii).append(",").append(bean.getGroupName()).append(",").append(bean.getBeanName()).append(",").append(bean.getDescription()).append("\n");
            }
            countersTable = OlapBuilderInMemoryLineDataTable.__create((OlapBuilderInMemoryDataSource)ds, (String)"Measure beans", (String)sb.toString(), (String)",");
            ((OlapBuilderDataColumn)countersTable.getSelectedColumn(0)).setType(OlapBuilderInputType.INTEGER);
        } else {
            countersTable = null;
        }
        OlapBuilderDataColumn yearDayCol = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "year");
        OlapBuilderDataColumn monthKey = new OlapBuilderDataColumn(OlapBuilderInputType.DATE, "", "monthKey");
        OlapBuilderDataColumn monthDayCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "month");
        OlapBuilderDataColumn dateDayCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "day");
        OlapBuilderDataColumn dateHourCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "hour");
        OlapBuilderDataColumn date15MinCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "15minutes");
        OlapBuilderDataColumn dateTimeCol = new OlapBuilderDataColumn(OlapBuilderInputType.DATETIME, "", "dateTime");
        OlapBuilderDataColumn dateTimeKeyCol = new OlapBuilderDataColumn(OlapBuilderInputType.DATETIME, "", "dateTimeKey");
        OlapBuilderDataColumn dayofWeek = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "dayofWeek");
        OlapBuilderDataColumn dayofWeekKey = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "dayofWeekKey");
        OlapBuilderDataColumn hourofWeek = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "hourofWeek");
        OlapBuilderDataColumn hourofWeekKey = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "hourofWeekKey");
        this.timeTable = new OlapBuilderInMemoryBufferDataTable("Time-Information", new IOlapBuilderDataColumnDef[]{yearDayCol, monthKey, monthDayCol, dateDayCol, dateHourCol, date15MinCol, dateTimeCol, dateTimeKeyCol, dayofWeek, dayofWeekKey, hourofWeek, hourofWeekKey});
        OlapBuilderDataColumn counters_beanIdxCol = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "beanIdx");
        OlapBuilderDataColumn counters_dateHourCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "hour");
        OlapBuilderDataColumn counters_dateTimeKeyCol = new OlapBuilderDataColumn(OlapBuilderInputType.DATETIME, "", "dateTimeKey");
        OlapBuilderDataColumn counters_minCol = new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "", "min");
        OlapBuilderDataColumn counters_maxCol = new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "", "max");
        OlapBuilderDataColumn counters_avgCol = new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "", "avg");
        OlapBuilderDataColumn counters_countCol = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "count");
        if (!beans.isEmpty()) {
            this.countersFactsTable = new OlapBuilderInMemoryBufferDataTable("Counters-Facts", new IOlapBuilderDataColumnDef[]{counters_beanIdxCol, counters_dateHourCol, counters_dateTimeKeyCol, counters_minCol, counters_maxCol, counters_avgCol, counters_countCol});
        }
        OlapBuilderDataColumn audit_dateHourCol = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "hour");
        OlapBuilderDataColumn audit_dateTimeKeyCol = new OlapBuilderDataColumn(OlapBuilderInputType.DATETIME, "", "dateTimeKey");
        OlapBuilderDataColumn audit_user = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "userName");
        OlapBuilderDataColumn audit_report = new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "", "reportName");
        OlapBuilderDataColumn audit_countCol = new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "", "open-report-count");
        ds.link((IOlapBuilderTabularDataDef)this.timeTable);
        if (this.countersFactsTable != null) {
            ds.link((IOlapBuilderTabularDataDef)this.countersFactsTable);
        }
        if (countersTable != null) {
            countersTable.setIncrementalLoadStrategy(OlapIncrementalLoadStrategy.NO_UPDATE);
        }
        this.timeTable.setIncrementalLoadStrategy(OlapIncrementalLoadStrategy.FULL_RELOAD);
        if (this.countersFactsTable != null) {
            this.countersFactsTable.setIncrementalLoadStrategy(OlapIncrementalLoadStrategy.FULL_RELOAD);
        }
        schema.addDataSource((IOlapBuilderDataSource)ds);
        if (!beans.isEmpty()) {
            OlapBuilderHierarchyLevel counterLeafLevel = new OlapBuilderHierarchyLevel("Counter L", null, countersTable.getSelectedColumn(2), countersTable.getSelectedColumn(0), new IOlapBuilderPropertyDef[0]);
            OlapBuilderHierarchyLevel counterGroupLevel = new OlapBuilderHierarchyLevel("Counter Group L", null, countersTable.getSelectedColumn(1));
            counterLeafLevel.addProperty((IOlapBuilderPropertyDef)new OlapBuilderProperty("Synopsis", countersTable.getSelectedColumn(3)));
            countersDimension = this.createMultiLevelDimension((OlapBuilderBaseDataTable)countersTable, "Counter", OlapBuilderAllLevelParsedDefinition.UNDEFINED, counterGroupLevel, counterLeafLevel);
            schema.addDimension((IOlapBuilderDimensionDef)countersDimension);
        } else {
            countersDimension = null;
        }
        OlapBuilderHierarchyLevel yearDay = new OlapBuilderHierarchyLevel("Year L", null, (IOlapBuilderDataColumnDef)yearDayCol);
        yearDay.setDoNotValidateEmptyLevel(true);
        OlapBuilderHierarchyLevel monthDay = new OlapBuilderHierarchyLevel("Month L", null, (IOlapBuilderDataColumnDef)monthDayCol, (IOlapBuilderDataColumnDef)monthKey, new IOlapBuilderPropertyDef[0]);
        monthDay.setOrderMembersByType(OlapMemberOrderByType.BY_KEY);
        monthDay.setDoNotValidateEmptyLevel(true);
        OlapBuilderHierarchyLevel timeDay = new OlapBuilderHierarchyLevel("Day L", null, (IOlapBuilderDataColumnDef)dateDayCol);
        timeDay.setDoNotValidateEmptyLevel(true);
        OlapBuilderHierarchyLevel timeHour = new OlapBuilderHierarchyLevel("Hour L", null, (IOlapBuilderDataColumnDef)dateHourCol);
        timeHour.setDoNotValidateEmptyLevel(true);
        OlapBuilderHierarchyLevel time15M = new OlapBuilderHierarchyLevel("15Min L", null, (IOlapBuilderDataColumnDef)date15MinCol);
        time15M.setDoNotValidateEmptyLevel(true);
        OlapBuilderHierarchyLevel timeDateTime = new OlapBuilderHierarchyLevel("DateTime L", null, (IOlapBuilderDataColumnDef)dateTimeCol, (IOlapBuilderDataColumnDef)dateTimeKeyCol, new IOlapBuilderPropertyDef[0]);
        timeDateTime.setDoNotValidateEmptyLevel(true);
        OlapBuilderMultiLevelDimension timeDimension = this.createMultiLevelDimension((OlapBuilderBaseDataTable)this.timeTable, "Time", OlapBuilderAllLevelParsedDefinition.create((String)"All L", (String)"ALL"), yearDay, monthDay, timeDay, timeHour, time15M, timeDateTime);
        OlapBuilderHierarchyLevel weekDayLevel = new OlapBuilderHierarchyLevel("DateTime L", null, (IOlapBuilderDataColumnDef)dayofWeek, (IOlapBuilderDataColumnDef)dayofWeekKey, new IOlapBuilderPropertyDef[0]);
        weekDayLevel.setDoNotValidateEmptyLevel(true);
        weekDayLevel.setOrderMembersByType(OlapMemberOrderByType.BY_KEY);
        OlapBuilderMultiLevelHierarchy weekDayHierarchy = new OlapBuilderMultiLevelHierarchy("Day of Week", false, OlapBuilderAllLevelParsedDefinition.create((String)"All L", (String)"All Week Days"), new IOlapBuilderHierarchyLevelDef[]{weekDayLevel});
        timeDimension.addHierarchy((IOlapBuilderHierarchyDef)weekDayHierarchy);
        OlapBuilderHierarchyLevel hourLevel = new OlapBuilderHierarchyLevel("DateTime L", null, (IOlapBuilderDataColumnDef)hourofWeek, (IOlapBuilderDataColumnDef)hourofWeekKey, new IOlapBuilderPropertyDef[0]);
        hourLevel.setDoNotValidateEmptyLevel(true);
        hourLevel.setOrderMembersByType(OlapMemberOrderByType.BY_KEY);
        OlapBuilderMultiLevelHierarchy hourODayHierarchy = new OlapBuilderMultiLevelHierarchy("Hour of Day", false, OlapBuilderAllLevelParsedDefinition.create((String)"All L", (String)"All Hours"), new IOlapBuilderHierarchyLevelDef[]{hourLevel});
        timeDimension.addHierarchy((IOlapBuilderHierarchyDef)hourODayHierarchy);
        schema.addDimension((IOlapBuilderDimensionDef)timeDimension);
        OlapBuilderHierarchyLevel timeHour2 = new OlapBuilderHierarchyLevel("Hour Level", null, (IOlapBuilderDataColumnDef)dateHourCol);
        timeHour2.setDoNotValidateEmptyLevel(true);
        OlapBuilderMultiLevelDimension timeHourDimension = this.createMultiLevelDimension((OlapBuilderBaseDataTable)this.timeTable, "Hour", OlapBuilderAllLevelParsedDefinition.create((String)"All L", (String)"ALL"), timeHour2);
        schema.addDimension((IOlapBuilderDimensionDef)timeHourDimension);
        if (!beans.isEmpty()) {
            schema.addDimension((IOlapBuilderDimensionDef)new OlapBuilderStatisticalDimension("Stats", "default", new String[]{"Stats"}));
        }
        Object userDimension = null;
        Object reportDimension = null;
        ArrayList<OlapBuilderMeasure> countersMeasures = new ArrayList<OlapBuilderMeasure>();
        if (!beans.isEmpty()) {
            countersMeasures.add(new OlapBuilderMeasure("Min", OlapAggregationType.MIN, (IOlapBuilderDataColumnDef)counters_minCol));
            countersMeasures.add(new OlapBuilderMeasure("Max", OlapAggregationType.MAX, (IOlapBuilderDataColumnDef)counters_maxCol));
            countersMeasures.add(new OlapBuilderMeasure("Avg", OlapAggregationType.AVG_LEAVES, (IOlapBuilderDataColumnDef)counters_avgCol));
            countersMeasures.add(new OlapBuilderMeasure("Count", OlapAggregationType.SUM, (IOlapBuilderDataColumnDef)counters_countCol));
        }
        if (!beans.isEmpty()) {
            countersFacts = new OlapBuilderFacts("default", (IOlapBuilderTabularDataDef)this.countersFactsTable, countersMeasures, false);
            countersFacts.addLink((IOlapBuilderDimensionDef)countersDimension, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks(countersTable.getSelectedColumn(0), (IOlapBuilderDataColumnDef)counters_beanIdxCol));
            countersFacts.addLink((IOlapBuilderDimensionDef)timeDimension, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks((IOlapBuilderDataColumnDef)dateTimeKeyCol, (IOlapBuilderDataColumnDef)counters_dateTimeKeyCol));
            countersFacts.addLink((IOlapBuilderDimensionDef)timeHourDimension, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks((IOlapBuilderDataColumnDef)dateHourCol, (IOlapBuilderDataColumnDef)counters_dateHourCol));
        } else {
            countersFacts = null;
        }
        Object auditFacts = null;
        ArrayList<OlapBuilderFacts> facts = new ArrayList<OlapBuilderFacts>();
        if (countersFacts != null) {
            facts.add(countersFacts);
        }
        if (auditFacts != null) {
            facts.add((OlapBuilderFacts)auditFacts);
        }
        schema.addCube((IOlapBuilderCubeDef)new OlapBuilderCube(this.cubeName, "icCube system monitoring", facts, new ArrayList()));
        StringBuilder builder = new StringBuilder();
        if (!beans.isEmpty()) {
            this.createScript(builder, beans, auditActivated);
        }
        if (auditActivated) {
            builder.append("\n\ncreate MEMBER [Measures].[Unique Reports Count] as Count(NonEmpty( [Report].[Report Path Name].[Report Path Name L], [Measures].[Open Report Count] ))\ncreate MEMBER [Measures].[Unique Report Users Count] as Count(NonEmpty( [User].[User].[User L], [Measures].[Open Report Count] ))");
        }
        if (builder.length() > 0) {
            schema.setScript(builder.toString());
        }
        return schema;
    }

    private StringBuilder createScript(StringBuilder builder, List<IcBigBrotherCounter> beans, boolean auditActivated) {
        builder.append("\n  CREATE FUNCTION percentV(a_,b_) AS IIF( b_ is NULL or b_ = 0.0, null, a_/b_)\n  CREATE FUNCTION percent(a_,b_) AS percent( a_.value, b_.value)\n  CREATE FUNCTION percentDiffV(a_,b_) AS IIF( b_ is NULL or b_ = 0.0, null, 1.0 - (a_/b_) )\n  CREATE FUNCTION percentDiff(a_,b_) AS percentDiffV( a_.value, b_.value)\n\n");
        for (IcBigBrotherCounter bean : beans) {
            String name = bean.getBeanName();
            String measure = bean.getValueType() == IcBigBrotherCounter.Type.INCREMENTAL ? "[Measures].defaultmember,[Stats].[Stats].[Diff]" : "[Measures].[Avg]";
            builder.append("create MEMBER [Measures].[").append(name).append("] AS (").append(measure).append(",[Counter].[Counter].[").append(name).append("]), ").append(bean.getMDXFormat()).append("\n");
        }
        builder.append("\ncreate MEMBER [Stats].[Stats].[Avg] AS ([Stats].[Stats].default,[Measures].[Avg])\ncreate MEMBER [Stats].[Stats].[Min] AS ([Stats].[Stats].default,[Measures].[Min])\ncreate MEMBER [Stats].[Stats].[Max] AS ([Stats].[Stats].default,[Measures].[Max])\ncreate MEMBER [Stats].[Stats].[Sum] AS ([Stats].[Stats].default,[Measures].[Avg])*([Stats].[Stats].default,[Measures].[Count])\ncreate MEMBER [Stats].[Stats].[Diff] AS ([Stats].[Stats].default,[Measures].[Max])-([Stats].[Stats].default,[Measures].[Min])\ncreate MEMBER [Stats].[Stats].[Diff %] AS percentDiff( ([Stats].[Stats].default,[Measures].[Max]),([Stats].[Stats].default,[Measures].[Min]) )\n");
        return builder;
    }

    private OlapBuilderMultiLevelDimension createMultiLevelDimension(OlapBuilderBaseDataTable table, String name, OlapBuilderAllLevelParsedDefinition allLevel, OlapBuilderHierarchyLevel ... level) {
        OlapBuilderMultiLevelHierarchy hier = new OlapBuilderMultiLevelHierarchy(name, true, allLevel, (IOlapBuilderHierarchyLevelDef[])level);
        OlapBuilderMultiLevelDimension dimension = new OlapBuilderMultiLevelDimension();
        dimension.setDataView((IOlapBuilderTabularDataDef)table);
        dimension.setName(name);
        dimension.addHierarchy((IOlapBuilderHierarchyDef)hier);
        return dimension;
    }

    @Nullable
    private String generateXmlDefinition(OlapBuilderSchema olapSchema) {
        try {
            OlapBuilderSchemaDefFactory factory = new OlapBuilderSchemaDefFactory(olapSchema);
            OlapBuilderMetaInformationRepository repository = new OlapBuilderMetaInformationRepository();
            Class[] persistentClasses = repository.getPersistentClasses();
            StringWriter writer = new StringWriter();
            CdXmlUtils.marshall((Writer)writer, (Object)factory, (Class[])persistentClasses);
            writer.flush();
            return writer.toString();
        }
        catch (Exception ex) {
            OlapLoggers.BIG_BROTHER.warn((Object)"[monitoring] could not generate the schema XML definition of the cube reporter", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimerTick() {
        ArrayList counterTableData;
        if (!this.init) {
            return;
        }
        Object object = this.dataLOCK;
        synchronized (object) {
            counterTableData = this.counterTableData != null ? this.counterTableData : new ArrayList();
            this.counterTableData = null;
        }
        this.timeTable.resetData();
        if (this.countersFactsTable != null) {
            this.countersFactsTable.resetData();
        }
        ArrayList<Comparable[]> mergedTimeTableData = new ArrayList<Comparable[]>();
        if (this.countersFactsTable != null) {
            for (Comparable[] data : counterTableData) {
                Comparable[] timeValues = data.createTimeValues();
                Comparable[] counterValues = data.createCounterValues(timeValues);
                mergedTimeTableData.add(timeValues);
                this.countersFactsTable.addRow(counterValues);
            }
        }
        Collections.sort(mergedTimeTableData, new Comparator<Comparable[]>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(Comparable[] o1, Comparable[] o2) {
                Comparable left = o1[7];
                Comparable right = o2[7];
                return left.compareTo(right);
            }
        });
        for (Comparable[] data : mergedTimeTableData) {
            this.timeTable.addRow(data);
        }
        GwtLoadBigBrotherSchemaQuery query = new GwtLoadBigBrotherSchemaQuery((IOlapBuilderSchemaDefFactory)this.factory);
        long start = System.currentTimeMillis();
        GwtSchemaLifeCycleReply reply = (GwtSchemaLifeCycleReply)this.engine.submitAndWaitGwtRequestEx((GwtQuery)query, this.engineUserSessionContext);
        GwtSchemaLoadStatus status = reply.getStatus();
        if (status == GwtSchemaLoadStatus.LOADED || status == GwtSchemaLoadStatus.INCREMENTAL_LOADED) {
            if (OlapLoggers.BIG_BROTHER.isDebugEnabled()) {
                OlapLoggers.BIG_BROTHER.debug((Object)("[monitoring] monitoring schema (" + this.schemaName + ") refreshed: " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s."));
            }
        } else {
            OlapLoggers.BIG_BROTHER.error((Object)("[monitoring] monitoring schema (" + this.schemaName + ") cannot be loaded (see previously reported error)"));
        }
        this.timeTable.resetData();
        if (this.countersFactsTable != null) {
            this.countersFactsTable.resetData();
        }
    }
}

