/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.legal;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdMutableInt;
import crazydev.common.utils.CdMutableRef;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditRollingFileAppender;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.log4jx.Layout;
import org.apache.log4jx.spi.LoggingEvent;
import org.jetbrains.annotations.Nullable;

public class IcBigBrotherLegalAuditWriter {
    private final IcBigBrotherLegalAuditRollingFileAppender appender;

    public IcBigBrotherLegalAuditWriter(CdVFileSystem vfs, @Nullable OlapNotificationService notificationService, String auditDirectory, String rawFileName, final String header, String maxFileSize) throws IOException {
        int fileNumber = IcBigBrotherLegalAuditWriter.extractFileNumber(vfs, new File(auditDirectory), rawFileName);
        File file = new File(auditDirectory, rawFileName + "." + fileNumber);
        this.appender = new IcBigBrotherLegalAuditRollingFileAppender(notificationService, auditDirectory, rawFileName, fileNumber);
        Layout layout = new Layout(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public String getHeader() {
                return header;
            }

            @Override
            public String format(LoggingEvent event) {
                return String.valueOf(event.getMessage());
            }

            @Override
            public boolean ignoresThrowable() {
                return true;
            }

            @Override
            public void activateOptions() {
            }
        };
        if (CdStringUtils.isNullOrBlank((String)maxFileSize)) {
            maxFileSize = "2MB";
        }
        this.appender.setMaxFileSize(maxFileSize);
        this.appender.setEncoding("UTF-8");
        this.appender.setLayout(layout);
        this.appender.setImmediateFlush(true);
        this.appender.setBufferSize(8192);
        this.appender.setBufferedIO(false);
        this.appender.setFile(file.getAbsolutePath());
        this.appender.activateOptions();
    }

    private static int extractFileNumber(CdVFileSystem vfs, File auditDirectory, String rawFileName) throws IOException {
        CdMutableRef error = new CdMutableRef();
        CdMutableInt fileNumber = new CdMutableInt(0);
        vfs.forEachFile(auditDirectory, path -> path.toFile().getName().startsWith(rawFileName), vPath -> {
            try {
                String fileName = vPath.path.toFile().getName();
                int pos = fileName.lastIndexOf(46);
                if (pos == -1) {
                    OlapLoggers.BIG_BROTHER.error((Object)("[legal] legal-audit : could not extract the file number : " + fileName));
                    error.value = "could not extract the file number : " + fileName;
                    return;
                }
                int number = Integer.parseInt(fileName.substring(pos + 1));
                if (number > fileNumber.value) {
                    fileNumber.value = number;
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.BIG_BROTHER.error((Object)("[legal] legal-audit : could not extract the file number : " + rawFileName), (Throwable)ex);
                error.value = "could not extract the file number : " + rawFileName;
            }
        });
        if (error.value != null) {
            throw new IOException((String)error.value);
        }
        return fileNumber.value;
    }

    public String getAbsolutePath() {
        return this.appender.getFile();
    }

    public void write(String value) {
        this.appender.doAppend(new LoggingEvent(value));
    }

    public void close() throws IOException {
        this.appender.close();
    }
}

