/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.legal;

import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4jx.FileAppender;
import org.apache.log4jx.helpers.CountingQuietWriter;
import org.apache.log4jx.helpers.OptionConverter;
import org.apache.log4jx.spi.LoggingEvent;
import org.jetbrains.annotations.Nullable;

public class IcBigBrotherLegalAuditRollingFileAppender
extends FileAppender {
    @Nullable
    private final OlapNotificationService notificationService;
    private final String auditDirectory;
    private final String rawFileName;
    private long maxFileSize = 0xA00000L;
    private boolean rollOverActive;
    private int fileSuffix;

    public IcBigBrotherLegalAuditRollingFileAppender(@Nullable OlapNotificationService notificationService, String auditDirectory, String rawFileName, int fileSuffix) {
        super("legal-audit");
        this.notificationService = notificationService;
        this.auditDirectory = auditDirectory;
        this.rawFileName = rawFileName;
        this.rollOverActive = true;
        this.fileSuffix = fileSuffix;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize(value, this.maxFileSize + 1L);
    }

    @Override
    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    @Override
    protected void writeHeader() {
        File file;
        String header;
        if (!(this.layout == null || (header = this.layout.getHeader()) == null || this.qw == null || (file = new File(this.fileName)).exists() && file.length() != 0L)) {
            this.qw.write(header);
            if (this.immediateFlush) {
                this.qw.flush();
            }
        }
    }

    @Override
    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.rollOverActive && this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize) {
            this.rollOver();
        }
    }

    protected void rollOver() {
        block2: {
            ++this.fileSuffix;
            String fileNameFrom = this.rawFileName;
            String fileNameTO = this.rawFileName + "." + this.fileSuffix;
            try {
                OlapLoggers.BIG_BROTHER.info((Object)("[legal] audit rolling over to from [" + fileNameFrom + "] to [" + fileNameTO + "]"));
                File fileTO = new File(this.auditDirectory, fileNameTO);
                this.setFile(fileTO.getAbsolutePath(), false, this.bufferedIO, this.bufferSize);
            }
            catch (IOException ex) {
                OlapLoggers.BIG_BROTHER.error((Object)("[legal] audit error while rolling over to from [" + fileNameFrom + "] to [" + fileNameTO + "]"), (Throwable)ex);
                this.rollOverActive = false;
                if (this.notificationService == null) break block2;
                this.notificationService.onInternalError("[legal] audit error while rolling over to from [" + fileNameFrom + "] to [" + fileNameTO + "]");
            }
        }
    }
}

