/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.legal;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditData;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

public class IcBigBrotherLegalAuditOpenReportData
extends IcBigBrotherAuditData {
    private final String reportPath;

    public static String HEADER(boolean withMultiTenant) {
        String tenant = "";
        if (withMultiTenant) {
            tenant = ",TENANT_NAME";
        }
        return "TIMESTAMP" + tenant + ",USER_NAME,REPORT_PATH\n";
    }

    public IcBigBrotherLegalAuditOpenReportData(LocalDateTime time, @Nullable String tenant, String user, String reportPath, String reportName) {
        super(-1L, time, tenant, user);
        Object fullName = "";
        if (CdStringUtils.isNullOrBlank((String)reportPath)) {
            fullName = reportName;
        } else {
            fullName = reportPath.startsWith("/") ? reportPath.substring(1) : reportPath;
            fullName = (String)fullName + "/" + reportName;
        }
        this.reportPath = fullName;
    }

    @Override
    public String format(boolean withMultiTenant) {
        StringBuilder sb = new StringBuilder();
        LocalDateTime timestamp = this.getTimestamp();
        sb.append(ISODateTimeFormat.dateTime().print((ReadablePartial)timestamp));
        sb.append(",");
        if (withMultiTenant) {
            sb.append(this.tenant != null ? this.tenant : "");
            sb.append(",");
        }
        sb.append(this.user);
        sb.append(",");
        sb.append(CdMdxUtils.escapeForCSV((String)this.reportPath));
        sb.append("\n");
        return sb.toString();
    }
}

