/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.IcBigBrotherCounterFactory;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import java.util.List;
import org.joda.time.LocalDateTime;

class icBigBrotherCollector {
    private final IcBigBrotherReporter[] reporters;
    private final List<IcBigBrotherCounter> beans;
    private final double[] measureWindow;
    private final long reportingMs;
    private final int maxBeansPerReporting;
    private int currentWindowIndex;
    private int reportWindowsIdx = -1;

    public icBigBrotherCollector(IcBigBrotherMgrConfiguration settings, IcBigBrotherReporter[] reporters) {
        this.reporters = reporters;
        this.beans = IcBigBrotherCounterFactory.getFiltered(settings.counterFilter);
        this.reportingMs = settings.reportingWindowSec * 1000L;
        this.maxBeansPerReporting = settings.getMaxBeansPerReporting();
        this.measureWindow = new double[this.maxBeansPerReporting * this.beans.size()];
    }

    public void onTimerTick() {
        long currentMillis = System.currentTimeMillis();
        int currentReportingWindow = (int)(currentMillis / this.reportingMs);
        if (this.reportWindowsIdx != -1 && this.reportWindowsIdx != currentReportingWindow || this.currentWindowIndex >= this.maxBeansPerReporting) {
            this.flushToCube((long)this.reportWindowsIdx * this.reportingMs);
            this.currentWindowIndex = 0;
        }
        this.reportWindowsIdx = currentReportingWindow;
        int initPos = this.currentWindowIndex * this.beans.size();
        for (int i = 0; i < this.beans.size(); ++i) {
            double measure;
            IcBigBrotherCounter bean = this.beans.get(i);
            this.measureWindow[initPos + i] = measure = bean.collect();
            if (!OlapLoggers.BIG_BROTHER.isTraceEnabled()) continue;
            OlapLoggers.BIG_BROTHER.trace((Object)("[monitoring] " + bean.getBeanName() + " bean  value : [" + measure + "]"));
        }
        ++this.currentWindowIndex;
    }

    private void flushToCube(long reportingMs) {
        LocalDateTime reportStart = new LocalDateTime(reportingMs);
        for (IcBigBrotherReporter reporter : this.reporters) {
            reporter.onCounterAddStarted();
        }
        int beanSize = this.beans.size();
        for (int beanIdx = 0; beanIdx < beanSize; ++beanIdx) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            double sum = 0.0;
            long count = 0L;
            for (int i = 0; i < this.currentWindowIndex; ++i) {
                double meas = this.measureWindow[i * beanSize + beanIdx];
                if (meas == Double.MAX_VALUE) continue;
                ++count;
                min = Math.min(min, meas);
                max = Math.max(max, meas);
                sum += meas;
            }
            if (count <= 0L) continue;
            for (IcBigBrotherReporter reporter : this.reporters) {
                reporter.addCounter(beanIdx, reportStart, min, max, sum / (double)count, count);
            }
        }
        for (IcBigBrotherReporter reporter : this.reporters) {
            reporter.onCounterAddCompleted();
        }
    }

    public boolean hasBeans() {
        return !this.beans.isEmpty();
    }

    public List<IcBigBrotherCounter> getBeans() {
        return this.beans;
    }
}

