/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.counters.session;

import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import org.jetbrains.annotations.Nullable;

public class IcBigBrotherHttpSessionCountCounter
implements IcBigBrotherCounter {
    private final String name;
    @Nullable
    private final IcCubeHttpComponent httpComponent;

    public IcBigBrotherHttpSessionCountCounter(@Nullable IcCubeHttpComponent httpComponent) {
        this.name = "HTTP Session Count";
        this.httpComponent = httpComponent;
    }

    @Override
    public String getGroupName() {
        return "Session";
    }

    @Override
    public String prettyFormat(double value) {
        return String.format("%d", Math.round(value));
    }

    @Override
    public String getMDXFormat() {
        return "FORMAT_STRING='#,###'";
    }

    @Override
    public IcBigBrotherCounter.Type getValueType() {
        return IcBigBrotherCounter.Type.SUM;
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Returns the number of open HTTP sessions.";
    }

    @Override
    public double collect() {
        if (this.httpComponent != null) {
            return this.httpComponent.getHttpSessionCount();
        }
        return 0.0;
    }
}

