/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.counters.memory;

import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherBaseMemoryCounter;
import java.lang.management.GarbageCollectorMXBean;

public class IcBigBrotherGarbageCollectorCountMxCounter
extends IcBigBrotherBaseMemoryCounter {
    private final GarbageCollectorMXBean gcBean;
    private final String name;

    public IcBigBrotherGarbageCollectorCountMxCounter(GarbageCollectorMXBean garbageCollectorMXBean) {
        this.gcBean = garbageCollectorMXBean;
        this.name = "GC Count - " + garbageCollectorMXBean.getName();
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Returns the total number of collections that have occurred for this memory manager";
    }

    @Override
    public IcBigBrotherCounter.Type getValueType() {
        return IcBigBrotherCounter.Type.INCREMENTAL;
    }

    @Override
    public double collect() {
        return this.gcBean.getCollectionCount();
    }

    @Override
    public String getMDXFormat() {
        return "FORMAT_STRING='#,###'";
    }

    @Override
    public String prettyFormat(double value) {
        return String.format("%d", Math.round(value));
    }
}

