/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.audit;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.gwt.server.reporting.audit.IOlapDocsAuditListener;
import crazydev.iccube.olap.component.mdx.IOlapMdxAuditListener;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class IcBigBrotherAuditReportingCollector
implements IOlapDocsAuditListener,
IOlapMdxAuditListener {
    private static final long DEFAULT_EXECUTED_MDX_THRESHOLD_MS = 10000L;
    private final List<AuditEvent> events = new ArrayList<AuditEvent>();
    private final boolean auditOpenedReport;
    private final boolean auditExecutedMdx;
    private final long executedMdxThresholdMS;

    private IcBigBrotherAuditReportingCollector(boolean auditOpenedReport, boolean auditExecutedMdx, long executedMdxThresholdMS) {
        this.auditOpenedReport = auditOpenedReport;
        this.auditExecutedMdx = auditExecutedMdx;
        this.executedMdxThresholdMS = executedMdxThresholdMS;
        OlapLoggers.BIG_BROTHER.info((Object)("[monitoring] audit [opened-report:" + auditOpenedReport + "] [executed-mdx:" + auditExecutedMdx + "] [threshold (ms):" + executedMdxThresholdMS + "]"));
    }

    @Nullable
    public static IcBigBrotherAuditReportingCollector create(IcBigBrotherMgrConfiguration configuration) {
        String auditFilter = configuration.getAuditFilter();
        if (auditFilter == null) {
            return null;
        }
        if (CdStringUtils.isNullOrBlank((String)(auditFilter = auditFilter.trim()))) {
            return null;
        }
        if (auditFilter.equals("*")) {
            return new IcBigBrotherAuditReportingCollector(true, true, 10000L);
        }
        auditFilter = auditFilter.toLowerCase();
        boolean auditOpenedReport = false;
        boolean auditExecutedMdx = false;
        long auditExecutedMdxThresholdMS = 10000L;
        String[] parts = auditFilter.split(",");
        if (parts != null) {
            for (String part : parts) {
                if ((part = part.trim()).equals("report")) {
                    auditOpenedReport = true;
                    continue;
                }
                if (!part.startsWith("mdx")) continue;
                auditExecutedMdx = true;
                String[] parts_ = part.split(":");
                if (parts_ == null || parts_.length <= 1) continue;
                auditExecutedMdxThresholdMS = Long.parseLong(parts_[1]) * 1000L;
            }
        }
        if (auditOpenedReport || auditExecutedMdx) {
            return new IcBigBrotherAuditReportingCollector(auditOpenedReport, auditExecutedMdx, auditExecutedMdxThresholdMS);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReportOpen(@Nullable String tenant, String user, String path, String report) {
        if (!this.auditOpenedReport) {
            return;
        }
        LocalDateTime time = LocalDateTime.now();
        ReportEvent event = new ReportEvent(time, tenant, user, path, report);
        List<AuditEvent> list = this.events;
        synchronized (list) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMdxExecuted(boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, long startTimeMS, long elapsedMS) {
        if (!this.auditExecutedMdx) {
            return;
        }
        LocalDateTime time = new LocalDateTime(startTimeMS);
        MdxEvent event = new MdxEvent(time, fromCache, reportPath, tenant, user, schemaName, cubeName, statement, elapsedMS);
        List<AuditEvent> list = this.events;
        synchronized (list) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(IcBigBrotherReporter[] reporters) {
        List<AuditEvent> list = this.events;
        synchronized (list) {
            if (this.events.isEmpty()) {
                return;
            }
            for (IcBigBrotherReporter reporter : reporters) {
                reporter.onAuditAddStarted();
                for (AuditEvent event : this.events) {
                    if (event instanceof MdxEvent && !reporter.isLegalAudit()) {
                        MdxEvent mdxEvent = (MdxEvent)event;
                        if (mdxEvent.fromCache && this.executedMdxThresholdMS != -1000L || mdxEvent.elapsedMS < this.executedMdxThresholdMS) continue;
                    }
                    event.report(reporter);
                }
                reporter.onAuditAddCompleted();
            }
            this.events.clear();
        }
    }

    static class ReportEvent
    extends AuditEvent {
        final LocalDateTime time;
        final String path;
        final String report;

        ReportEvent(LocalDateTime time, @Nullable String tenant, String user, String path, String report) {
            super(tenant, user);
            this.time = time;
            this.path = path;
            this.report = report;
        }

        @Override
        void report(IcBigBrotherReporter reporter) {
            reporter.addAuditOpenReport(this.time, this.tenant, this.user, this.path, this.report);
        }
    }

    static class MdxEvent
    extends AuditEvent {
        final LocalDateTime time;
        final boolean fromCache;
        @Nullable
        final String reportPath;
        final String schemaName;
        @Nullable
        final String cubeName;
        final String statement;
        final long elapsedMS;

        MdxEvent(LocalDateTime time, boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, long elapsedMS) {
            super(tenant, user);
            this.time = time;
            this.fromCache = fromCache;
            this.reportPath = reportPath;
            this.schemaName = schemaName;
            this.cubeName = cubeName;
            this.statement = statement;
            this.elapsedMS = elapsedMS;
        }

        @Override
        void report(IcBigBrotherReporter reporter) {
            reporter.addAuditMdxExecuted(this.time, this.fromCache, this.reportPath, this.tenant, this.user, this.schemaName, this.cubeName, this.statement, this.elapsedMS);
        }
    }

    static abstract class AuditEvent {
        @Nullable
        final String tenant;
        final String user;

        AuditEvent(@Nullable String tenant, String user) {
            this.tenant = tenant;
            this.user = user;
        }

        abstract void report(IcBigBrotherReporter var1);
    }
}

