/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporterConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporterConfigurations;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="monitoringConfiguration")
public class IcBigBrotherMgrConfiguration {
    @XmlElement(name="activated", required=true)
    public boolean activated;
    @XmlElement(name="counterFilter", required=true)
    public String counterFilter;
    @XmlElement(name="auditFilter", required=false)
    public String auditFilter;
    @XmlElement(name="initialMonitorBeansDelaySec", required=true)
    public long initialMonitorBeansDelaySec;
    @XmlElement(name="monitorBeansEachSec", required=true)
    public long monitorBeansEachSec;
    @XmlElement(name="reportingWindowSec", required=true)
    public long reportingWindowSec;
    @XmlElement(name="reporters", required=true)
    private IcBigBrotherReporterConfigurations reporters;
    @XmlTransient
    @Nullable
    private OlapRuntime runtime;

    public IcBigBrotherMgrConfiguration() {
    }

    public IcBigBrotherMgrConfiguration(String counterFilter, long initialMonitorBeansDelaySec, long monitorBeansEachSec, long reportingWindowSec, @Nullable String reporterClassName) {
        this.activated = true;
        this.counterFilter = counterFilter;
        this.initialMonitorBeansDelaySec = initialMonitorBeansDelaySec;
        this.monitorBeansEachSec = monitorBeansEachSec;
        this.reportingWindowSec = reportingWindowSec;
        this.reporters = new IcBigBrotherReporterConfigurations();
        if (reporterClassName != null) {
            if (reporterClassName.contains(",")) {
                throw new RuntimeException("Not Supported !");
            }
            this.reporters.add(new IcBigBrotherReporterConfiguration(reporterClassName));
        }
    }

    public int getMaxBeansPerReporting() {
        return 1 + (int)(this.reportingWindowSec / this.monitorBeansEachSec);
    }

    public String getAuditFilter() {
        return this.auditFilter;
    }

    public void validate(OlapRuntime runtime) throws OlapConfigurationException {
        this.runtime = runtime;
        if (CdStringUtils.isNullOrBlank((String)this.counterFilter)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"counterFilter"});
        }
        if (this.reporters == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"reporters"});
        }
        this.reporters.validate();
        if (this.monitorBeansEachSec <= 0L) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"invalid value for monitorBeansEachSec [" + this.monitorBeansEachSec + "]"});
        }
        if (this.reportingWindowSec <= 0L) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"invalid value for reportingWindowSec [" + this.reportingWindowSec + "]"});
        }
        if (this.monitorBeansEachSec > this.reportingWindowSec) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"reportingWindowSec < monitorBeansEachSec"});
        }
    }

    public boolean hasCubeReporter() {
        return this.reporters != null && this.reporters.hasCubeReporter();
    }

    public IcBigBrotherReporter[] createReporters(boolean withMultiTenant, @Nullable OlapNotificationService notificationService, String auditDirectory) throws OlapConfigurationException {
        if (this.reporters == null) {
            return new IcBigBrotherReporter[0];
        }
        if (this.runtime == null) {
            throw new RuntimeException("internal error: unexpected missing runtime information");
        }
        return this.reporters.createReporters(this.runtime, withMultiTenant, notificationService, auditDirectory);
    }
}

