/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.server.bigbrother.IcBigBrotherCounterFactory;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.IcBigBrotherTimer;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IcBigBrotherMgr
implements IOlapBigBrotherMgr {
    private final IcCubeEngine engine;
    private final List<IcBigBrotherMgrConfiguration> configs;
    private final List<IcBigBrotherTimer> executors;

    public IcBigBrotherMgr(IcCubeEngine engine, List<IcBigBrotherMgrConfiguration> configs) {
        this.engine = engine;
        this.configs = configs;
        this.executors = new ArrayList<IcBigBrotherTimer>();
    }

    public void start() throws OlapConfigurationException {
        for (int ii = 0; ii < this.configs.size(); ++ii) {
            IcBigBrotherMgrConfiguration config = this.configs.get(ii);
            if (!config.activated) continue;
            this.executors.add(new IcBigBrotherTimer(this.engine, config, ii));
        }
        for (IcBigBrotherTimer executor : this.executors) {
            if (this.engine != null) {
                executor.start(this.engine.getApplicationContext());
                continue;
            }
            executor.start(null);
        }
    }

    public void shutdownNow() {
        for (IcBigBrotherTimer executor : this.executors) {
            executor.shutdownNow();
        }
    }

    @Nullable
    public Double getMonitoringCounterValue(String beanName) {
        List<IcBigBrotherCounter> beans = IcBigBrotherCounterFactory.getFiltered(beanName);
        if (beans.isEmpty()) {
            return null;
        }
        IcBigBrotherCounter bean = beans.get(0);
        double value = bean.collect();
        if (value == Double.MAX_VALUE) {
            return null;
        }
        return value;
    }

    protected List<IcBigBrotherReporter> getReporters() {
        ArrayList<IcBigBrotherReporter> list = new ArrayList<IcBigBrotherReporter>();
        for (IcBigBrotherTimer executor : this.executors) {
            list.addAll(Arrays.asList(executor.getReporters()));
        }
        return list;
    }
}

