/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication.restapi;

import crazydev.common.credentials.CdCredentials;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclipse.jetty.util.B64Code;
import org.jetbrains.annotations.Nullable;

public class IcCubeRestApiXAuthorizationAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    public static final String HEADER_AUTHORIZATION = "X-AUTHORIZATION";

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal == null) {
            CdCredentials credentials = this.getCredentials(request);
            if (credentials != null) {
                this.performLogin(request, response, filterChain, credentials);
                return;
            }
            if (this.anonymousLogon) {
                this.performAnonymousLogin(request, response, filterChain);
                return;
            }
        }
        this.requestLogin(request, (HttpServletResponse)servletResponse);
    }

    @Nullable
    private CdCredentials getCredentials(HttpServletRequest request) {
        String credentials = request.getHeader(HEADER_AUTHORIZATION);
        if (CdStringUtils.isNullOrBlank((String)credentials)) {
            return null;
        }
        credentials = B64Code.decode(credentials, "iso-8859-1");
        int semiColonPos = credentials.indexOf(58);
        String userInformation = credentials.substring(0, semiColonPos);
        String password = credentials.substring(semiColonPos + 1);
        return IcCubeRestApiXAuthorizationAuthenticationServletFilter.extractCredentials(userInformation, password);
    }

    private void performLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, CdCredentials credentials) throws IOException, ServletException {
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("Rest API X-AUTHORIZATION", IOlapProtocol.NA, request, credentials.userName, credentials.userPassword, credentials.userRole);
            if (authenticatedPrincipal != null) {
                HttpSession session = request.getSession();
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.requestLogin(request, response);
            }
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.requestLogin(request, response);
        }
    }

    private void performAnonymousLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpSession session = request.getSession();
            OlapPrincipal principal = this.createAuthenticatedAnonymousPrincipal("Rest API X-AUTHORIZATION");
            session.setAttribute("icCube.principal", (Object)principal);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"anonymous authentication failed", (Throwable)ex);
            this.requestLogin(request, response);
        }
    }

    private void requestLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(401);
    }
}

