/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication.passthrough;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IcCubePassthroughGwtAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            return;
        }
        this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal == null) {
            throw new ServletException("icCube authentication [" + this.getAuthenticationServiceName() + "] error : (GWT) missing authenticated principal");
        }
        if (request.getParameter("j_security_check_user") != null) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
            String userRoleInformation = IcCubePassthroughGwtAuthenticationServletFilter.createUserRoleInformation(principal);
            String logoutDisabled = "";
            ((Writer)writer).append("user=").append(userRoleInformation).append("").close();
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] (GWT) user: " + userRoleInformation));
            }
            return;
        }
        if (request.getParameter("j_security_check_logout") != null) {
            this.performLogout(request, response);
            return;
        }
        if (request.getParameter("j_security_check") != null) {
            throw new ServletException("icCube authentication [" + this.getAuthenticationServiceName() + "] error : (GWT) unexpected security check");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void performLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        if (session != null) {
            OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
            if (principal != null) {
                if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                    OlapLoggers.SESSIONS.info((Object)("icCube GWT (token) session [" + session.getId() + "] logout for user [" + principal.getName() + "]"));
                }
            } else if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                OlapLoggers.SESSIONS.info((Object)("icCube GWT (token) session [" + session.getId() + "] logout for user [unknown]"));
            }
            session.invalidate();
        }
        this.onGwtLogout(request, response);
    }
}

