/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.PatternSyntaxException;

public class IcCubeWindowsSSOAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private boolean ignoreDomainInPrincipal;
    private String domainPrincipalSplitter;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        String ignoreDomainNameParam = configuration.getInitParameter("ignoreDomainInPrincipal");
        this.ignoreDomainInPrincipal = Boolean.parseBoolean(ignoreDomainNameParam);
        this.domainPrincipalSplitter = configuration.getInitParameter("domainPrincipalSplitter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        OlapPrincipal icCubePrincipal;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new ServletException("internal error : missing HTTP session!");
        }
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)"authentication : SSO icCube adaptation");
        }
        if ((icCubePrincipal = (OlapPrincipal)session.getAttribute("icCube.principal")) != null) {
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("authentication : SSO icCube adaptation - previous principal : " + icCubePrincipal.getName()));
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String windowsUserName = this.getWindowsUserName(request);
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)("authentication : SSO icCube adaptation - windows user name : " + windowsUserName));
        }
        if (this.ignoreDomainInPrincipal) {
            try {
                String[] keys = windowsUserName.split(this.domainPrincipalSplitter);
                if (keys.length != 2) {
                    if (OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
                        OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "] - unable to find Windows domain [" + this.domainPrincipalSplitter + "]"));
                    }
                    this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName + " (user domain error)");
                    return;
                }
                windowsUserName = keys[1];
            }
            catch (PatternSyntaxException ex) {
                OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "] - Windows domain pattern error [" + this.domainPrincipalSplitter + "]"), (Throwable)ex);
                this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName + " (user name error)");
                return;
            }
        }
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("Windows SSO", IOlapProtocol.NA, request, windowsUserName, null, null);
            if (authenticatedPrincipal != null) {
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                    OlapLoggers.AUTHENTICATION.debug((Object)("authentication : SSO icCube adaptation - authenticated principal : " + windowsUserName));
                }
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                if (OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
                    OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "]"));
                }
                this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName + " (user unknown)");
            }
        }
        catch (OlapMissingRoleException ex) {
            OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "]"), (Throwable)ex);
            this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName + " (role)");
        }
        catch (OlapMaxUserExceededException ex) {
            OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "]"), (Throwable)ex);
            this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName + " (resource exceeded)");
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.info((Object)("authentication failed [" + windowsUserName + "]"), (Throwable)ex);
            this.sendUnauthorized(session, (HttpServletResponse)servletResponse, windowsUserName);
        }
    }

    private String getWindowsUserName(HttpServletRequest request) throws ServletException {
        String remoteUser = request.getRemoteUser();
        if (CdStringUtils.isNullOrBlank((String)remoteUser)) {
            throw new ServletException("internal error : missing HTTP remote user!");
        }
        return remoteUser;
    }

    private void sendUnauthorized(HttpSession session, HttpServletResponse httpResponse, String response) throws IOException {
        if (session != null) {
            session.invalidate();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)httpResponse.getOutputStream());
        ((Writer)writer).append(this.getErrorMessage("icCube authorization error: ") + response).close();
    }

    private String getErrorMessage(String message) {
        return "err:" + message;
    }
}

