/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.filter.IcCubeAbstractServletFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class IcCubeWhiteListFilter
extends IcCubeAbstractServletFilter {
    protected Set<String> whiteIPs;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.whiteIPs = this.initIPs(config);
        if (!this.whiteIPs.isEmpty() && OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] white-list : " + String.valueOf(this.whiteIPs)));
        }
    }

    protected Set<String> initIPs(FilterConfig configuration) {
        HashSet<String> whiteList = new HashSet<String>();
        String param = configuration.getInitParameter("addresses");
        if (CdStringUtils.isNotNullAndNotBlank((String)param)) {
            String[] parts;
            for (String part : parts = param.split(",")) {
                whiteList.add(part.trim());
            }
        }
        return whiteList;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String remoteAddr;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.whiteIPs.isEmpty() && !this.whiteIPs.contains(remoteAddr = request.getRemoteAddr())) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] IP refused [" + remoteAddr + "]"));
            response.sendError(401);
            return;
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

