/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapWebAppConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintPrincipal;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class IcCubePrintingAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private static final String IGNORE = "ignore";
    private static final String LOCALHOST = "localhost";
    private final boolean sessionLess;
    private String assertFromLocalhost = "localhost";

    public IcCubePrintingAuthenticationServletFilter(@Nullable OlapWebAppConfiguration webAppConfiguration) {
        this.sessionLess = webAppConfiguration != null && webAppConfiguration.isSessionLess();
    }

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        String param = configuration.getInitParameter("assertFromLocalhost");
        this.assertFromLocalhost = param == null || CdStringUtils.isNullOrBlank((String)param) || param.equals(LOCALHOST) ? LOCALHOST : (param.equals(IGNORE) ? IGNORE : CdConfigurationUtils.substVars((String)param));
        OlapLoggers.PRINT.info((Object)"[printing] Print Service Servlet Configuration");
        OlapLoggers.PRINT.info((Object)("[printing]           sessionLess : " + this.sessionLess));
        OlapLoggers.PRINT.info((Object)("[printing]   assertFromLocalhost : " + this.assertFromLocalhost));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String jobUUID;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] (filter) received printing request : " + request.getRequestURI()));
        }
        if ((jobUUID = IcCubePrintingAuthenticationServletFilter.extractJobUUID(request)) == null) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing request refused (missing job UUID)");
            response.sendError(403, "Printing authentication error : missing job UUID.");
            return;
        }
        IcCubeServerApplicationContext applicationContext = IcCubeServerApplicationContext.getApplicationContext(request.getServletContext());
        IcCubePrintService printService = applicationContext.getPrintService();
        if (printService == null) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing request refused (print service disabled)");
            response.sendError(403, "Printing authentication error : print service disabled.");
            return;
        }
        IcCubePrintJob job = printService.getExecutingJob(jobUUID);
        if (job == null) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing request refused (unknown job)");
            response.sendError(403, "Printing authentication error : unknown job.");
            return;
        }
        if (job.isInBrowser()) {
            this.doFilterPrintInBrowser(request, response, filterChain, job);
        } else {
            this.doFilterPrint(request, response, filterChain, job);
        }
    }

    private void doFilterPrintInBrowser(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, IcCubePrintJob job) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing-in-browser request refused (user not logged)");
            response.sendError(403, "Printing authentication error : user not logged.");
            return;
        }
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal == null) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing-in-browser request refused (missing user)");
            response.sendError(403, "Printing authentication error : missing user.");
            return;
        }
        OlapPrincipal requestingPrincipal = job.getRequestingPrincipal();
        if (principal != requestingPrincipal) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing-in-browser request refused (inconsistent user)");
            response.sendError(403, "Printing authentication error : inconsistent user.");
            return;
        }
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing-in-browser request accepted");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void doFilterPrint(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, IcCubePrintJob job) throws IOException, ServletException {
        IcCubePrintPrincipal principal_;
        HttpSession session;
        OlapPrincipal principal;
        String remoteAddr = request.getRemoteAddr();
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] (filter) printing request from [" + remoteAddr + "]"));
        }
        if (!IGNORE.equals(this.assertFromLocalhost)) {
            if (LOCALHOST.equals(this.assertFromLocalhost)) {
                if (!(remoteAddr.equals("127.0.0.1") || remoteAddr.equals("::1") || remoteAddr.equals("0:0:0:0:0:0:0:1") || remoteAddr.equals("[::1]") || remoteAddr.equals("[0:0:0:0:0:0:0:1]"))) {
                    if (OlapLoggers.PRINT.isDebugEnabled()) {
                        OlapLoggers.PRINT.debug((Object)("[printing] (filter) printing request refused (not from localhost) [" + remoteAddr + "]"));
                    }
                    response.sendError(403, "Printing authentication error : unauthorized host.");
                    return;
                }
            } else if (!remoteAddr.equals(this.assertFromLocalhost)) {
                if (OlapLoggers.PRINT.isDebugEnabled()) {
                    OlapLoggers.PRINT.debug((Object)("[printing] (filter) printing request refused (not from [" + this.assertFromLocalhost + "]) [" + remoteAddr + "]"));
                }
                response.sendError(403, "Printing authentication error : unauthorized host.");
                return;
            }
        }
        if ((principal = (OlapPrincipal)(session = request.getSession()).getAttribute("icCube.principal")) == null) {
            this.performLogin(request, response, filterChain, session, job);
            return;
        }
        if (principal instanceof IcCubePrintPrincipal && !(principal_ = (IcCubePrintPrincipal)principal).getJobUUID().equals(job.getUuid())) {
            if (OlapLoggers.PRINT.isDebugEnabled()) {
                OlapLoggers.PRINT.debug((Object)("[printing] (filter) printing request refused (principal mismatch [" + principal_.getJobUUID() + "][" + job.getUuid() + "])"));
            }
            response.sendError(403, "Printing authentication error : principal mismatch [" + principal_.getJobUUID() + "][" + job.getUuid() + "].");
            session.invalidate();
            return;
        }
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] (filter) printing request accepted " + principal.logInfo()));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Nullable
    private static String extractJobUUID(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return null;
        }
        String firstNonEmptyPart = null;
        String[] parts = pathInfo.split("/");
        if (parts != null && parts.length > 0) {
            for (int ii = 0; ii < parts.length; ++ii) {
                String part = parts[ii];
                if (part == null || part.isEmpty()) continue;
                firstNonEmptyPart = part;
                break;
            }
        }
        return firstNonEmptyPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, HttpSession session, IcCubePrintJob job) throws IOException, ServletException {
        try {
            String action = request.getParameter("action");
            if (job.isMF()) {
                OlapPrincipal principal = this.createAuthenticatedPrintingPrincipal(job);
                session.setAttribute("icCube.principal", (Object)principal);
                job.attachHttpSession(session);
                if (OlapLoggers.PRINT.isDebugEnabled()) {
                    OlapLoggers.PRINT.debug((Object)("[printing] printing request accepted (authenticated) " + principal.logInfo()));
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (OlapLoggers.PRINT.isDebugEnabled()) {
                OlapLoggers.PRINT.debug((Object)"[printing] (filter) printing request refused (unexpected command/parameters)");
            }
            response.sendError(403, "Printing authentication error : unexpected command/parameters.");
            session.invalidate();
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"Printing authentication failed", (Throwable)ex);
            response.sendError(403, "Printing authentication error : " + ex.getMessage());
            session.invalidate();
        }
        finally {
            if (this.sessionLess) {
                try {
                    OlapLoggers.AUTHENTICATION.debug((Object)("[auth] invalidating the session [" + session.getId() + "]"));
                    session.invalidate();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }
}

