/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.meta.MetaAuthorizationDescription;
import crazydev.iccube.authorization.meta.MetaOnTheFlyRoleDescription;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapUserDefinitions;
import crazydev.iccube.pub.authentication.IcCubeAbstractAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapRoleDefinitionProvider;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapOnTheFlyPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapRegularPrincipal;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.pub.role.OlapOnTheFlyRoleDescriptionException;
import crazydev.iccube.pub.role.OlapSimpleOnTheFlyRoleDescription;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.jetbrains.annotations.Nullable;

public class IcCubeHeaderAuthenticationService
extends IcCubeAbstractAuthenticationService {
    public static final String HTTP_HEADER_TENANT = "ic3-Tenant";
    public static final String HTTP_HEADER_USER = "ic3-User";
    public static final String HTTP_HEADER_LOCALE = "ic3-Locale";
    public static final String HTTP_HEADER_ROLE = "ic3-Role";
    public static final String HTTP_HEADER_MDX_ROLE = "ic3-Mdx-Role";
    public static final String HTTP_HEADER_DOCS_ROLE = "ic3-Docs-Role";
    public static final String HTTP_HEADER_SCHEMAS = "ic3-Schemas";
    public static final String HTTP_HEADER_SCHEMAS_PERMS = "ic3-Schemas-Perms";
    public static final String HTTP_HEADER_DASHBOARDS = "ic3-Dashboards";
    public static final String HTTP_HEADER_DOCS = "ic3-Docs";
    public static final String CONF_ASSERT_PRINCIPAL_CONSISTENCY = "assert.principal.consistency";
    public static final String CONF_ASSERT_PRINCIPAL_CONSISTENCY_IGNORE_EMPTY_HEADER = "assert.principal.consistency.ignoreEmptyHeader";
    public static final String CONF_TENANT_HEADER = "header.tenant";
    public static final String CONF_USER_HEADER = "header.user";
    public static final String CONF_LOCALE_HEADER = "header.locale";
    public static final String CONF_ROLE_HEADER = "header.role";
    public static final String CONF_ROLE_MAPPER = "header.role.mapper";
    public static final String CONF_SCHEMAS_HEADER = "header.schemas";
    public static final String CONF_SCHEMAS_PERMS_HEADER = "header.schemas.perms";
    public static final String CONF_MDX_ROLE_HEADER = "header.mdxRole";
    public static final String CONF_DOCS_ROLE_HEADER = "header.docsRole";
    public static final String CONF_DASHBOARDS_HEADER = "header.dashboards";
    public static final String CONF_DOCS_HEADER = "header.docs";
    public static final String CONF_LOCALE_DEFAULT = "header.default.locale";
    public static final String CONF_ROLE_ON_THE_FLY = "header.role.onTheFly";
    private boolean assertPrincipalConsistency = true;
    private boolean assertPrincipalConsistencyIgnoreEmptyHeader = false;
    private String tenantHeader = "ic3-Tenant";
    private String userHeader = "ic3-User";
    private String localeHeader = "ic3-Locale";
    private String roleHeader = "ic3-Role";
    @Nullable
    private String roleMapper;
    private String mdxRoleHeader = "ic3-Mdx-Role";
    private String docsRoleHeader = "ic3-Docs-Role";
    private String schemasHeader = "ic3-Schemas";
    private String schemasPermsHeader = "ic3-Schemas-Perms";
    private String dashboardsHeader = "ic3-Dashboards";
    private String docsHeader = "ic3-Docs";
    private Locale defaultLocale = Locale.ENGLISH;
    private boolean roleOnTheFly = true;
    @Nullable
    private OlapTenantManager tenants;
    @Nullable
    private IOlapRoleDefinitionProvider roleDefinitions;

    public IcCubeHeaderAuthenticationService() {
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] create Header Authentication Service");
    }

    public String getName() {
        return "Header Authentication Service";
    }

    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configure(configuration);
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] configure Header Authentication Service");
        this.roleDefinitions = (IOlapRoleDefinitionProvider)configuration.getConfigurationProperty("ic3roleDefinitions");
        try {
            OlapEngineApplicationContext context;
            this.assertPrincipalConsistency = configuration.getConfigurationBooleanProperty(CONF_ASSERT_PRINCIPAL_CONSISTENCY, true);
            this.assertPrincipalConsistencyIgnoreEmptyHeader = configuration.getConfigurationBooleanProperty(CONF_ASSERT_PRINCIPAL_CONSISTENCY_IGNORE_EMPTY_HEADER, false);
            this.tenantHeader = configuration.getConfigurationStringProperty(CONF_TENANT_HEADER, HTTP_HEADER_TENANT);
            this.userHeader = configuration.getConfigurationStringProperty(CONF_USER_HEADER, HTTP_HEADER_USER);
            this.localeHeader = configuration.getConfigurationStringProperty(CONF_LOCALE_HEADER, HTTP_HEADER_LOCALE);
            this.roleHeader = configuration.getConfigurationStringProperty(CONF_ROLE_HEADER, HTTP_HEADER_ROLE);
            this.roleMapper = configuration.getConfigurationStringProperty(CONF_ROLE_MAPPER);
            this.mdxRoleHeader = configuration.getConfigurationStringProperty(CONF_MDX_ROLE_HEADER, HTTP_HEADER_MDX_ROLE);
            this.docsRoleHeader = configuration.getConfigurationStringProperty(CONF_DOCS_ROLE_HEADER, HTTP_HEADER_DOCS_ROLE);
            this.schemasHeader = configuration.getConfigurationStringProperty(CONF_SCHEMAS_HEADER, HTTP_HEADER_SCHEMAS);
            this.schemasPermsHeader = configuration.getConfigurationStringProperty(CONF_SCHEMAS_PERMS_HEADER, HTTP_HEADER_SCHEMAS_PERMS);
            this.dashboardsHeader = configuration.getConfigurationStringProperty(CONF_DASHBOARDS_HEADER, HTTP_HEADER_DASHBOARDS);
            this.docsHeader = configuration.getConfigurationStringProperty(CONF_DOCS_HEADER, HTTP_HEADER_DOCS);
            String locale_ = configuration.getConfigurationStringProperty(CONF_LOCALE_DEFAULT);
            this.defaultLocale = CdLocaleUtils.fromName((String)locale_, (Locale)Locale.ENGLISH);
            this.roleOnTheFly = configuration.getConfigurationBooleanProperty(CONF_ROLE_ON_THE_FLY, true);
            Object ctxt = configuration.getConfigurationProperty("olapEngineAppContext");
            if (ctxt instanceof OlapEngineApplicationContext && (context = (OlapEngineApplicationContext)ctxt).isWithMultiTenant()) {
                this.tenants = context.getTenants();
            }
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] assert principal consistency : " + this.assertPrincipalConsistency));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]        > ignore empty header : " + this.assertPrincipalConsistencyIgnoreEmptyHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]             role definitions : " + (this.roleDefinitions != null ? "OK" : "KO")));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]          tenants definitions : " + (this.tenants != null ? "OK" : "KO")));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]              tenant (header) : " + this.tenantHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]                user (header) : " + this.userHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]              locale (header) : " + this.localeHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]                role (header) : " + this.roleHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]                role (mapper) : " + (this.roleMapper != null ? this.roleMapper : "")));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]            mdx-role (header) : " + this.mdxRoleHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]           docs-role (header) : " + this.docsRoleHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]             schemas (header) : " + this.schemasHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]       schemas-perms (header) : " + this.schemasPermsHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]          dashboards (header) : " + this.dashboardsHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]                docs (header) : " + this.docsHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]               default locale : " + String.valueOf(this.defaultLocale)));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]             role on-the-fly  : " + this.roleOnTheFly));
        }
        catch (OlapConfigurationException ex) {
            throw new OlapAuthenticationServiceException(true, ex.getMessage(), (Throwable)ex);
        }
    }

    public String getTenantHeader() {
        return this.tenantHeader;
    }

    public String getUserHeader() {
        return this.userHeader;
    }

    public String getLocaleHeader() {
        return this.localeHeader;
    }

    public String getRoleHeader() {
        return this.roleHeader;
    }

    public String getSchemasHeader() {
        return this.schemasHeader;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean isRoleOnTheFly() {
        return this.roleOnTheFly;
    }

    public boolean isUserNameCaseSensitive() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public List<String> getUserNames() {
        return new ArrayList<String>();
    }

    public boolean isNewOrUpdated(IOlapUserDefinition definition) {
        return false;
    }

    public void refresh(IOlapUserDefinitions userDefinitions) throws OlapAuthenticationServiceException {
    }

    public boolean assertPrincipal(HttpServletRequest request, OlapPrincipal principal) {
        return IcCubeHeaderAuthenticationService.assertPrincipal((HttpServletRequest)request, (OlapPrincipal)principal, (boolean)this.assertPrincipalConsistency, (boolean)this.assertPrincipalConsistencyIgnoreEmptyHeader);
    }

    @Nullable
    public OlapPrincipal authenticate(IOlapProtocol protocol, HttpServletRequest request, boolean allowAnonymousLogon, @Nullable String username, @Nullable String password, @Nullable String roleName) throws OlapPermissionsException {
        OlapTenant tenant;
        HashMap<String, String> consistency = new HashMap<String, String>();
        String tenantName = this.getTenant(request, consistency);
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] tenant [" + tenantName + "]"));
        }
        if (tenantName != null) {
            tenant = this.resolveTenant(tenantName);
            if (tenant == null) {
                return null;
            }
        } else {
            tenant = null;
        }
        String user = this.getUser(request, consistency);
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] user [" + user + "]"));
        }
        if (user == null) {
            return null;
        }
        Locale locale = this.getLocale(request, consistency);
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] locale [" + String.valueOf(locale) + "]"));
        }
        String role = this.getRole(request, consistency);
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] role [" + role + "]"));
        }
        if (role == null) {
            return null;
        }
        if ("administrator".equals(role)) {
            OlapRegularPrincipal principal = new OlapRegularPrincipal(tenant, user, "administrator", locale);
            return principal.setAuthInfo(consistency);
        }
        if (!this.roleOnTheFly) {
            OlapRegularPrincipal principal = new OlapRegularPrincipal(tenant, user, role, locale);
            return principal.setAuthInfo(consistency);
        }
        String roleNameForMdxExecutionProfile = this.getRoleNameForMdxExecutionProfile(request, consistency, "mdx-exec-profile-role-n/a");
        String roleNameForDocs = this.getRoleNameForDocs(request, consistency, "docs-role-is-role-name");
        String dashboards = this.authenticateDashboards$$(request, consistency, role, this.getDashboards(request, consistency));
        String docs = this.authenticateDocs$$(request, consistency, role, this.getDocs(request, consistency));
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)"[auth] schemasHeader setup");
        }
        if (!CdStringUtils.isNullOrBlank((String)request.getHeader(this.schemasHeader))) {
            Object[] schemas = this.getSchemas(request, consistency);
            if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
                OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] schemas [" + Arrays.toString(schemas) + "]"));
            }
            if (schemas == null || schemas.length == 0) {
                return null;
            }
            OlapSimpleOnTheFlyRoleDescription onTheFlyDescription = OlapSimpleOnTheFlyRoleDescription.createForSchema((String)tenantName, (String)user, (String)role, (String)roleNameForMdxExecutionProfile, (String)roleNameForDocs, (String[])schemas, (String)dashboards, (String)docs);
            OlapOnTheFlyPrincipal principal = new OlapOnTheFlyPrincipal(tenant, user, locale, (IOlapOnTheFlyRoleDescription)onTheFlyDescription);
            return principal.setAuthInfo(consistency);
        }
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)"[auth] schemasPermsHeader setup");
        }
        if (request.getHeader(this.schemasPermsHeader) != null) {
            return this.authenticateSchemasPerms(request, consistency, tenant, user, locale, role, roleNameForMdxExecutionProfile, roleNameForDocs, dashboards, docs);
        }
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)"[auth] $$ setup");
        }
        return this.authenticate$$(request, consistency, tenant, user, locale, role, roleNameForMdxExecutionProfile, roleNameForDocs, dashboards, docs);
    }

    private OlapPrincipal authenticateSchemasPerms(HttpServletRequest request, Map<String, String> consistency, @Nullable OlapTenant tenant, String user, Locale locale, String role, String roleNameForMdxExecutionProfile, String roleNameForDocs, String dashboards, String docs) throws OlapOnTheFlyRoleDescriptionException {
        String perms = this.getSchemasPerms(request, consistency);
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] schemas perms [" + perms + "]"));
        }
        if (perms == null) {
            return null;
        }
        String schemasPermissions = perms.replace(",,", "$comma$").replace(",", "\n").replace("$comma$", ",");
        MetaAuthorizationDescription description = new MetaAuthorizationDescription(user, locale, role, schemasPermissions);
        String tenantName = tenant != null ? tenant.getName() : null;
        MetaOnTheFlyRoleDescription onTheFlyDescription = new MetaOnTheFlyRoleDescription(tenantName, user, role, roleNameForMdxExecutionProfile, roleNameForDocs, description, dashboards, docs);
        OlapOnTheFlyPrincipal principal = new OlapOnTheFlyPrincipal(tenant, user, locale, (IOlapOnTheFlyRoleDescription)onTheFlyDescription);
        return principal.setAuthInfo(consistency);
    }

    @Nullable
    private OlapPrincipal authenticate$$(HttpServletRequest request, Map<String, String> consistency, @Nullable OlapTenant tenant, String user, Locale locale, String role, String roleNameForMdxExecutionProfile, String roleNameForDocs, String dashboards, String docs) throws OlapOnTheFlyRoleDescriptionException {
        if (this.roleDefinitions != null) {
            try {
                String schemasPermissions;
                OlapRoleDefinition template = this.roleDefinitions.getRoleDefinitionByName(role);
                if (template == null) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] $$ setup: missing role [" + role + "]"));
                    }
                    return null;
                }
                IOlapRoleSchemasDefinition perms = template.getValidatedSchemasPermissions();
                String def = perms.getDefinition();
                if (!def.contains("$$")) {
                    if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] $$ setup: no $$ in schemas permissions of role [" + role + "]"));
                    }
                    schemasPermissions = def;
                } else {
                    schemasPermissions = this.process$$(request, consistency, def);
                }
                MetaAuthorizationDescription description = new MetaAuthorizationDescription(user, locale, template.getName(), schemasPermissions);
                String tenantName = tenant != null ? tenant.getName() : null;
                MetaOnTheFlyRoleDescription onTheFlyDescription = new MetaOnTheFlyRoleDescription(tenantName, user, template.getName(), roleNameForMdxExecutionProfile, roleNameForDocs, description, dashboards, docs);
                OlapOnTheFlyPrincipal principal = new OlapOnTheFlyPrincipal(tenant, user, locale, (IOlapOnTheFlyRoleDescription)onTheFlyDescription);
                return principal.setAuthInfo(consistency);
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)"[auth] $$ setup error", (Throwable)ex);
                return null;
            }
        }
        if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)"[auth] $$ setup null");
        }
        return null;
    }

    private OlapTenant resolveTenant(String name) {
        OlapTenantDefinition definition;
        OlapTenantDefinition olapTenantDefinition = definition = this.tenants != null ? this.tenants.getTenantDefinitionByName(name) : null;
        if (definition == null) {
            OlapLoggers.AUTHORIZATION_HEADERS.error((Object)("[auth] missing tenant [" + name + "]"));
            return null;
        }
        return new OlapTenant(definition.getName(), definition.getDirectory());
    }

    @Nullable
    private String getTenant(HttpServletRequest request, Map<String, String> consistency) {
        String tenant = request.getHeader(this.tenantHeader);
        if (CdStringUtils.isNullOrBlank((String)tenant)) {
            return null;
        }
        consistency.put(this.tenantHeader, tenant);
        return tenant;
    }

    @Nullable
    private String getUser(HttpServletRequest request, Map<String, String> consistency) {
        String user = request.getHeader(this.userHeader);
        if (CdStringUtils.isNullOrBlank((String)user)) {
            OlapLoggers.AUTHORIZATION_HEADERS.error((Object)("[auth] missing user header [" + this.userHeader + "]"));
            return null;
        }
        consistency.put(this.userHeader, user);
        return user;
    }

    @Nullable
    private String getRole(HttpServletRequest request, Map<String, String> consistency) {
        String role = request.getHeader(this.roleHeader);
        if (CdStringUtils.isNullOrBlank((String)role)) {
            OlapLoggers.AUTHORIZATION_HEADERS.error((Object)("[auth] missing role header [" + this.roleHeader + "]"));
            return null;
        }
        consistency.put(this.roleHeader, role);
        if (this.roleMapper != null) {
            role = role.replace(this.roleMapper, "");
        }
        return role;
    }

    private Locale getLocale(HttpServletRequest request, Map<String, String> consistency) {
        Locale locale_;
        String locale = request.getHeader(this.localeHeader);
        if (!CdStringUtils.isNullOrBlank((String)locale)) {
            consistency.put(this.localeHeader, locale);
            locale_ = CdLocaleUtils.fromName((String)locale, (Locale)this.defaultLocale);
        } else {
            locale_ = this.defaultLocale;
        }
        return locale_;
    }

    @Nullable
    private String[] getSchemas(HttpServletRequest request, Map<String, String> consistency) {
        String schemas = request.getHeader(this.schemasHeader);
        if (CdStringUtils.isNullOrBlank((String)schemas)) {
            OlapLoggers.AUTHORIZATION_HEADERS.error((Object)("[auth] missing schemas header [" + this.schemasHeader + "]"));
            return null;
        }
        consistency.put(this.schemasHeader, schemas);
        return schemas.split(",");
    }

    @Nullable
    private String getSchemasPerms(HttpServletRequest request, Map<String, String> consistency) {
        String schemas = request.getHeader(this.schemasPermsHeader);
        if (schemas == null) {
            OlapLoggers.AUTHORIZATION_HEADERS.error((Object)("[auth] missing schemas perms. header [" + this.schemasPermsHeader + "]"));
            return null;
        }
        consistency.put(this.schemasPermsHeader, schemas);
        return schemas;
    }

    private String getRoleNameForMdxExecutionProfile(HttpServletRequest request, Map<String, String> consistency, String defaultRole) {
        String mdxRole = request.getHeader(this.mdxRoleHeader);
        if (CdStringUtils.isNullOrBlank((String)mdxRole)) {
            return defaultRole;
        }
        consistency.put(this.mdxRoleHeader, mdxRole);
        return mdxRole;
    }

    private String getRoleNameForDocs(HttpServletRequest request, Map<String, String> consistency, String defaultRole) {
        String docsRole = request.getHeader(this.docsRoleHeader);
        if (CdStringUtils.isNullOrBlank((String)docsRole)) {
            return defaultRole;
        }
        consistency.put(this.docsRoleHeader, docsRole);
        return docsRole;
    }

    @Nullable
    private String getDashboards(HttpServletRequest request, Map<String, String> consistency) {
        String dashboards = request.getHeader(this.dashboardsHeader);
        if (dashboards == null) {
            return null;
        }
        consistency.put(this.dashboardsHeader, dashboards);
        return dashboards;
    }

    @Nullable
    private String getDocs(HttpServletRequest request, Map<String, String> consistency) {
        String docs = request.getHeader(this.docsHeader);
        if (docs == null) {
            return null;
        }
        consistency.put(this.docsHeader, docs);
        return docs;
    }

    @Nullable
    private String authenticateDashboards$$(HttpServletRequest request, Map<String, String> consistency, String templateRole, @Nullable String dashboardsFromHeader) {
        if (CdStringUtils.isNotNullAndNotBlank((String)dashboardsFromHeader)) {
            if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                OlapLoggers.AUTHORIZATION.debug((Object)"[auth] dashboards $$ setup : using header");
            }
            return dashboardsFromHeader;
        }
        if (this.roleDefinitions != null) {
            try {
                String dashboardsPermissions;
                String def;
                OlapRoleDefinition template = this.roleDefinitions.getRoleDefinitionByName(templateRole);
                if (template == null) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] dashboards $$ setup: missing role [" + templateRole + "]"));
                    }
                    return null;
                }
                OlapRoleFlatDashboardsProfile perms = template.getValidatedDashboardsPermissions();
                if (perms == null) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] dashboards $$ setup: missing validated role [" + templateRole + "]"));
                    }
                    return null;
                }
                if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                    OlapLoggers.AUTHORIZATION.debug((Object)("[auth] dashboards $$ setup: using role [" + templateRole + "]"));
                }
                if (!(def = perms.getDefinition()).contains("$$")) {
                    if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] dashboards $$ setup: no $$ in docs permissions of role [" + templateRole + "]"));
                    }
                    dashboardsPermissions = def;
                } else {
                    dashboardsPermissions = this.process$$(request, consistency, def);
                }
                return dashboardsPermissions;
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)"[auth] dashboards $$ setup error", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    @Nullable
    private String authenticateDocs$$(HttpServletRequest request, Map<String, String> consistency, String templateRole, @Nullable String docsFromHeader) {
        if (CdStringUtils.isNotNullAndNotBlank((String)docsFromHeader)) {
            if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                OlapLoggers.AUTHORIZATION.debug((Object)"[auth] docs $$ setup : using header");
            }
            return docsFromHeader;
        }
        if (this.roleDefinitions != null) {
            try {
                String docsPermissions;
                String def;
                OlapRoleDefinition template = this.roleDefinitions.getRoleDefinitionByName(templateRole);
                if (template == null) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] docs $$ setup: missing role [" + templateRole + "]"));
                    }
                    return "-- missing role " + templateRole;
                }
                OlapRoleFlatDocsProfile perms = template.getValidatedDocsPermissions();
                if (perms == null) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] docs $$ setup: missing validated role [" + templateRole + "]"));
                    }
                    return "-- missing validated role " + templateRole;
                }
                if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                    OlapLoggers.AUTHORIZATION.debug((Object)("[auth] docs $$ setup: using role [" + templateRole + "]"));
                }
                if (!(def = perms.getDefinition()).contains("$$")) {
                    if (OlapLoggers.AUTHORIZATION_HEADERS.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION_HEADERS.debug((Object)("[auth] docs $$ setup: no $$ in docs permissions of role [" + templateRole + "]"));
                    }
                    docsPermissions = def;
                } else {
                    docsPermissions = this.process$$(request, consistency, def);
                }
                return docsPermissions;
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)"[auth] docs $$ setup error", (Throwable)ex);
                return "-- setup error";
            }
        }
        return null;
    }

    private String process$$(HttpServletRequest request, Map<String, String> consistency, String def) {
        String definition = def;
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String placeholder;
            String name = (String)names.nextElement();
            String header = request.getHeader(name);
            if (header == null || !Strings.CI.contains((CharSequence)definition, (CharSequence)(placeholder = "$$" + name + "$$"))) continue;
            consistency.put(name, header);
            definition = Strings.CI.replace(definition, placeholder, header);
        }
        return definition;
    }
}

