/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.gvi.GviConstants;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.ux.admin.queries.runtime.sessions.UxSessionLogoutQuery;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class IcCubeGviLogoutAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        String action = request.getParameter(GviConstants.Param.action.name());
        if (GviConstants.Action.logout.name().equals(action)) {
            OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
            if (OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
                OlapLoggers.AUTHENTICATION.info((Object)("GVI authentication logout [" + (principal == null ? "" : principal.getName()) + "]"));
            }
            GviDataTableResponse result = new GviDataTableResponse(IOlapCancellingContext.NOP, null);
            ((GviResponse)result).writeResponse(request, response, this.babylon);
            IcCubeServerSessionContext sessionContext = (IcCubeServerSessionContext)session.getAttribute("icCubeServer.sessionContext");
            if (sessionContext != null) {
                String sessionId = sessionContext.getSessionId();
                UxSessionLogoutQuery.logout(sessionContext, sessionId);
            }
            return;
        }
        filterChain.doFilter((ServletRequest)request, servletResponse);
    }
}

