/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.credentials.CdCredentials;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public class IcCubeFormAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    public static final String ICCUBE_SECURITY_CHECK = "j_security_check";
    public static final String ICCUBE_USERNAME = "j_username";
    public static final String ICCUBE_PASSWORD = "j_password";
    private static final String UTF_8 = "UTF-8";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private File loginPage;
    @Nullable
    private String ic3demo;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        String loginPageConfiguration = configuration.getInitParameter("loginPage");
        if (loginPageConfiguration != null && !loginPageConfiguration.trim().isEmpty()) {
            String value = CdConfigurationUtils.substVars((String)loginPageConfiguration);
            this.loginPage = new File(value);
        } else if (applicationContext.isUxActive()) {
            File web = this.runtime.getInstallUxDirectory();
            this.loginPage = new File(web, "icCube_login.html");
        } else {
            File web = new File(this.runtime.getInstallWebDirectory(), "icCube");
            this.loginPage = new File(web, "icCube_login.html");
        }
        if (!(!this.runtime.requiresLoginPage() || this.loginPage.exists() && this.loginPage.isFile())) {
            throw new ServletException("icCube HTTP FORM authentication filter error - invalid login page : " + this.loginPage.getAbsolutePath());
        }
        this.ic3demo = configuration.getInitParameter("ic3demo");
        if (CdStringUtils.isNullOrBlank((String)this.ic3demo)) {
            this.ic3demo = null;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding(UTF_8);
        servletResponse.setCharacterEncoding(UTF_8);
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        if (session == null) {
            this.requestLogin(response);
            return;
        }
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            if (request.getParameter(ICCUBE_SECURITY_CHECK) != null) {
                session.removeAttribute("icCubeServer.sessionContext");
                session.invalidate();
                this.performLogin(request, response, filterChain);
                return;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getParameter(ICCUBE_SECURITY_CHECK) != null) {
            this.performLogin(request, response, filterChain);
            return;
        }
        if (this.ic3demo != null && request.getParameter("ic3demo") != null) {
            this.performDemoLogin(request, response, filterChain, this.ic3demo);
            return;
        }
        this.requestLogin(response);
    }

    private void performLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String userInformation = request.getParameter(ICCUBE_USERNAME);
        if (this.anonymousLogon && (userInformation == null || userInformation.trim().isEmpty())) {
            this.performAnonymousLogin(request, response, filterChain);
        } else {
            this.performRegularLogin(request, response, filterChain, userInformation);
        }
    }

    private void performAnonymousLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            OlapPrincipal olapAuthenticatedPrincipal = this.createAuthenticatedAnonymousPrincipal("HTTP Form");
            this.onAuthenticationOk(request, response, filterChain, olapAuthenticatedPrincipal, false);
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"anonymous authentication failed", (Throwable)ex);
            this.requestLogin(response, ex.getLocalizedMessage(this.babylon), null);
        }
    }

    private void performRegularLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, @Nullable String userInformation) throws ServletException, IOException {
        String password = request.getParameter(ICCUBE_PASSWORD);
        CdCredentials credentials = IcCubeFormAuthenticationServletFilter.extractCredentials(userInformation, password);
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("HTTP Form", IOlapProtocol.NA, request, credentials.userName, credentials.userPassword, credentials.userRole);
            if (authenticatedPrincipal != null) {
                this.onAuthenticationOk(request, response, filterChain, authenticatedPrincipal, false);
            } else {
                this.requestLogin(response, this.babylon.translate("invalidLogin", new Serializable[0]), userInformation);
            }
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.requestLogin(response, this.babylon.translate("invalidLogin", new Serializable[0]), userInformation);
        }
    }

    private void performDemoLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String userName) throws ServletException, IOException {
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("icCube Demo", IOlapProtocol.NA, (HttpServletRequest)new Ic3DemoRequestWrapper(request), userName, null, null);
            if (authenticatedPrincipal != null) {
                this.onAuthenticationOk(request, response, filterChain, authenticatedPrincipal, true);
            } else {
                this.requestLogin(response, this.babylon.translate("invalidLogin", new Serializable[0]), userName);
            }
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.requestLogin(response, this.babylon.translate("invalidLogin", new Serializable[0]), userName);
        }
    }

    private void requestLogin(HttpServletResponse response) throws IOException, ServletException {
        this.replyFile(response, this.getLoginHtml());
    }

    private void requestLogin(HttpServletResponse response, String error, String userName) throws IOException, ServletException {
        this.replyFile(response, this.getLoginHtml(), error, userName);
    }

    private File getLoginHtml() throws ServletException {
        if (this.loginPage == null) {
            throw new ServletException("icCube internal error (missing HTTP FORM login page).");
        }
        return this.loginPage;
    }

    private void replyFile(HttpServletResponse response, File file) throws IOException {
        this.replyFile(response, file, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyFile(HttpServletResponse response, File file, @Nullable String message, @Nullable String userName) throws IOException {
        response.setContentType(CONTENT_TYPE_TEXT_HTML);
        PrintWriter out = response.getWriter();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                line = line.replace("\"js/", "\"/icCube/js/");
                line = line.replace("'js/", "'/icCube/js/");
                line = line.replace("\"css/", "\"/icCube/css/");
                line = line.replace("'css/", "'/icCube/css/");
                line = line.replace("\"images/", "\"/icCube/images/");
                line = line.replace("'images/", "'/icCube/images/");
                line = userName == null ? line.replace("$userValue$", "") : line.replace("$userValue$", StringEscapeUtils.escapeHtml4((String)userName));
                if (message != null) {
                    line = line.replace("$message$", message);
                    line = line.replace("$error-class$", "error");
                } else {
                    line = line.replace("$message$", "&nbsp;");
                    line = line.replace("$error-class$", "");
                }
                line = line.replace("$login-caption$", this.babylon.translate("login_DialogCaption", new Serializable[0]));
                line = line.replace("$username$", this.babylon.translate("login_UserName", new Serializable[0]));
                line = line.replace("$enter-username$", this.babylon.translate("login_UserName_Enter", new Serializable[0]));
                line = line.replace("$password-long$", "");
                line = line.replace("$username-long$", "");
                line = line.replace("$password$", this.babylon.translate("login_Password", new Serializable[0]));
                line = line.replace("$login-button$", this.babylon.translate("login_DialogButton", new Serializable[0]));
                line = line.replace("$action$", "");
                ((Writer)out).write(line);
                ((Writer)out).write("\n");
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    static class Ic3DemoRequestWrapper
    extends HttpServletRequestWrapper {
        public Ic3DemoRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getAuthType() {
            return "IC3_DEMO";
        }
    }
}

