/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class IcCubeAutoAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    @Nullable
    private String roleName;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        if (OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
            OlapLoggers.AUTHENTICATION.info((Object)"[auth] (auto) activated");
        }
        this.roleName = configuration.getInitParameter("roleName");
        if (CdStringUtils.isNullOrBlank((String)this.roleName)) {
            this.roleName = null;
        }
        if (OlapLoggers.AUTHENTICATION.isInfoEnabled()) {
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] (auto)   roleName : " + (CdStringUtils.isNotNullAndNotBlank((String)this.roleName) ? this.roleName : "<anonymous>")));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] (auto) using principal : " + principal.getName() + " (" + principal.getRoleName() + ")"));
            }
            filterChain.doFilter((ServletRequest)request, servletResponse);
            return;
        }
        this.performAutoLogin(request, response, filterChain);
    }

    private void performAutoLogin(HttpServletRequest request, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpSession session = request.getSession();
            OlapPrincipal principal = this.createAuthenticatedAutoPrincipal(this.roleName);
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] (auto) creating principal : " + principal.getName() + " (" + principal.getRoleName() + ")"));
            }
            session.setAttribute("icCube.principal", (Object)principal);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)servletResponse);
        }
        catch (OlapPermissionsException ex) {
            throw new ServletException("[auth] (auto) authentication [" + this.getAuthenticationServiceName() + "] error : " + ex.getMessage(), (Throwable)ex);
        }
    }
}

