/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.http.OlapHttpUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.IOlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapUserDefinitions;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipalPhoto;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IcCubeAuthenticationServiceWrapper
implements IOlapAuthenticationService {
    private IOlapAuthenticationService service;

    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        this.service.configure(configuration);
    }

    public void clearExternalData(@Nullable String tenant) {
        this.service.clearExternalData(tenant);
    }

    public void shutdownNow() {
        this.service.shutdownNow();
    }

    @Nullable
    public String getLogoutRedirectUrl() {
        return this.service.getLogoutRedirectUrl();
    }

    public boolean isUserDefinitionWithPassword() {
        return this.service.isUserDefinitionWithPassword();
    }

    public boolean isUserNameCaseSensitive() {
        return this.service.isUserNameCaseSensitive();
    }

    public int getPasswordMinLength() {
        return this.service.getPasswordMinLength();
    }

    public String getName() {
        return this.service.getName();
    }

    public boolean isEditable() {
        return this.service.isEditable();
    }

    public int getRevisionNumber() {
        return this.service.getRevisionNumber();
    }

    @Nullable
    public OlapPrincipalPhoto getUserPhoto(String user) {
        return this.service.getUserPhoto(user);
    }

    public List<String> getUserNames() {
        return this.service.getUserNames();
    }

    public List<OlapUserDefinition> getSortedUserDefinitions() {
        return this.service.getSortedUserDefinitions();
    }

    @Nullable
    public OlapUserDefinition getUserDefinitionByUUID(String name) {
        return this.service.getUserDefinitionByUUID(name);
    }

    @Nullable
    public OlapUserDefinition getUserDefinitionByName(String name) {
        return this.service.getUserDefinitionByName(name);
    }

    public boolean isSameUser(OlapPrincipal principal, String userName) {
        return this.service.isSameUser(principal, userName);
    }

    public boolean isNewOrUpdated(IOlapUserDefinition definition) {
        return this.service.isNewOrUpdated(definition);
    }

    public void refresh(IOlapUserDefinitions userDefinitions) throws OlapAuthenticationServiceException {
        this.service.refresh(userDefinitions);
    }

    public boolean assertPrincipal(HttpServletRequest request, OlapPrincipal principal) {
        return this.service.assertPrincipal(request, principal);
    }

    public OlapPrincipal authenticate(IOlapProtocol protocol, HttpServletRequest request, boolean allowAnonymousLogon, @Nullable String username, @Nullable String password, @Nullable String roleName) throws OlapPermissionsException {
        OlapPrincipal authUser = this.service.authenticate(protocol, request, allowAnonymousLogon, username, password, roleName);
        if (authUser != null) {
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] user authenticated : " + authUser.getName() + " / " + authUser.getRoleName() + " / " + OlapHttpUtils.getClientIpAddr((HttpServletRequest)request)));
        }
        return authUser;
    }

    public void setService(IOlapAuthenticationService service) {
        this.service = service;
    }

    public void logout(HttpSession session) {
        this.service.logout(session);
    }
}

