/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.security.CdPasswordHash;
import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authentication.definition.OlapUserDefinitions;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import crazydev.iccube.pub.authentication.IOlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapUserDefinitions;
import crazydev.iccube.pub.authentication.IcCubeAbstractAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipalPhoto;
import crazydev.iccube.pub.principal.OlapRegularPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class IcCubeAuthenticationService
extends IcCubeAbstractAuthenticationService {
    public static final String PWD_MIN_LENGTH = "pwdMinLength";
    public static final String CASE_INSENSITIVE = "caseInsensitive";
    public static final String PWD_ITERATIONS = "pwdIterations";
    public static final String PWD_SALT_LENGTH = "pwdSaltLength";
    public static final String PWD_KEY_LENGTH = "pwdKeyLength";
    public static final String ASSERT_PRINCIPAL_CONSISTENCY = "assertPrincipalConsistency";
    public static final String ASSERT_PRINCIPAL_CONSISTENCY_IGNORE_EMPTY_HEADER = "assertPrincipalConsistencyIgnoreEmptyHeader";
    public static final String USERNAME_FROM_HEADER = "userNameFromHeader";
    public static final String USERROLE_FROM_HEADER = "userRoleFromHeader";
    public static final String MISSING_USER_ROLE = "missingUserRole";
    public static final String MISSING_USER_LOCALE = "missingUserLocale";
    public static final String LOGOUT_REDIRECT_URL = "logoutRedirectUrl";
    private final Object lock = new Object();
    @Nullable
    private OlapTenantManager tenants;
    private int revisionNumber = -1;
    @Nullable
    private Map<String, OlapUserDefinition> __users;
    @Nullable
    private Boolean caseInsensitive;
    private int pwdMinLength;
    private boolean assertPrincipalConsistency;
    private boolean assertPrincipalConsistencyIgnoreEmptyHeader;
    @Nullable
    private String userNameFromHeader;
    @Nullable
    private String userRoleFromHeader;
    @Nullable
    private String missingUserRole;
    @Nullable
    private Locale missingUserLocale;
    @Nullable
    private String logoutRedirectUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configure(configuration);
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] configure Authentication Service");
        try {
            this.assertPrincipalConsistency = configuration.getConfigurationBooleanProperty(ASSERT_PRINCIPAL_CONSISTENCY, true);
            this.assertPrincipalConsistencyIgnoreEmptyHeader = configuration.getConfigurationBooleanProperty(ASSERT_PRINCIPAL_CONSISTENCY_IGNORE_EMPTY_HEADER, false);
            this.userNameFromHeader = configuration.getConfigurationStringProperty(USERNAME_FROM_HEADER);
            this.userRoleFromHeader = configuration.getConfigurationStringProperty(USERROLE_FROM_HEADER);
            this.missingUserRole = configuration.getConfigurationStringProperty(MISSING_USER_ROLE);
            String missingUserLocale_ = configuration.getConfigurationStringProperty(MISSING_USER_LOCALE);
            this.missingUserLocale = CdLocaleUtils.fromName((String)missingUserLocale_, (Locale)Locale.ENGLISH);
            this.logoutRedirectUrl = configuration.getConfigurationStringProperty(LOGOUT_REDIRECT_URL);
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] assert principal consistency : " + this.assertPrincipalConsistency));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]        > ignore empty header : " + this.assertPrincipalConsistencyIgnoreEmptyHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]           userNameFromHeader : " + this.userNameFromHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]           userRoleFromHeader : " + this.userRoleFromHeader));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]              missingUserRole : " + this.missingUserRole));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]            missingUserLocale : " + String.valueOf(this.missingUserLocale)));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]            logoutRedirectUrl : " + this.logoutRedirectUrl));
        }
        catch (OlapConfigurationException | RuntimeException ex) {
            throw new OlapAuthenticationServiceException(true, ex.getMessage(), ex);
        }
        try {
            int pwdIterations = configuration.getConfigurationIntProperty(PWD_ITERATIONS, 10000);
            int pwdSaltLength = configuration.getConfigurationIntProperty(PWD_SALT_LENGTH, 32);
            int pwdKeyLength = configuration.getConfigurationIntProperty(PWD_KEY_LENGTH, 256);
            this.pwdMinLength = configuration.getConfigurationIntProperty(PWD_MIN_LENGTH, 5);
            CdPasswordHash.init((int)pwdIterations, (int)pwdSaltLength, (int)pwdKeyLength);
            long startTime = System.currentTimeMillis();
            String example = CdPasswordHash.encode((String)"checking fine");
            OlapLoggers.AUTHENTICATION.info((Object)("Password Hash '" + example + "' in :" + CdTimeUtils.formatMillisEx((long)startTime)));
        }
        catch (OlapConfigurationException | RuntimeException | NoSuchAlgorithmException ex) {
            throw new OlapAuthenticationServiceException(true, ex.getMessage(), ex);
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> errors = new ArrayList<String>();
            try {
                String paramCaseInsensitive = (String)configuration.getConfigurationProperty(CASE_INSENSITIVE);
                this.caseInsensitive = paramCaseInsensitive != null ? Boolean.valueOf("true".equalsIgnoreCase(paramCaseInsensitive)) : Boolean.valueOf(false);
                String usersDirectoryPath = (String)configuration.getConfigurationProperty("ic3usersDirectory");
                File usersDirectory = new File(usersDirectoryPath);
                File usersFile = new File(usersDirectory, "icCubeUsers.icc-users");
                OlapLoggers.AUTHENTICATION.info((Object)("Reading user definitions from [" + usersFile.getAbsolutePath() + "]..."));
                OlapUserDefinitions usersDefinition = (OlapUserDefinitions)CdXmlUtils.unmarshall((String)"UTF-8", (File)usersFile, (Class[])new Class[]{OlapUserDefinitions.class});
                Integer version = usersDefinition.getVersion();
                if (version == null || version < 2) {
                    throw new IOException("users: old format not migrated");
                }
                boolean rolesActive = true;
                Object ctxt = configuration.getConfigurationProperty("olapEngineAppContext");
                if (ctxt instanceof OlapEngineApplicationContext) {
                    OlapEngineApplicationContext context = (OlapEngineApplicationContext)ctxt;
                    rolesActive = context.isAccessRightsLicensed();
                    if (context.isWithMultiTenant()) {
                        this.tenants = context.getTenants();
                    }
                }
                for (OlapUserDefinition userDefinition : usersDefinition.getDefinitions()) {
                    HashSet<String> uuids = new HashSet<String>();
                    Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
                    if (!rolesActive) {
                        userDefinition.clearRolesForCommunity();
                    }
                    IcCubeAuthenticationService.addUser(this.isUserDefinitionWithPassword(), uuids, users, errors, (IOlapUserDefinition)userDefinition);
                }
                if (!errors.isEmpty()) {
                    throw new OlapAuthenticationServiceException(false, "icCube user definitions errors", errors);
                }
                ++this.revisionNumber;
            }
            catch (JAXBException | IOException | RuntimeException ex) {
                throw new OlapAuthenticationServiceException(true, "icCube user definitions unexpected exception", ex);
            }
        }
    }

    @Nullable
    public String getLogoutRedirectUrl() {
        return this.logoutRedirectUrl;
    }

    public boolean isUserDefinitionWithPassword() {
        return !this.isUserNameFromHeader();
    }

    public boolean isUserNameCaseSensitive() {
        if (this.caseInsensitive == null) {
            throw new RuntimeException("internal error : case-sensitivity not setup yet !");
        }
        return this.caseInsensitive == false;
    }

    public String getName() {
        return "icCube-icc-users";
    }

    public boolean isEditable() {
        return true;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapPrincipalPhoto getUserPhoto(String userName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            OlapUserDefinition user = users.get(userName);
            if (user != null) {
                return user.getUserPhoto();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserNames() {
        Object object = this.lock;
        synchronized (object) {
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            return new ArrayList<String>(users.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapUserDefinition> getSortedUserDefinitions() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<OlapUserDefinition> names = new ArrayList<OlapUserDefinition>();
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            for (OlapUserDefinition definition : users.values()) {
                names.add(definition.copyForUX());
            }
            names.sort((o1, o2) -> {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            });
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapUserDefinition getUserDefinitionByUUID(String uuid) {
        if (uuid == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            for (OlapUserDefinition definition : users.values()) {
                if (!uuid.equals(definition.getUUID())) continue;
                return definition.copyForUX();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapUserDefinition getUserDefinitionByName(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            for (OlapUserDefinition definition : users.values()) {
                if (this.isUserNameCaseSensitive()) {
                    if (!name.equals(definition.getName())) continue;
                    return definition.copyForUX();
                }
                if (!name.equalsIgnoreCase(definition.getName())) continue;
                return definition.copyForUX();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(IOlapUserDefinitions userDefinitions) throws OlapAuthenticationServiceException {
        Object object = this.lock;
        synchronized (object) {
            OlapLoggers.AUTHENTICATION.warn((Object)"Refreshing user definitions...");
            Map<String, OlapUserDefinition> newUsers = this.createUsers();
            ArrayList<String> errors = new ArrayList<String>();
            HashSet<String> uuids = new HashSet<String>();
            for (IOlapUserDefinition userDefinition : userDefinitions.getDefinitions()) {
                IcCubeAuthenticationService.addUser(this.isUserDefinitionWithPassword(), uuids, newUsers, errors, userDefinition);
            }
            if (!errors.isEmpty()) {
                throw new OlapAuthenticationServiceException(false, "icCube user definitions errors", errors);
            }
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            users.clear();
            users.putAll(newUsers);
            ++this.revisionNumber;
        }
    }

    private static void addUser(boolean requiredPassword, Set<String> uuids, Map<String, OlapUserDefinition> users, List<String> errors, IOlapUserDefinition userDefinition) {
        String name = userDefinition.getName();
        if (name == null) {
            errors.add("[auth-service] user definition: missing name.");
            return;
        }
        if (requiredPassword && !userDefinition.hasPassword()) {
            errors.add("[auth-service] user definition [user:" + name + "]: missing password.");
            return;
        }
        List roles = userDefinition.getRoles();
        if (roles == null || roles.isEmpty()) {
            errors.add("[auth-service] user definition [user:" + name + "]: missing roles.");
            return;
        }
        if (users.containsKey(name)) {
            errors.add("[auth-service] user definition [user:" + name + "]: duplicated name.");
            return;
        }
        String uuid = userDefinition.getUUID();
        if (CdStringUtils.isNotNullAndNotBlank((String)uuid) && uuids.contains(uuid)) {
            errors.add("[auth-service] user definition [user:" + name + "]: duplicated UUID [" + uuid + "]");
            return;
        }
        OlapUserDefinition clone = new OlapUserDefinition((OlapUserDefinition)userDefinition);
        if (CdStringUtils.isNotNullAndNotBlank((String)uuid)) {
            uuids.add(uuid);
        }
        users.put(name, clone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewOrUpdated(IOlapUserDefinition definition) {
        Object object = this.lock;
        synchronized (object) {
            String definitionName = definition.getName();
            if (definitionName == null) {
                return true;
            }
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            OlapUserDefinition existingDefinition = users.get(definitionName);
            if (existingDefinition == null) {
                return true;
            }
            return !existingDefinition.equals((Object)definition);
        }
    }

    public boolean assertPrincipal(HttpServletRequest request, OlapPrincipal principal) {
        if (this.isUserNameFromHeader()) {
            return IcCubeAbstractAuthenticationService.assertPrincipal((HttpServletRequest)request, (OlapPrincipal)principal, (boolean)this.assertPrincipalConsistency, (boolean)this.assertPrincipalConsistencyIgnoreEmptyHeader);
        }
        return super.assertPrincipal(request, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapPrincipal authenticate(IOlapProtocol protocol, HttpServletRequest request, boolean allowAnonymousLogon, @Nullable String username, @Nullable String password, @Nullable String roleName) throws OlapPermissionsException {
        HashMap<String, String> consistency = new HashMap<String, String>();
        if (this.isUserNameFromHeader()) {
            username = this.getUserInfoFromHeader(request, this.userNameFromHeader, consistency);
        }
        if (CdStringUtils.isNullOrBlank((String)username)) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            OlapTenantDefinition tenantDefinition;
            String tenantName;
            Map<String, OlapUserDefinition> users = this.getOrCreateUsers();
            OlapUserDefinition user = users.get(username);
            if (user == null) {
                if (this.isUserNameFromHeader()) {
                    roleName = this.getUserInfoFromHeader(request, this.userRoleFromHeader, consistency);
                    if (CdStringUtils.isNullOrBlank((String)roleName)) {
                        roleName = this.missingUserRole;
                    }
                    if (CdStringUtils.isNotNullAndNotBlank((String)roleName)) {
                        OlapRegularPrincipal principal = new OlapRegularPrincipal(username, roleName, this.missingUserLocale);
                        return principal.setAuthInfo(consistency);
                    }
                }
                return null;
            }
            String actualUserName = user.getName();
            if (actualUserName == null) {
                throw new RuntimeException("internal error : error with no name !");
            }
            if (password != null && !user.validatePassword(password)) {
                return null;
            }
            OlapTenant tenant = this.tenants != null ? ((tenantName = user.getTenant()) != null ? ((tenantDefinition = this.tenants.getTenantDefinitionByName(tenantName)) != null ? new OlapTenant(tenantDefinition.getName(), tenantDefinition.getDirectory()) : null) : null) : null;
            if (roleName != null) {
                if (user.getValidatedRoles().contains(roleName)) {
                    OlapRegularPrincipal principal = new OlapRegularPrincipal(tenant, actualUserName, roleName, user.getLocale());
                    if (this.isUserNameFromHeader()) {
                        principal.setAuthInfo(consistency);
                    }
                    return principal;
                }
                return null;
            }
            String defaultRole = (String)user.getValidatedRoles().get(0);
            OlapRegularPrincipal principal = new OlapRegularPrincipal(tenant, actualUserName, defaultRole, user.getLocale());
            if (this.isUserNameFromHeader()) {
                principal.setAuthInfo(consistency);
            }
            return principal;
        }
    }

    private boolean isUserNameFromHeader() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.userNameFromHeader);
    }

    @Nullable
    private String getUserInfoFromHeader(HttpServletRequest request, @Nullable String header, Map<String, String> consistency) {
        if (header == null) {
            return null;
        }
        String info = request.getHeader(header);
        if (CdStringUtils.isNullOrBlank((String)info)) {
            return null;
        }
        consistency.put(header, info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, OlapUserDefinition> getOrCreateUsers() {
        Object object = this.lock;
        synchronized (object) {
            if (this.__users == null) {
                this.__users = this.createUsers();
            }
            return this.__users;
        }
    }

    private Map<String, OlapUserDefinition> createUsers() {
        if (this.isUserNameCaseSensitive()) {
            return new HashMap<String, OlapUserDefinition>();
        }
        return new CdCaseInsensitiveHashMap();
    }

    public int getPasswordMinLength() {
        return this.pwdMinLength;
    }

    public void logout(HttpSession session) {
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)("[auth] Logout HTTP session [" + session.getId() + "]"));
        }
        super.logout(session);
    }
}

