/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeApacheAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IcCubeApacheGwtAuthenticationServletFilter
extends IcCubeApacheAuthenticationServletFilter {
    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    @Override
    protected void onBeforeFilterChain(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding("UTF-8");
        servletResponse.setCharacterEncoding("UTF-8");
        HttpSession session = ((HttpServletRequest)servletRequest).getSession(false);
        if (session == null) {
            return;
        }
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            if (servletRequest.getParameter("j_security_check_user") != null) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream());
                String userRoleInformation = IcCubeApacheGwtAuthenticationServletFilter.createUserRoleInformation(principal);
                String logoutDisabled = "";
                ((Writer)writer).append("user=").append(userRoleInformation).append("").close();
                if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                    OlapLoggers.AUTHENTICATION.debug((Object)("Apache GWT : user:" + userRoleInformation));
                }
                return;
            }
            if (servletRequest.getParameter("j_security_check_logout") != null) {
                this.performLogout((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                return;
            }
            if (servletRequest.getParameter("j_security_check") != null) {
                throw new ServletException("internal error : unexpected GWT security check (contact your administrator).");
            }
        } else {
            throw new ServletException("internal error : unexpected GWT request with no principal (contact your administrator).");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    protected void performLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        if (session != null) {
            OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
            if (principal != null) {
                if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                    OlapLoggers.SESSIONS.info((Object)("Apache GWT : icCube GWT session [" + session.getId() + "] logout for user [" + principal.getName() + "]"));
                }
            } else if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                OlapLoggers.SESSIONS.info((Object)("Apache GWT : icCube GWT session [" + session.getId() + "] logout for user [unknown]"));
            }
            session.invalidate();
        }
        this.onGwtLogout(request, response);
    }
}

