/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.B64Code;

public class IcCubeApacheAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (CdStringUtils.isNullOrBlank((String)credentials)) {
            throw new ServletException("icCube authentication [" + this.getAuthenticationServiceName() + "] error : missing user credentials");
        }
        credentials = credentials.substring(credentials.indexOf(32) + 1);
        credentials = B64Code.decode(credentials, "iso-8859-1");
        int semiColonPos = credentials.indexOf(58);
        String userName = credentials.substring(0, semiColonPos);
        if (CdStringUtils.isNullOrBlank((String)credentials)) {
            throw new ServletException("icCube authentication [" + this.getAuthenticationServiceName() + "] error : missing user credentials");
        }
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            if (this.isSameUser(principal, userName)) {
                this.onBeforeFilterChain((ServletRequest)request, response, filterChain);
            } else {
                session.invalidate();
            }
        } else {
            try {
                OlapPrincipal authenticatedPrincipal = this.authenticate("Apache HTTP Basic", IOlapProtocol.NA, request, userName, null, null);
                if (authenticatedPrincipal != null) {
                    session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                    this.onBeforeFilterChain((ServletRequest)request, response, filterChain);
                } else {
                    this.replyNotAuthorized(response, userName);
                }
            }
            catch (OlapPermissionsException ex) {
                OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
                this.replyNotAuthorized(response, userName);
            }
        }
    }

    protected void replyNotAuthorized(ServletResponse servletResponse, String userName) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String message = this.babylon.translate("userNotAuthorized", new Serializable[]{userName});
        String escaped = StringEscapeUtils.escapeHtml4((String)message);
        response.sendError(403, escaped);
    }

    protected void onBeforeFilterChain(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

