/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server;

import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.IcCubeServerWatcherListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.crac.Context;
import org.crac.Resource;
import org.jetbrains.annotations.Nullable;

public class IcCubeServerWatcher
implements Resource {
    public static final Logger LOGGER = OlapLoggers.FILE_WATCHER;
    @Nullable
    private final File lix;
    @Nullable
    private final File conf;
    private final IcCubeServerWatcherListener listener;
    private Impl impl;

    public IcCubeServerWatcher(@Nullable File lix, @Nullable File conf, IcCubeServerWatcherListener listener) {
        this.lix = lix;
        this.conf = conf;
        this.listener = listener;
        this.impl = new Impl(lix, conf, listener);
        CRaCUtils.register((Resource)this, (String)"File Watcher [%s][%s]".formatted(lix != null ? "license" : "", conf != null ? "configuration" : ""));
    }

    public void start() {
        this.impl.start();
    }

    public void shutdown() {
        this.impl.shutdown();
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] File Watcher before-checkpoint");
        this.impl.shutdown();
        this.impl = null;
        CRaCUtils.LOG.info("[CRaC] File Watcher before-checkpoint completed");
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] File Watcher after-restore");
        this.impl = new Impl(this.lix, this.conf, this.listener);
        CRaCUtils.LOG.info("[CRaC] File Watcher after-restore completed");
    }

    static class Impl {
        @Nullable
        private final WatchService watchService;
        private final IcCubeServerWatcherListener listener;
        private final String lixName;
        private final String confName;
        private final AtomicBoolean shutdown = new AtomicBoolean();
        private final AtomicReference<Thread> thread = new AtomicReference();

        public Impl(@Nullable File lix, @Nullable File conf, IcCubeServerWatcherListener listener) {
            List<Path> paths = Impl.setupPaths(lix, conf);
            WatchService watchService = null;
            if (!paths.isEmpty()) {
                try {
                    watchService = FileSystems.getDefault().newWatchService();
                    if (!Impl.register(watchService, paths)) {
                        IOUtils.closeQuietly((Closeable)watchService);
                        watchService = null;
                    }
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"[file-watcher] unexpected create error", (Throwable)ex);
                    watchService = null;
                }
            }
            this.watchService = watchService;
            this.listener = listener;
            this.lixName = lix != null ? lix.getName() : "";
            this.confName = conf != null ? conf.getName() : "";
            this.thread.set(null);
            this.shutdown.set(false);
        }

        private static List<Path> setupPaths(@Nullable File lix, @Nullable File conf) {
            ArrayList<Path> paths = new ArrayList<Path>();
            Impl.setupPath(paths, lix);
            Impl.setupPath(paths, conf);
            return paths;
        }

        private static void setupPath(List<Path> paths, @Nullable File file) {
            if (file == null) {
                return;
            }
            File pFile = file.getParentFile();
            if (pFile == null) {
                return;
            }
            Path fPath = pFile.toPath();
            boolean contained = false;
            try {
                for (Path path : paths) {
                    if (!Files.isSameFile(path, fPath)) continue;
                    contained = true;
                    break;
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)("[file-watcher] unexpected setup error [" + file.getAbsolutePath() + "]"), (Throwable)ex);
                contained = true;
            }
            if (!contained) {
                paths.add(fPath);
            }
        }

        private static boolean register(WatchService watchService, List<Path> paths) {
            boolean registered = false;
            for (Path path : paths) {
                try {
                    LOGGER.info((Object)("[file-watcher] watching : " + String.valueOf(path)));
                    path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    registered = true;
                }
                catch (IOException ex) {
                    LOGGER.error((Object)("[file-watcher] unexpected register error [" + String.valueOf(path) + "]"), (Throwable)ex);
                }
            }
            return registered;
        }

        public void start() {
            if (this.watchService != null) {
                this.thread.set(new Thread((Runnable)new Watcher(this), "watcher"));
                this.thread.get().start();
            }
        }

        public void shutdown() {
            block4: {
                if (this.shutdown.get()) {
                    return;
                }
                LOGGER.info((Object)"[file-watcher] shutting down");
                this.shutdown.set(true);
                if (this.watchService != null) {
                    try {
                        this.watchService.close();
                    }
                    catch (IOException ex) {
                        LOGGER.info((Object)"[file-watcher] unexpected close error", (Throwable)ex);
                        Thread thread = this.thread.get();
                        if (thread == null) break block4;
                        thread.interrupt();
                    }
                }
            }
            LOGGER.info((Object)"[file-watcher] shut down");
        }

        class Watcher
        implements Runnable {
            private final Set<String> toNotify;
            private Timer delayedNotificationTimer;
            final /* synthetic */ Impl this$0;

            Watcher(Impl this$0) {
                Impl impl = this$0;
                Objects.requireNonNull(impl);
                this.this$0 = impl;
                this.toNotify = new HashSet<String>();
            }

            @Override
            public void run() {
                LOGGER.info((Object)"[file-watcher] watching");
                while (true) {
                    try {
                        while (true) {
                            WatchKey watchKey;
                            Watchable watched;
                            if ((watched = (watchKey = this.this$0.watchService.take()).watchable()) instanceof Path) {
                                Path path = (Path)watched;
                                for (WatchEvent<?> event : watchKey.pollEvents()) {
                                    Object context = event.context();
                                    if (!(context instanceof Path)) continue;
                                    this.onChange(path, event.kind(), event.count(), (Path)context);
                                }
                            }
                            if (watchKey.reset()) continue;
                            watchKey.cancel();
                        }
                    }
                    catch (ClosedWatchServiceException ex) {
                        LOGGER.warn((Object)("[file-watcher] closed [" + this.this$0.shutdown.get() + "]"));
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn((Object)("[file-watcher] interrupted [" + this.this$0.shutdown.get() + "]"));
                        if (!this.this$0.shutdown.get()) continue;
                    }
                    break;
                }
                LOGGER.info((Object)"[file-watcher] watching done");
            }

            private void onChange(Path parent, WatchEvent.Kind<?> kind, int count, Path path) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[file-watcher] " + String.valueOf(kind) + "(" + count + ") " + String.valueOf(parent) + " - " + String.valueOf(path)));
                }
                File parentFile = parent.toFile();
                File file = path.toFile();
                String name = file.getName();
                if ((kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) && (this.this$0.lixName.equals(name) || this.this$0.confName.equals(name))) {
                    this.onFileChange(new File(parentFile, file.getName()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onFileChange(File file) {
                Set<String> set = this.toNotify;
                synchronized (set) {
                    boolean present;
                    boolean bl = present = !this.toNotify.add(file.getAbsolutePath());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[file-watcher] " + file.getName() + " (duplicated:" + present + ")"));
                    }
                    if (this.delayedNotificationTimer != null) {
                        this.delayedNotificationTimer.cancel();
                    }
                    this.delayedNotificationTimer = new Timer();
                    this.delayedNotificationTimer.schedule(new TimerTask(this){
                        final /* synthetic */ Watcher this$1;
                        {
                            Watcher watcher = this$1;
                            Objects.requireNonNull(watcher);
                            this.this$1 = watcher;
                        }

                        @Override
                        public void run() {
                            this.this$1.performNotifications();
                        }
                    }, 1000L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void performNotifications() {
                ArrayList<String> paths = new ArrayList<String>();
                Set<String> set = this.toNotify;
                synchronized (set) {
                    paths.addAll(this.toNotify);
                    this.toNotify.clear();
                }
                for (String path : paths) {
                    if (!path.endsWith(this.this$0.lixName)) continue;
                    LOGGER.info((Object)("[file-watcher] " + path));
                    this.this$0.listener.onLixChange(new File(path));
                }
            }
        }
    }
}

