/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.common.runtime.CdEnvironment;
import crazydev.common.security.AESCryptoEncoder;
import crazydev.common.security.CdPassword;
import crazydev.common.stream.CdInfoLogPrintStream;
import crazydev.common.utils.CdLog4jUtils;
import crazydev.common.utils.CdPasswordUtils;
import crazydev.common.utils.CdResourceUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.version.CdVersion;
import crazydev.common.xml.CdPasswordXmlAdapter;
import crazydev.iccube.authorization.definition.application.OlapRoleDefinitionHelper;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaRegularPermissionBuilder;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactoryJaxbHelper;
import crazydev.iccube.builder.model.builders.facts.cache.N_FactPageResolvedMembersCache;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.cluster.master.schema.M_SchemaSubCubeFactory;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.info.OlapLixVerifier;
import crazydev.iccube.info.OlapMissingLixContent;
import crazydev.iccube.notification.OlapNotificationDefaultService;
import crazydev.iccube.notification.OlapNotificationNopService;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.notification.OlapNotificationServiceException;
import crazydev.iccube.notification.definition.OlapNotificationServiceDefinition;
import crazydev.iccube.notification.definition.OlapNotificationTransportServiceDefinition;
import crazydev.iccube.notification.transporter.OlapNotificationTransportService;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.pub.utils.ic3CSRFUtils;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.runtime.OlapRuntimeFactory;
import crazydev.iccube.server.IcCubeServerHelper;
import crazydev.iccube.server.IcCubeServerListener;
import crazydev.iccube.server.IcCubeServerLoggerErrorHandler;
import crazydev.iccube.server.IcCubeServerWatcher;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.http.IcCube404Servlet;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromeLauncher;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.ux.common.table.UxTableOptions;
import jakarta.xml.bind.JAXBException;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.help.HelpFormatter;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.crac.Resource;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeServer {
    public static final Logger LOGGER = OlapLoggers.SERVER;
    private static final OlapBabylonService babylon = new OlapBabylonService(Locale.getDefault());
    @Nullable
    public static IcCubeServerListener listener;
    public static volatile boolean stopping;
    public static IcCubeEngine engine;
    public static CdFatalErrorHandler fatalErrorHandler;
    static boolean processCommandLine;
    private static IcCubeServerWatcher watcher;

    public static void main(String[] args) {
        IcCubeServer.start_main(args);
    }

    public static void start_main(String[] args) {
        if (processCommandLine) {
            IcCubeServer.processCommandLineOptions(args);
        }
        try {
            OlapRuntime runtime;
            IcCubeServerConfiguration configuration;
            boolean fatalErrorExit;
            String envFatalErrorExit;
            CdLog4jUtils.configure((Level)Level.DEBUG);
            Logger.getLogger((String)"org.eclipse.jetty").setLevel(org.apache.log4j.Level.INFO);
            Logger.getLogger((String)"oshi").setLevel(org.apache.log4j.Level.INFO);
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] Log4j (console) initialized");
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            String sysPropFatalErrorExit = System.getProperty("icCube.fatalError.exit");
            if ("false".equalsIgnoreCase(sysPropFatalErrorExit)) {
                fatalErrorHandler.fatalErrorExit(false);
            }
            if ("false".equalsIgnoreCase(envFatalErrorExit = CdEnvironment.getEnv((String)"ICCUBE_FATAL_ERROR_EXIT"))) {
                fatalErrorHandler.fatalErrorExit(false);
            }
            if (!(fatalErrorExit = (configuration = IcCubeServerHelper.getServerConfiguration(listener, runtime = OlapRuntimeFactory.create())).getProperties().isFatalErrorExit())) {
                fatalErrorHandler.fatalErrorExit(false);
            }
            if (!fatalErrorHandler.isFatalErrorExit()) {
                OlapLoggers.SERVER.info((Object)"[startup] fatalErrorExit = false");
            }
            OlapLoggers.SERVER.info((Object)"[startup] create directories");
            OlapDirectories directories = OlapDirectories.create((OlapRuntime)runtime, (boolean)configuration.isWithMultiTenant(), (OlapDirectoriesConfiguration)configuration.getDirectories());
            OlapLixContent lixContent = IcCubeServer.setupLixContent(fatalErrorHandler, runtime, directories);
            if (lixContent.isMissing()) {
                IcCube404Servlet.missing = true;
            }
            IcCubeServer.logLixContext(lixContent);
            IcCubeServerLoggerErrorHandler.fatalErrorHandler = fatalErrorHandler;
            IcCubeServerHelper.configureLog4j(listener, runtime, directories);
            CRaCUtils.register((Resource)CdLog4jUtils.CRAC, (String)"Log4j");
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] Log4j initialized");
            OlapOOM.setupUncaughtException();
            OlapOOM.setupLog4J();
            AESCryptoEncoder.assertValidity();
            boolean withMultiTenant = lixContent.isMultiTenantAvailable() && configuration.isWithMultiTenant();
            OlapLoggers.SERVER.info((Object)"[startup] validate the configuration");
            configuration.validate(runtime, withMultiTenant);
            IcCubeServerProperties properties = configuration.getProperties();
            UxTableOptions.UX_DEFAULT_PAGE_SIZE = properties.getUxPaginationPageSize();
            UxTableOptions.UX_DEFAULT_PAGE_SIZES = properties.getUxPaginationPageSizes();
            if (properties.isUnmapOff()) {
                CdSystemUtils.UNMAP_ACTIVATED = false;
            }
            if (properties.isSingleMeasureDimensionalityOff()) {
                OlapTupleDimensionalityHelper.SINGLE_MEASURE_DIMENSIONALITY_OFF = true;
            }
            if (properties.isNonMappedPermissionsOff()) {
                M_SchemaSubCubeFactory.NON_MAPPED_PERMISSIONS_ACTIVATED = false;
            }
            if (properties.isSchemaPermissionsCacheOff()) {
                OlapRoleFlatSchemaRegularPermissionBuilder.SCHEMA_PERMISSIONS_CACHE_ACTIVATED = false;
            }
            OlapEngineComponentConfiguration eConfiguration = configuration.getOlapEngineConfiguration();
            OlapProperties eProperties = eConfiguration.getProperties();
            OlapFactColumnSumDoubleAggregator.SUM_ALGO = eProperties.getMdxSumAlgo();
            N_FactPageResolvedMembersCache.LRU_MAX_SIZE = eProperties.getFactsResolveMemberLruCacheSize();
            OlapComparableVectorEntity.SMALL_CONTENT_MAX_SIZE = eProperties.getPivotTableCellVectorFValueGviSize();
            OlapBuilderBaseHierarchy.DEFAULT_ALL_LEVEL_NAME = eProperties.getDefaultHierarchyAllLevelName();
            OlapBuilderBaseHierarchy.DEFAULT_ALL_MEMBER_NAME = eProperties.getDefaultHierarchyAllMemberName();
            if (properties.isLoginFormRedirect()) {
                IcCubeAbstractAuthenticationServletFilter.LOGIN_REDIRECT_ACTIVATED = true;
            }
            IcCubeServerHelper.recapConfiguration(runtime, configuration, directories);
            IcCubeServerProperties serverProperties = configuration.getProperties();
            OlapNotificationService notificationService = IcCubeServer.setupNotificationService(lixContent, configuration);
            CdLanguageIdentifierHelper.setup();
            OlapBuilderSchemaDefFactoryJaxbHelper.registerJaxbListeners();
            OlapRoleDefinitionHelper.registerJaxbListeners();
            OlapScalarOperators.register();
            OlapIntrinsicMemberProperties.register();
            IcCubePrintComponentConfiguration printComponentConfiguration = configuration.getPrintConfiguration();
            if (printComponentConfiguration == null || !"ic3-print-server".equals(printComponentConfiguration.getExec())) {
                IcCubeChromeLauncher.initialize();
            }
            if (listener != null) {
                listener.onBeforeCreateAndSetup(directories);
            }
            engine = IcCubeEngine.createAndSetup(fatalErrorHandler, lixContent, notificationService, runtime, configuration, directories, withMultiTenant);
            if (listener != null && !listener.onBeforeStart(engine)) {
                return;
            }
            IcCubeServer.setupSystemTray(engine);
            boolean disableLoadOnStartupSchema = lixContent.isMissing() || serverProperties.isDisableLoadOnStartupSchema();
            engine.start(listener, !disableLoadOnStartupSchema);
            if (listener != null) {
                listener.onStarted(engine);
            }
            notificationService.onServerReady();
            watcher = new IcCubeServerWatcher(OlapLixVerifier.file(), configuration.getXmlFile(), IcCubeServer::onLixChange);
            watcher.start();
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)"Unexpected icCube error", (Throwable)ex);
            fatalErrorHandler.handle((Throwable)ex, -1);
        }
    }

    private static void processCommandLineOptions(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "print this message");
        options.addOption("p", "password", true, "generate an obfuscated password");
        options.addOption("pb", "password.builder", true, "generate an obfuscated password (schema builder)");
        options.addOption("cat", "csrf.acceptToken", true, null);
        try {
            String str;
            DefaultParser cmdLineParser = new DefaultParser();
            CommandLine cmdLine = cmdLineParser.parse(options, args);
            if (cmdLine.hasOption("h")) {
                try {
                    HelpFormatter formatter = HelpFormatter.builder().get();
                    formatter.printHelp("icCube", "", options, "", false);
                }
                catch (IOException formatter) {
                    // empty catch block
                }
                System.exit(0);
            }
            if (cmdLine.hasOption("p")) {
                str = cmdLine.getOptionValue("password");
                System.out.println(CdPasswordUtils.obfuscate((String)str));
                System.exit(0);
            }
            if (cmdLine.hasOption("pb")) {
                str = cmdLine.getOptionValue("password.builder");
                System.out.println(new CdPasswordXmlAdapter().marshal(new CdPassword(str, null)));
                System.exit(0);
            }
            if (cmdLine.hasOption("cat")) {
                str = cmdLine.getOptionValue("csrf.acceptToken");
                ic3CSRFUtils.WHITE_LIST.add(str);
            }
        }
        catch (ParseException ex) {
            System.out.println("command line error : " + ex.getMessage());
            try {
                HelpFormatter formatter = HelpFormatter.builder().get();
                formatter.printHelp("icCube", "", options, "", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    public static void shutdown() {
        if (stopping) {
            return;
        }
        LOGGER.info((Object)"icCube is shutting down ------------------------------------------------ ");
        stopping = true;
        if (watcher != null) {
            watcher.shutdown();
            watcher = null;
        }
        if (engine != null) {
            engine.shutdown();
            engine = null;
        }
        LOGGER.info((Object)"icCube bye ------------------------------------------------------------- ");
        CdLog4jUtils.shutdown();
    }

    private static MenuItem createLaunch(boolean uxActive, Locale locale, String tag, @Nullable String init, String protocol, int port) {
        return IcCubeServer.createLaunchUx(locale, tag, init, protocol, port);
    }

    private static MenuItem createLaunchUx(Locale locale, String tag, String init, String protocol, int port) {
        MenuItem mi = new MenuItem(babylon.translate(tag, new Serializable[0]));
        mi.addActionListener(e -> {
            try {
                String url = protocol + "://localhost:" + port + "/icCube/console" + (String)(init == null ? "" : "/" + init);
                IcCubeServer.addTryIconMenuItem(url);
            }
            catch (IOException ex) {
                LOGGER.warn((Object)"Could not launch icCube WEB Interface", (Throwable)ex);
            }
        });
        return mi;
    }

    private static MenuItem createLaunchDashboards(Locale locale, String tag, String protocol, int port) {
        MenuItem mi = new MenuItem(babylon.translate(tag, new Serializable[0]));
        mi.addActionListener(e -> {
            try {
                IcCubeServer.addTryIconMenuItem(protocol + "://localhost:" + port + "/icCube/report/console");
            }
            catch (IOException ex) {
                LOGGER.warn((Object)"Could not launch icCube WEB Dashboards", (Throwable)ex);
            }
        });
        return mi;
    }

    private static void addTryIconMenuItem(String url) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            Runtime.getRuntime().exec(new String[]{"xdg-open", url});
        } else {
            Desktop.getDesktop().browse(URI.create(url));
        }
    }

    private static void setupSystemTray(IcCubeEngine engine) {
        try {
            if (engine.supportSystemTray()) {
                IcCubeServerConfiguration configuration = engine.getConfiguration();
                IcCubeServerProperties serverProperties = configuration.getProperties();
                IcCubeServer.doSetupSystemTray(engine.isUxActive(), engine.getLocale(), serverProperties.isSystemTrayIcon(), configuration.getHttpConfiguration());
            }
        }
        catch (Throwable ex) {
            OlapLoggers.SERVER.warn((Object)"[AWT] could not setup the system tray", ex);
        }
    }

    private static void doSetupSystemTray(boolean uxActive, Locale locale, boolean withSystemTrayIcon, @Nullable IcCubeHttpComponentConfiguration configuration) {
        if (!withSystemTrayIcon || System.getProperty("icCube.hideSystemTray") != null || System.getenv("ICCUBE_HIDE_SYSTEM_TRAY") != null) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        PopupMenu popupMenu = new PopupMenu();
        if (configuration != null) {
            int httpPortNumber = configuration.getPortNumber();
            if (httpPortNumber == -1) {
                httpPortNumber = configuration.getSslPortNumber();
            }
            if (httpPortNumber != -1) {
                popupMenu.add(IcCubeServer.createLaunch(uxActive, locale, "icCubeServerLaunchBrowserHttp", null, "http", httpPortNumber));
                if (uxActive) {
                    popupMenu.add(IcCubeServer.createLaunch(uxActive, locale, "icCubeServerLaunchBrowserBuilderHttp", "builder", "http", httpPortNumber));
                    popupMenu.add(IcCubeServer.createLaunch(uxActive, locale, "icCubeServerLaunchBrowserAdminHttp", "admin", "http", httpPortNumber));
                    popupMenu.add(IcCubeServer.createLaunch(uxActive, locale, "icCubeServerLaunchBrowserMDXHttp", "mdx", "http", httpPortNumber));
                }
                popupMenu.add(IcCubeServer.createLaunchDashboards(locale, "icCubeServerLaunchDashboardsHttp", "http", httpPortNumber));
            }
            MenuItem stop = new MenuItem(babylon.translate("shutdown", new Serializable[0]));
            stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int choice = JOptionPane.showConfirmDialog(null, babylon.translate("icCubeServerShutdownConfirmation", new Serializable[0]), babylon.translate("icCubeServerShutdownTitle", new Serializable[0]), 0);
                    if (choice == 0) {
                        LOGGER.info((Object)"icCube requested to shutdown!");
                        System.exit(0);
                    }
                }
            });
            popupMenu.addSeparator();
            popupMenu.add(stop);
        }
        try {
            String os = System.getProperty("os.name").toLowerCase();
            boolean isLinux = os.contains("linux");
            Dimension trayIconSize = tray.getTrayIconSize();
            LOGGER.info((Object)("Tray Icon size (H-W):" + trayIconSize.getHeight() + "x" + trayIconSize.getWidth()));
            String filename = !isLinux ? (trayIconSize.getWidth() == 16.0 ? "icCubeTrayIcon16.png" : "icCubeTrayIcon32.png") : "icCubeTrayIcon-linux.png";
            URL imageURL = CdResourceUtils.getResourceAsURL(IcCubeServer.class, (String)filename);
            Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
            CdVersion version = IcCubeServerVersion.get();
            TrayIcon trayIcon = new TrayIcon(image, "icCube " + version.asString(), popupMenu);
            trayIcon.setImageAutoSize(true);
            tray.add(trayIcon);
        }
        catch (AWTException ex) {
            LOGGER.warn((Object)"No system tray available!", (Throwable)ex);
        }
    }

    private static OlapLixContent setupLixContent(CdFatalErrorHandler fatalErrorHandler, OlapRuntime runtime, OlapDirectories directories) {
        File lix = IcCubeServer.getLixFileFromSysProp();
        if (lix != null) {
            return IcCubeServer.setupLixContent(fatalErrorHandler, lix);
        }
        lix = IcCubeServer.getLixFileFromEnv();
        if (lix != null) {
            return IcCubeServer.setupLixContent(fatalErrorHandler, lix);
        }
        lix = IcCubeServer.getLixFileFromInstallDirectory(runtime);
        if (lix.exists()) {
            return IcCubeServer.setupLixContent(fatalErrorHandler, lix);
        }
        lix = IcCubeServer.getLixFileFromDataDirectory(directories);
        if (lix.exists()) {
            CdFatalErrorHandler nonFatalErrorHandler = new CdFatalErrorHandler(false);
            OlapLixContent lic = IcCubeServer.setupLixContent(nonFatalErrorHandler, lix);
            if (!lic.isMissing()) {
                lic.renewal.set(true);
            }
            return lic;
        }
        OlapLoggers.SERVER.info((Object)"[startup] icCube.lic file [missing]");
        return OlapMissingLixContent.instance();
    }

    private static OlapLixContent setupLixContent(CdFatalErrorHandler fatalErrorHandler, File lix) {
        OlapLoggers.SERVER.info((Object)("[startup] icCube.lic file [" + lix.getAbsolutePath() + "]"));
        OlapLixContent lixContent = OlapLixVerifier.verify((CdFatalErrorHandler)fatalErrorHandler, (File)lix, (boolean)true);
        if (lixContent == null) {
            OlapLoggers.SERVER.info((Object)"[startup] icCube.lic file [missing] on fatal-error not exiting");
            return OlapMissingLixContent.instance();
        }
        return lixContent;
    }

    @Nullable
    private static File getLixFileFromSysProp() {
        String fileName = System.getProperty("icCube.license.file");
        OlapLoggers.SERVER.info((Object)("[startup] looking icCube.lic from SYSTEM PROPERTY [icCube.license.file] [" + fileName + "]"));
        if (CdStringUtils.isNullOrBlank((String)fileName)) {
            return null;
        }
        return new File(fileName);
    }

    @Nullable
    private static File getLixFileFromEnv() {
        String fileName = CdEnvironment.getEnv((String)"ICCUBE_LICENSE");
        OlapLoggers.SERVER.info((Object)("[startup] looking icCube.lic from ENVIRONMENT variable [ICCUBE_LICENSE] [" + fileName + "]"));
        if (CdStringUtils.isNullOrBlank((String)fileName)) {
            return null;
        }
        return new File(fileName);
    }

    private static File getLixFileFromInstallDirectory(OlapRuntime runtime) {
        File lix = new File(runtime.getInstallBinDirectory(), OlapLixContent.NAME);
        OlapLoggers.SERVER.info((Object)("[startup] looking icCube.lic from install/bin directory [" + lix.getAbsolutePath() + "]"));
        return lix;
    }

    private static File getLixFileFromDataDirectory(OlapDirectories directories) {
        File lix = new File(directories.getDataDirectory__(), OlapLixContent.NAME);
        OlapLoggers.SERVER.info((Object)("[startup] looking icCube.lic from ~/icCube-data directory [" + lix.getAbsolutePath() + "]"));
        return lix;
    }

    @Nullable
    private static OlapLixContent setupLixContentOnChange(File lix) {
        OlapLixContent lixContent = OlapLixVerifier.verifyOnChange((File)lix, (boolean)true);
        IcCubeServer.logLixContext(lixContent);
        return lixContent;
    }

    private static void logLixContext(@Nullable OlapLixContent lixContent) {
        if (lixContent != null) {
            CdInfoLogPrintStream out = new CdInfoLogPrintStream(OlapLoggers.SERVER);
            Map values = OlapLixVerifier.createInfos((CdBabylonService)OlapBabylonService.ENGLISH, (OlapLixContent)lixContent);
            out.println();
            out.println("-- license -----");
            out.println();
            int maxLen = 0;
            for (Map.Entry entry : values.entrySet()) {
                maxLen = Math.max(maxLen, ((String)entry.getKey()).length());
            }
            for (Map.Entry entry : values.entrySet()) {
                out.printf("  %" + maxLen + "s : %s%n", entry.getKey(), entry.getValue());
            }
            out.println();
        }
    }

    private static void onLixChange(File lix) {
        OlapLixContent lixContent = null;
        try {
            lixContent = IcCubeServer.setupLixContentOnChange(lix);
        }
        catch (RuntimeException ex) {
            OlapLoggers.SERVER.error((Object)"[watcher] unexpected error", (Throwable)ex);
        }
        if (lixContent == null) {
            return;
        }
        if (engine != null) {
            engine.onLixChange(lix, lixContent);
        }
    }

    private static OlapNotificationService setupNotificationService(Object lix, IcCubeServerConfiguration configuration) {
        OlapLoggers.SERVER.info((Object)"[notification] configuration started");
        OlapLixContent lixContent = (OlapLixContent)lix;
        if (!lixContent.isNotificationAvailable()) {
            OlapLoggers.SERVER.info((Object)"[notification] notification service not configured.");
            return new OlapNotificationNopService();
        }
        File icCubeXml = configuration.getXmlFile();
        if (icCubeXml == null) {
            OlapLoggers.SERVER.info((Object)"[notification] notification service not configured (no icCube-notification.xml file).");
            return new OlapNotificationNopService();
        }
        Object icCubeNotificationXmlName = "icCube-notification.xml";
        String icCubeXmlName = icCubeXml.getName();
        if (icCubeXmlName.endsWith(".xml")) {
            icCubeNotificationXmlName = icCubeXmlName.substring(0, icCubeXmlName.length() - 4) + "-notification.xml";
        }
        File icCubeNotificationXml = new File(icCubeXml.getParentFile(), (String)icCubeNotificationXmlName);
        OlapLoggers.SERVER.info((Object)("[notification] notification service configuration file [" + icCubeNotificationXml.getAbsolutePath() + "]"));
        if (icCubeNotificationXml.isDirectory() | !icCubeNotificationXml.exists()) {
            OlapLoggers.SERVER.info((Object)"[notification] notification service not configured (icCube-notification.xml does not exist).");
            return new OlapNotificationNopService();
        }
        OlapNotificationServiceDefinition definition = IcCubeServer.setupNotificationServiceDefinition(icCubeNotificationXml);
        List<OlapNotificationTransportService> services = IcCubeServer.setupTransporterServices(definition);
        String serverId = configuration.getId();
        OlapNotificationDefaultService service = new OlapNotificationDefaultService(serverId, services);
        try {
            service.configure(definition);
            OlapLoggers.SERVER.info((Object)"[notification] configuration done");
            return service;
        }
        catch (OlapNotificationServiceException ex) {
            throw new RuntimeException("icCube notification configuration error", ex);
        }
    }

    private static OlapNotificationServiceDefinition setupNotificationServiceDefinition(File xml) {
        try {
            return OlapNotificationServiceDefinition.parseFromXml((File)xml);
        }
        catch (JAXBException | IOException ex) {
            throw new RuntimeException("icCube notification definition error", ex);
        }
    }

    private static List<OlapNotificationTransportService> setupTransporterServices(OlapNotificationServiceDefinition definition) {
        OlapLoggers.SERVER.info((Object)"[notification] transport services configuration started");
        HashSet<String> serviceUUIDs = new HashSet<String>();
        ArrayList<OlapNotificationTransportService> services = new ArrayList<OlapNotificationTransportService>();
        List configurations = definition.getServices();
        if (configurations == null || configurations.isEmpty()) {
            OlapLoggers.SERVER.info((Object)"[notification] no transport service configuration available");
            return services;
        }
        OlapLoggers.SERVER.info((Object)("[notification] configuration of " + configurations.size() + " transport service(s)"));
        try {
            int idx = 1;
            for (OlapNotificationTransportServiceDefinition configuration : configurations) {
                OlapLoggers.SERVER.info((Object)("[notification] transport service [" + idx + "] configuration"));
                configuration.validate();
                if (serviceUUIDs.contains(configuration.getId())) {
                    throw new RuntimeException("icCube transport service error : duplicate id [" + configuration.getId() + "]");
                }
                String serviceClass = configuration.getServiceClass();
                OlapLoggers.SERVER.info((Object)("[notification] transport service [" + configuration.getId() + "] service-class [" + serviceClass + "]"));
                Class<?> clazz = Class.forName(serviceClass);
                if (!OlapNotificationTransportService.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("icCube transport service error : type mismatch (expected:" + OlapNotificationTransportService.class.getName() + ") (actual:" + clazz.getName() + ")");
                }
                OlapNotificationTransportService service = (OlapNotificationTransportService)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                OlapLoggers.SERVER.info((Object)("[notification] transport service [" + configuration.getId() + "] configure started"));
                service.configure(configuration);
                OlapLoggers.SERVER.info((Object)("[notification] transport service [" + configuration.getId() + "] configuration done"));
                services.add(service);
                serviceUUIDs.add(configuration.getId());
                ++idx;
            }
            return services;
        }
        catch (OlapConfigurationException | OlapNotificationServiceException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("icCube transport service error", ex);
        }
    }

    static {
        stopping = false;
        fatalErrorHandler = new CdFatalErrorHandler(){

            public void handle(Throwable error, int exitCode) {
                if (!GraphicsEnvironment.isHeadless()) {
                    try {
                        this.showDialogBox(error);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                super.handle(error, exitCode);
            }

            public void handle(String error, int exitCode) {
                if (!GraphicsEnvironment.isHeadless()) {
                    try {
                        this.showDialogBox(error);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                super.handle(error, exitCode);
            }

            private void showDialogBox(String error) {
                JLabel label0 = new JLabel(babylon.translate("icCubeServerFatalError", new Serializable[0]));
                JTextField message0 = new JTextField(error);
                message0.setEditable(false);
                message0.setBorder(null);
                JLabel label1 = new JLabel(babylon.translate("icCubeServerMoreDetails", new Serializable[0]));
                JTextField message1 = new JTextField(IcCubeEngineHelper.getLogDirectoryValue());
                message1.setEditable(false);
                message1.setBorder(null);
                JPanel errorPanel = new JPanel();
                errorPanel.setLayout(new BoxLayout(errorPanel, 3));
                errorPanel.add(label0);
                errorPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                errorPanel.add(message0);
                errorPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                errorPanel.add(label1);
                errorPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                errorPanel.add(message1);
                errorPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                JOptionPane.showMessageDialog(null, errorPanel, babylon.translate("icCubeServerFatalErrorTitle", new Serializable[0]), 0);
            }

            private void showDialogBox(Throwable error) {
                this.showDialogBox(error.getMessage());
            }
        };
        processCommandLine = true;
        CdLog4jUtils.init();
        System.setProperty("log4j.defaultInitOverride", "true");
    }

    public static final class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("ShutdownHook");
        }

        @Override
        public void run() {
            if (!CdLog4jUtils.shutdown) {
                LOGGER.info((Object)"icCube shutdown hook");
            }
            IcCubeServer.shutdown();
        }
    }
}

